/*
 * Decompiled with CFR 0.152.
 */
package journeymap.server.oldservercode.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import journeymap.common.Journeymap;
import journeymap.server.oldservercode.config.ConfigHandler;
import journeymap.server.oldservercode.network.PacketManager;

public class WorldIDPacket
implements IMessage {
    private String worldID;

    public WorldIDPacket() {
    }

    public WorldIDPacket(String worldID) {
        this.worldID = worldID;
    }

    public String getWorldID() {
        return this.worldID;
    }

    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
        try {
            if (this.worldID != null) {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.worldID);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to read message: " + t);
        }
    }

    public static class WorldIdListener
    implements IMessageHandler<WorldIDPacket, IMessage> {
        public IMessage onMessage(WorldIDPacket message, MessageContext ctx) {
            if (ctx.side == Side.SERVER && ConfigHandler.getConfigByWorldName(ctx.getServerHandler().field_147369_b.func_130014_f_().func_72912_H().func_76065_j()).isUsingWorldID()) {
                String worldName = ctx.getServerHandler().field_147369_b.func_130014_f_().func_72912_H().func_76065_j();
                String worldID = ConfigHandler.getConfigByWorldName(worldName).getWorldID();
                PacketManager.instance.sendPlayerWorldID(worldID, ctx.getServerHandler().field_147369_b.func_70005_c_());
            }
            return null;
        }
    }
}

