/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.webmap.routes;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.webmap.Resources;
import journeymap.client.webmap.WebMap;
import journeymap.common.Journeymap;
import journeymap.shadow.io.javalin.http.ContentType;
import journeymap.shadow.io.javalin.http.Context;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class Resource {
    public static final Logger logger = Journeymap.getLogger();

    public static void get(Context ctx) {
        BufferedImage img;
        String extension;
        String resource = ctx.queryParam("resource");
        if (resource == null || resource.equals("undefined")) {
            return;
        }
        ResourceLocation resourceLocation = new ResourceLocation(resource);
        String string = extension = resource.split("\\.").length > 1 ? resource.split("\\.")[resource.split("\\.").length - 1] : "";
        if (extension.contains(":")) {
            extension = extension.split(":")[0];
        }
        try {
            if (!resourceLocation.func_110624_b().contains("journeymap")) {
                img = TextureCache.instance().getEntityIconTexture(JourneymapClient.getWebMapProperties().getEntityIconSetName().get(), resource).getImage();
                InputStream is = FileHandler.getIconStream("/assets/journeymap/icon/entity", JourneymapClient.getWebMapProperties().getEntityIconSetName().get(), resource);
                if (img == null && is != null) {
                    ctx.contentType(ContentType.IMAGE_PNG);
                    ctx.result(is);
                    return;
                }
            } else {
                img = ImageIO.read(Resources.getResourceAsStream(resourceLocation));
            }
        }
        catch (FileNotFoundException e) {
            logger.warn("File at resource location not found: " + resource);
            ctx.status(404);
            try {
                img = ImageIO.read(WebMap.class.getResource("/assets/journeymap/web/img/marker-dot-32.png"));
            }
            catch (Exception ex) {
                logger.warn("image not found {}", new Object[]{"/assets/journeymap/web/img/marker-dot-32.png"});
                return;
            }
        }
        catch (IOException e) {
            logger.info("Connection closed while writing image response. Webmap probably reloaded.");
            return;
        }
        catch (Exception e) {
            logger.error("Exception thrown while retrieving resource at location: " + resource, (Throwable)e);
            ctx.status(500);
            try {
                img = ImageIO.read(WebMap.class.getResource("/assets/journeymap/web/img/marker-dot-32.png"));
            }
            catch (Exception ex) {
                logger.warn("image not found {}", new Object[]{"/assets/journeymap/web/img/marker-dot-32.png"});
                return;
            }
        }
        ctx.contentType("image/" + extension);
        try {
            ImageIO.write((RenderedImage)img, extension, ctx.res.getOutputStream());
            ctx.res.getOutputStream().flush();
        }
        catch (Exception e) {
            logger.warn("image not found {}", new Object[]{resource});
        }
    }
}

