/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.util;

import com.gtnewhorizon.gtnhlib.client.renderer.quad.properties.ModelQuadFacing;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class DirectionUtil {
    public static final ForgeDirection[] ALL_DIRECTIONS = ForgeDirection.values();
    public static final ForgeDirection[] HORIZONTAL_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.EAST};
    public static final Vector3i[] STEP = new Vector3i[]{new Vector3i(0, -1, 0), new Vector3i(0, 1, 0), new Vector3i(0, 0, -1), new Vector3i(0, 0, 1), new Vector3i(-1, 0, 0), new Vector3i(1, 0, 0), new Vector3i(0, 0, 0)};

    public static ForgeDirection rotateDir(ForgeDirection in, Matrix4f rotMat) {
        Vector3f v = new Vector3f(in.offsetX, in.offsetY, in.offsetZ);
        v.mulPosition(rotMat);
        return ModelQuadFacing.toDirection(ModelQuadFacing.fromVector(v));
    }

    public static ForgeDirection fromName(String name) {
        ForgeDirection forgeDirection;
        switch (name) {
            case "up": {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case "down": {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case "north": {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case "south": {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case "west": {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case "east": {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            case "unknown": {
                forgeDirection = ForgeDirection.UNKNOWN;
                break;
            }
            default: {
                forgeDirection = null;
            }
        }
        return forgeDirection;
    }
}

