/*
 * Decompiled with CFR 0.152.
 */
package makamys.mclib.core;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import makamys.mclib.core.InternalModules;
import makamys.mclib.core.TaskQueue;
import makamys.mclib.core.sharedstate.SharedLibHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCLib {
    public static final String VERSION = "0.3.7.6";
    public static final String RESOURCES_VERSION = "v0_3_7";
    public static MCLib instance;
    public static Logger LOGGER;
    public static final Logger GLOGGER;
    public static EventBus FML_MASTER;

    public MCLib(boolean subscribe) {
        String modid = Loader.instance().activeModContainer().getModId();
        LOGGER = LogManager.getLogger((String)("mclib(" + modid + ")"));
        LOGGER.debug("Initializing MCLib 0.3.7.6 in " + modid);
        SharedLibHelper.register(this);
        if (subscribe) {
            try {
                LoadController lc = (LoadController)ReflectionHelper.getPrivateValue(Loader.class, (Object)Loader.instance(), (String[])new String[]{"modController"});
                FML_MASTER = (EventBus)ReflectionHelper.getPrivateValue(LoadController.class, (Object)lc, (String[])new String[]{"masterChannel"});
                FML_MASTER.register((Object)this);
            }
            catch (Exception e) {
                LOGGER.error("Failed to subscribe to LoadController's bus. The state change event handlers will have to be called manually from your mod.");
                e.printStackTrace();
            }
        }
    }

    public static void init() {
        if (instance == null) {
            MCLib.init(true);
        }
    }

    public static void init(boolean subscribe) {
        instance = new MCLib(subscribe);
    }

    @Subscribe
    public void onPreInit(FMLPreInitializationEvent event) {
        if (SharedLibHelper.isNewestLib(this)) {
            LOGGER.trace("Running preinit");
            InternalModules.sloppyDepLoader.preInit();
        }
        TaskQueue.consume(LoaderState.PREINITIALIZATION, instance);
    }

    static {
        LOGGER = LogManager.getLogger((String)"mclib()");
        GLOGGER = LogManager.getLogger((String)"mclib");
    }
}

