/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.recipes;

import ganymedes01.etfuturum.configuration.configs.ConfigFunctions;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.core.utils.ItemStackSet;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;

public class SmokerRecipes {
    private static final SmokerRecipes smeltingBase = new SmokerRecipes();
    private boolean reloadingCT;
    public final ItemStackMap<ItemStack> smeltingList = new ItemStackMap();
    public final ItemStackMap<Float> experienceList = new ItemStackMap();
    public final ItemStackSet smeltingBlacklist = new ItemStackSet();
    public final ItemStackMap<ItemStack> smeltingListCache = new ItemStackMap();
    public final ItemStackMap<Float> experienceListCache = new ItemStackMap();

    public static SmokerRecipes smelting() {
        return smeltingBase;
    }

    public void clearLists() {
        this.smeltingListCache.clear();
        this.experienceListCache.clear();
    }

    public void setReloadingCT(boolean val) {
        this.reloadingCT = val;
    }

    public ItemStack getSmeltingResult(ItemStack input) {
        if (this.smeltingBlacklist.contains(input)) {
            return null;
        }
        if (!this.smeltingListCache.containsKey(input)) {
            ItemStack result;
            if (!this.smeltingList.containsKey(input) && this.canAdd(input, result = FurnaceRecipes.func_77602_a().func_151395_a(input))) {
                if (!this.reloadingCT) {
                    this.smeltingListCache.put(input, result);
                }
                return result;
            }
            ItemStack CTResult = this.smeltingList.get(input);
            if (!this.reloadingCT) {
                this.smeltingListCache.put(input, CTResult);
            }
            return CTResult;
        }
        return this.smeltingListCache.get(input);
    }

    public float getSmeltingExperience(ItemStack result) {
        float ret = result.func_77973_b().getSmeltingExperience(result);
        if (ret != -1.0f) {
            return ret;
        }
        if (!this.experienceListCache.containsKey(result)) {
            if (!this.experienceList.containsKey(result)) {
                float exp = FurnaceRecipes.func_77602_a().func_151398_b(result);
                if (!this.reloadingCT) {
                    this.experienceListCache.put(result, Float.valueOf(exp));
                }
                return exp;
            }
            float expCT = this.experienceList.get(result).floatValue();
            if (!this.reloadingCT) {
                this.experienceListCache.put(result, Float.valueOf(expCT));
            }
            return expCT;
        }
        return this.experienceListCache.get(result).floatValue();
    }

    public void addRecipe(ItemStack input, ItemStack output, float exp) {
        this.smeltingList.put(input, output);
        this.experienceList.put(output, Float.valueOf(exp));
        this.smeltingBlacklist.remove(input);
    }

    public void removeRecipe(ItemStack input) {
        this.experienceList.remove(this.smeltingList.get(input));
        this.smeltingList.remove(input);
        this.smeltingBlacklist.add(input);
    }

    public boolean canAdd(ItemStack input, ItemStack result) {
        if (ConfigFunctions.enableAutoAddSmoker && input != null && result != null) {
            return result.func_77973_b() instanceof ItemFood && ((ItemFood)result.func_77973_b()).func_150905_g(result) > 0;
        }
        return false;
    }
}

