/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.mixins.early.sounds;

import ganymedes01.etfuturum.blocks.BlockBerryBush;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityPlayer.class})
public abstract class MixinEntityPlayer
extends EntityLivingBase {
    @Unique
    private DamageSource etfuturum$lastDamageSource;

    @Shadow
    protected abstract String func_70673_aS();

    @Shadow
    protected abstract String func_70621_aR();

    public MixinEntityPlayer(World p_i1594_1_) {
        super(p_i1594_1_);
    }

    @Inject(method={"damageEntity"}, at={@At(value="HEAD")})
    public void captureLastDamageSource(DamageSource source, float amount, CallbackInfo ci) {
        this.etfuturum$lastDamageSource = source;
    }

    @Unique
    private String etfuturum$getUniqueHurtSound() {
        if (this.etfuturum$lastDamageSource != null) {
            if (this.etfuturum$lastDamageSource.func_76347_k()) {
                return "minecraft_1.21:entity.player.hurt_on_fire";
            }
            if (this.etfuturum$lastDamageSource == DamageSource.field_76369_e) {
                return "minecraft_1.21:entity.player.hurt_drown";
            }
            if (this.etfuturum$lastDamageSource == BlockBerryBush.SWEET_BERRY_BUSH) {
                return "minecraft_1.21:entity.player.hurt_sweet_berry_bush";
            }
        }
        return null;
    }

    @Inject(method={"getHurtSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getHurtSound(CallbackInfoReturnable<String> cir) {
        if (this.etfuturum$getUniqueHurtSound() != null) {
            cir.setReturnValue((Object)this.etfuturum$getUniqueHurtSound());
        }
    }

    @Inject(method={"getDeathSound"}, at={@At(value="HEAD")}, cancellable=true)
    protected void getDeathSound(CallbackInfoReturnable<String> cir) {
        if (this.etfuturum$getUniqueHurtSound() != null) {
            cir.setReturnValue((Object)this.etfuturum$getUniqueHurtSound());
        }
    }

    @Inject(method={"playSound"}, at={@At(value="HEAD")}, cancellable=true)
    public void overrideDamageSound(String name, float volume, float pitch, CallbackInfo ci) {
        if (this.etfuturum$lastDamageSource != null && (name.equals(this.func_70621_aR()) || name.equals(this.func_70673_aS()))) {
            this.field_70170_p.func_72956_a((Entity)this, name, volume, pitch);
            this.etfuturum$lastDamageSource = null;
            ci.cancel();
        }
    }
}

