/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.mixins.early.backinslime;

import com.google.common.collect.Lists;
import ganymedes01.etfuturum.api.PistonBehaviorRegistry;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.Facing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockPistonBase.class})
public class MixinBlockPistonBase
extends Block {
    @Shadow
    @Final
    private boolean field_150082_a;

    @Shadow
    private boolean func_150072_a(World p_150072_1_, int p_150072_2_, int p_150072_3_, int p_150072_4_, int p_150072_5_) {
        return false;
    }

    protected MixinBlockPistonBase(Material materialIn) {
        super(materialIn);
    }

    @Overwrite
    private void func_150078_e(World world, int x, int y, int z) {
        int pistonMetadata = world.func_72805_g(x, y, z);
        int side = BlockPistonBase.func_150076_b((int)pistonMetadata);
        if (side == 7) {
            return;
        }
        boolean isPowered = this.func_150072_a(world, x, y, z, side);
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int xoffset = dir.offsetX;
        int yoffset = dir.offsetY;
        int zoffset = dir.offsetZ;
        int xoffset2 = dir.offsetX * 2;
        int yoffset2 = dir.offsetY * 2;
        int zoffset2 = dir.offsetZ * 2;
        int oppositeSide = dir.getOpposite().ordinal();
        if (isPowered && !BlockPistonBase.func_150075_c((int)pistonMetadata)) {
            if (this.etfuturum$getPushableBlocks(world, x + xoffset, y + yoffset, z + zoffset, oppositeSide, side, x, y, z, Lists.newArrayList(), Lists.newArrayList()) <= 12) {
                world.func_147452_c(x, y, z, (Block)this, 0, side);
            }
        } else if (!isPowered && BlockPistonBase.func_150075_c((int)pistonMetadata)) {
            if (this.field_150082_a) {
                Block storedBlock;
                TileEntityPiston tileentitypiston;
                Block block = world.func_147439_a(x + xoffset2, y + yoffset2, z + zoffset2);
                TileEntity tileentity1 = world.func_147438_o(x + xoffset2, y + yoffset2, z + zoffset2);
                if (block == Blocks.field_150326_M && tileentity1 instanceof TileEntityPiston && (tileentitypiston = (TileEntityPiston)tileentity1).func_145864_c() == side && tileentitypiston.func_145868_b() && (storedBlock = tileentitypiston.func_145861_a()) != null && storedBlock != Blocks.field_150326_M) {
                    world.func_147452_c(x, y, z, (Block)this, -1, side);
                    return;
                }
                if (this.etfuturum$getPushableBlocks(world, x + xoffset2, y + yoffset2, z + zoffset2, oppositeSide, oppositeSide, x + xoffset, y + yoffset, z + zoffset, Lists.newArrayList(), Lists.newArrayList()) > 12) {
                    return;
                }
            }
            world.func_147452_c(x, y, z, (Block)this, 1, side);
        }
    }

    @Overwrite
    public boolean func_149696_a(World world, int x, int y, int z, int extend, int side) {
        if (!world.field_72995_K) {
            boolean hasPower = this.func_150072_a(world, x, y, z, side);
            if (hasPower && (extend == 1 || extend == -1)) {
                world.func_72921_c(x, y, z, side | 8, 2);
                return false;
            }
            if (!hasPower && extend == 0) {
                return false;
            }
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int xoffset = dir.offsetX;
        int yoffset = dir.offsetY;
        int zoffset = dir.offsetZ;
        int xoffset2 = dir.offsetX * 2;
        int yoffset2 = dir.offsetY * 2;
        int zoffset2 = dir.offsetZ * 2;
        int oppositeSide = dir.getOpposite().ordinal();
        ArrayList pushedBlockList = Lists.newArrayList();
        ArrayList pushedBlockPosList = Lists.newArrayList();
        if (extend == 1 || extend == -1) {
            TileEntity tileentity = world.func_147438_o(x + xoffset, y + yoffset, z + zoffset);
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).func_145866_f();
            }
            world.func_147465_d(x, y, z, (Block)Blocks.field_150326_M, side, 3);
            world.func_147455_a(x, y, z, BlockPistonMoving.func_149962_a((Block)this, (int)side, (int)side, (boolean)false, (boolean)true));
            if (this.field_150082_a && extend == 1) {
                Block blockToPull = world.func_147439_a(x + xoffset2, y + yoffset2, z + zoffset2);
                int metaToPull = world.func_72805_g(x + xoffset2, y + yoffset2, z + zoffset2);
                if (blockToPull.func_149656_h() != 1 && !PistonBehaviorRegistry.isNonStickyBlock(blockToPull, metaToPull)) {
                    if (this.etfuturum$getPushableBlocks(world, x + xoffset2, y + yoffset2, z + zoffset2, oppositeSide, oppositeSide, x + xoffset, y + yoffset, z + zoffset, pushedBlockList, pushedBlockPosList) == 0) {
                        world.func_147468_f(x + xoffset, y + yoffset, z + zoffset);
                    } else {
                        this.etfuturum$pushBlocks(world, x + xoffset, y + yoffset, z + zoffset, oppositeSide, false, pushedBlockList, pushedBlockPosList);
                    }
                }
            }
            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.in", 0.5f, world.field_73012_v.nextFloat() * 0.15f + 0.6f);
        } else if (extend == 0) {
            this.etfuturum$getPushableBlocks(world, x + xoffset, y + yoffset, z + zoffset, oppositeSide, side, x, y, z, pushedBlockList, pushedBlockPosList);
            if (this.etfuturum$pushBlocks(world, x + xoffset, y + yoffset, z + zoffset, side, true, pushedBlockList, pushedBlockPosList)) {
                boolean flag1 = world.func_147465_d(x + xoffset, y + yoffset, z + zoffset, (Block)Blocks.field_150326_M, side | (this.field_150082_a ? 8 : 0), 4);
                world.func_147455_a(x + xoffset, y + yoffset, z + zoffset, BlockPistonMoving.func_149962_a((Block)Blocks.field_150332_K, (int)(side | (this.field_150082_a ? 8 : 0)), (int)side, (boolean)true, (boolean)false));
                boolean flag2 = world.func_72921_c(x, y, z, side | 8, 3);
                if (flag1 || flag2) {
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "tile.piston.out", 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.6f);
                }
            }
        }
        return true;
    }

    @Unique
    private int etfuturum$getPushableBlocks(World world, int x, int y, int z, int ignoreSide, int side, int pistonX, int pistonY, int pistonZ, List<Pair<Block, Integer>> pushedBlockList, List<BlockPos> pushedBlockPosList) {
        Block pushedBlock = world.func_147439_a(x, y, z);
        int pushedBlockMeta = world.func_72805_g(x, y, z);
        int pushedBlockX = x;
        int pushedBlockY = y;
        int pushedBlockZ = z;
        int blocksPushed = 0;
        while (blocksPushed < 13) {
            if (pushedBlock.isAir((IBlockAccess)world, pushedBlockX, pushedBlockY, pushedBlockZ)) {
                return blocksPushed;
            }
            if (pushedBlockY == 0 && side == 0 || pushedBlockY >= world.func_72800_K() - 1 && side == 1) {
                return 13;
            }
            if (this.etfuturum$canPushBlockNested(pushedBlock, world, pushedBlockX, pushedBlockY, pushedBlockZ, side, side)) {
                if (pushedBlock.func_149656_h() == 1) {
                    return ++blocksPushed;
                }
            } else {
                if (pushedBlockX == pistonX && pushedBlockY == pistonY && pushedBlockZ == pistonZ) {
                    return blocksPushed;
                }
                return 13;
            }
            BlockPos pushedBlockCoords = new BlockPos(pushedBlockX, pushedBlockY, pushedBlockZ);
            for (BlockPos pushedBlockPos : pushedBlockPosList) {
                if (!pushedBlockPos.equals(pushedBlockCoords) || pushedBlockPos.getBlockMetadata(world) != pushedBlockMeta || pushedBlockPos.getBlock(world) != pushedBlock) continue;
                return blocksPushed;
            }
            ++blocksPushed;
            pushedBlockList.add((Pair<Block, Integer>)Pair.of((Object)pushedBlock, (Object)pushedBlockMeta));
            pushedBlockPosList.add(pushedBlockCoords);
            if (PistonBehaviorRegistry.isStickyBlock(pushedBlock, pushedBlockMeta)) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir.ordinal() == side || dir.ordinal() == ignoreSide) continue;
                    int attachedX = pushedBlockX + dir.offsetX;
                    int attachedY = pushedBlockY + dir.offsetY;
                    int attachedZ = pushedBlockZ + dir.offsetZ;
                    Block attachedBlock = world.func_147439_a(attachedX, attachedY, attachedZ);
                    if (attachedX == pistonX && attachedY == pistonY && attachedZ == pistonZ || !this.etfuturum$canPushBlockNested(attachedBlock, world, attachedX, attachedY, attachedZ, dir.ordinal(), side) || attachedBlock.func_149656_h() == 1) continue;
                    blocksPushed += this.etfuturum$getPushableBlocks(world, attachedX, attachedY, attachedZ, dir.getOpposite().ordinal(), side, pistonX, pistonY, pistonZ, pushedBlockList, pushedBlockPosList);
                }
            }
            pushedBlockMeta = world.func_72805_g(pushedBlockX += ForgeDirection.getOrientation((int)side).offsetX, pushedBlockY += ForgeDirection.getOrientation((int)side).offsetY, pushedBlockZ += ForgeDirection.getOrientation((int)side).offsetZ);
            pushedBlock = world.func_147439_a(pushedBlockX, pushedBlockY, pushedBlockZ);
        }
        return blocksPushed;
    }

    @Unique
    private boolean etfuturum$pushBlocks(World world, int pistonX, int pistonY, int pistonZ, int side, boolean extending, List<Pair<Block, Integer>> pushedBlockList, List<BlockPos> pushedBlockPosList) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)side);
        int xoffset = dir.offsetX;
        int yoffset = dir.offsetY;
        int zoffset = dir.offsetZ;
        ArrayList removedBlockCoords = Lists.newArrayList();
        ArrayList launchedEntityList = Lists.newArrayList();
        ArrayList pulledEntityList = Lists.newArrayList();
        ArrayList relocationCoordsList = Lists.newArrayList();
        ArrayList obstructionsCoordsList = Lists.newArrayList();
        if (extending) {
            relocationCoordsList.add(new BlockPos(pistonX - xoffset, pistonY - yoffset, pistonZ - zoffset));
        }
        relocationCoordsList.addAll(pushedBlockPosList);
        for (BlockPos relocationBlockPos : relocationCoordsList) {
            int destinationX = relocationBlockPos.getX() + xoffset;
            int destinationY = relocationBlockPos.getY() + yoffset;
            int destinationZ = relocationBlockPos.getZ() + zoffset;
            BlockPos obstructionCoords = new BlockPos(destinationX, destinationY, destinationZ);
            Block destinationBlock = world.func_147439_a(destinationX, destinationY, destinationZ);
            if (pushedBlockPosList.contains(obstructionCoords) || destinationBlock.func_149688_o() == Material.field_151579_a) continue;
            if (destinationBlock.func_149656_h() == 1) {
                obstructionsCoordsList.add(obstructionCoords);
                continue;
            }
            if (destinationX == pistonX && destinationY == pistonY && destinationZ == pistonZ && destinationBlock == Blocks.field_150332_K) {
                BlockPistonExtension pistonHead = (BlockPistonExtension)destinationBlock;
                int pistonHeadMeta = world.func_72805_g(destinationX, destinationY, destinationZ);
                if (pistonHead instanceof BlockPistonExtension && Facing.field_71588_a[BlockPistonExtension.func_150085_b((int)pistonHeadMeta)] == side) continue;
            }
            return false;
        }
        for (BlockPos obstruction : obstructionsCoordsList) {
            Block obstructionBlock = world.func_147439_a(obstruction.getX(), obstruction.getY(), obstruction.getZ());
            int obstructionMeta = world.func_72805_g(obstruction.getX(), obstruction.getY(), obstruction.getZ());
            float chance = obstructionBlock instanceof BlockSnow ? -1.0f : 1.0f;
            obstructionBlock.func_149690_a(world, obstruction.getX(), obstruction.getY(), obstruction.getZ(), obstructionMeta, chance, 0);
            world.func_147468_f(obstruction.getX(), obstruction.getY(), obstruction.getZ());
        }
        for (int i = 0; i < pushedBlockList.size(); ++i) {
            boolean needsPusher = true;
            Block block = (Block)pushedBlockList.get(i).getLeft();
            int blockMeta = (Integer)pushedBlockList.get(i).getRight();
            BlockPos pos = pushedBlockPosList.get(i);
            BlockPos rearPos = new BlockPos(pos.getX() - xoffset, pos.getY() - yoffset, pos.getZ() - zoffset);
            int blockX = pos.getX();
            int blockY = pos.getY();
            int blockZ = pos.getZ();
            for (BlockPos pushedBlockPos : pushedBlockPosList) {
                if (!pushedBlockPos.equals(rearPos)) continue;
                needsPusher = false;
                break;
            }
            if (needsPusher) {
                removedBlockCoords.add(pushedBlockPosList.get(i));
            }
            blockX += xoffset;
            blockY += yoffset;
            blockZ += zoffset;
            if (block.func_149656_h() == 1) {
                float chance = block instanceof BlockSnow ? -1.0f : 1.0f;
                block.func_149690_a(world, pos.getX(), pos.getY(), pos.getZ(), blockMeta, chance, 0);
                world.func_147468_f(blockX, blockY, blockZ);
            } else {
                world.func_147465_d(blockX, blockY, blockZ, (Block)Blocks.field_150326_M, blockMeta, 4);
                world.func_147455_a(blockX, blockY, blockZ, BlockPistonMoving.func_149962_a((Block)block, (int)blockMeta, (int)side, (boolean)true, (boolean)false));
                world.func_147459_d(blockX, blockY, blockZ, block);
            }
            if (extending && PistonBehaviorRegistry.bouncesEntities(block, blockMeta)) {
                for (Entity o : world.func_72839_b(null, this.func_149668_a(world, blockX, blockY, blockZ))) {
                    if (launchedEntityList.contains(o)) continue;
                    launchedEntityList.add(o);
                }
                continue;
            }
            if (side <= 1 || !PistonBehaviorRegistry.pullsEntities(block, blockMeta)) continue;
            for (Entity o : world.func_72839_b(null, this.func_149668_a(world, blockX, blockY, blockZ))) {
                if (pulledEntityList.contains(o)) continue;
                pulledEntityList.add(o);
            }
        }
        for (Entity entity : launchedEntityList) {
            entity.field_70159_w += (double)((float)xoffset * 1.1f);
            entity.field_70181_x += (double)((float)yoffset * 1.1f);
            entity.field_70179_y += (double)((float)zoffset * 1.1f);
        }
        for (Entity entity : pulledEntityList) {
            entity.field_70159_w += (double)((float)xoffset * 0.4f);
            entity.field_70163_u += (double)0.15f;
            entity.field_70179_y += (double)((float)zoffset * 0.4f);
        }
        for (BlockPos blockCoords : removedBlockCoords) {
            world.func_147468_f(blockCoords.getX(), blockCoords.getY(), blockCoords.getZ());
            world.func_147459_d(blockCoords.getX(), blockCoords.getY(), blockCoords.getZ(), Blocks.field_150350_a);
        }
        return true;
    }

    @Unique
    private boolean etfuturum$canPushBlockNested(Block pushedBlock, World world, int x, int y, int z, int pushedSide, int sideToPushTo) {
        if (pushedBlock == Blocks.field_150343_Z) {
            return false;
        }
        if (pushedBlock != Blocks.field_150331_J && pushedBlock != Blocks.field_150320_F) {
            if (pushedBlock.func_149712_f(world, x, y, z) == -1.0f || pushedBlock.func_149656_h() == 2) {
                return false;
            }
            if (pushedBlock.func_149656_h() == 1) {
                return pushedSide == sideToPushTo || pushedSide == ForgeDirection.OPPOSITES[sideToPushTo];
            }
        } else {
            return !BlockPistonBase.func_150075_c((int)world.func_72805_g(x, y, z));
        }
        int pushedMeta = world.func_72805_g(x, y, z);
        if (sideToPushTo != pushedSide) {
            if (PistonBehaviorRegistry.isNonStickyBlock(pushedBlock, pushedMeta)) {
                return false;
            }
            int xoffset = ForgeDirection.getOrientation((int)pushedSide).getOpposite().offsetX;
            int yoffset = ForgeDirection.getOrientation((int)pushedSide).getOpposite().offsetY;
            int zoffset = ForgeDirection.getOrientation((int)pushedSide).getOpposite().offsetZ;
            Block stuckToBlock = world.func_147439_a(x + xoffset, y + yoffset, z + zoffset);
            int stuckToMeta = world.func_72805_g(x + xoffset, y + yoffset, z + zoffset);
            if (PistonBehaviorRegistry.isStickyBlock(pushedBlock, pushedMeta) && PistonBehaviorRegistry.isStickyBlock(stuckToBlock, stuckToMeta) && (pushedBlock != stuckToBlock || pushedMeta != stuckToMeta)) {
                return false;
            }
        }
        return !world.func_147439_a(x, y, z).hasTileEntity(world.func_72805_g(x, y, z));
    }
}

