/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ganymedes01.etfuturum.configuration.configs.ConfigSounds;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import makamys.mclib.json.JsonUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.IMetadataSection;
import net.minecraft.client.resources.data.IMetadataSerializer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;

public class DynamicSoundsResourcePack
implements IResourcePack {
    public Set<String> func_110587_b() {
        return ImmutableSet.of((Object)"minecraft");
    }

    public IMetadataSection func_135058_a(IMetadataSerializer p_135058_1_, String p_135058_2_) throws IOException {
        return null;
    }

    public BufferedImage func_110586_a() {
        return null;
    }

    public String func_130077_b() {
        return "Et Futurum Requiem dynamic sounds.json";
    }

    public InputStream func_110590_a(ResourceLocation resLoc) {
        if (resLoc.func_110623_a().equals("sounds.json")) {
            return new ByteArrayInputStream(new JsonCreator().getJson().toString().getBytes());
        }
        return null;
    }

    public boolean func_110589_b(ResourceLocation resLoc) {
        return resLoc.func_110623_a().equals("sounds.json");
    }

    public static void inject() {
        if (ConfigSounds.caveAmbience) {
            DynamicSoundsResourcePack dynamicResourcePack = new DynamicSoundsResourcePack();
            Minecraft.func_71410_x().field_110449_ao.add(dynamicResourcePack);
            IResourceManager resMan = Minecraft.func_71410_x().func_110442_L();
            if (resMan instanceof SimpleReloadableResourceManager) {
                ((SimpleReloadableResourceManager)resMan).func_110545_a((IResourcePack)dynamicResourcePack);
            }
        }
    }

    public static boolean shouldGenerateJson() {
        return ConfigSounds.caveAmbience;
    }

    public class JsonCreator {
        private final JsonObject rootObject = new JsonObject();

        private void addSoundsToCategory(String cat, String ... sounds) {
            JsonObject soundCat = JsonUtil.getOrCreateObject(this.rootObject, cat);
            JsonArray soundList = JsonUtil.getOrCreateArray(soundCat, "sounds");
            for (String sound : sounds) {
                soundList.add((JsonElement)new JsonPrimitive(sound));
            }
        }

        private void addSoundEventsToCategory(String cat, String ... sounds) {
            this.addSoundsToCategoryWithSettings(cat, 1.0f, 1.0f, 1, false, true, sounds);
        }

        private void addSoundsToCategoryWithSettings(String cat, float volume, float pitch, String ... sounds) {
            this.addSoundsToCategoryWithSettings(cat, volume, pitch, 1, false, false, sounds);
        }

        private void addSoundsToCategoryWithSettings(String cat, float volume, float pitch, int weight, String ... sounds) {
            this.addSoundsToCategoryWithSettings(cat, volume, pitch, weight, false, false, sounds);
        }

        private void addSoundsToCategoryWithSettings(String cat, float volume, float pitch, int weight, boolean stream, boolean isEvent, String ... sounds) {
            JsonObject soundCat = JsonUtil.getOrCreateObject(this.rootObject, cat);
            JsonArray soundList = JsonUtil.getOrCreateArray(soundCat, "sounds");
            for (String sound : sounds) {
                JsonObject soundObj = new JsonObject();
                soundObj.add("name", (JsonElement)new JsonPrimitive(sound));
                if (volume != 1.0f) {
                    soundObj.add("volume", (JsonElement)new JsonPrimitive((Number)Float.valueOf(MathHelper.func_76131_a((float)volume, (float)0.0f, (float)1.0f))));
                }
                if (pitch != 1.0f) {
                    soundObj.add("pitch", (JsonElement)new JsonPrimitive((Number)Float.valueOf(pitch)));
                }
                if (weight > 1) {
                    soundObj.add("weight", (JsonElement)new JsonPrimitive((Number)weight));
                }
                if (stream) {
                    soundObj.add("stream", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                }
                if (isEvent) {
                    soundObj.add("type", (JsonElement)new JsonPrimitive("event"));
                }
                soundList.add((JsonElement)soundObj);
            }
        }

        public JsonObject getJson() {
            if (ConfigSounds.caveAmbience) {
                this.addSoundsToCategory("ambient.cave.cave", "minecraft_1.21:ambient/cave/cave14", "minecraft_1.21:ambient/cave/cave15", "minecraft_1.21:ambient/cave/cave16", "minecraft_1.21:ambient/cave/cave17", "minecraft_1.21:ambient/cave/cave18", "minecraft_1.21:ambient/cave/cave19");
            }
            return this.rootObject;
        }
    }
}

