/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import ganymedes01.etfuturum.core.utils.ItemStackSet;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class EnchantingFuelRegistry {
    private static final ItemStackSet FUEL_REGISTRY = new ItemStackSet();

    public static void registerFuel(Object itemObj) {
        if (ModRecipes.validateItems(itemObj)) {
            if (itemObj instanceof ItemStack) {
                FUEL_REGISTRY.add(((ItemStack)itemObj).func_77946_l());
            } else if (itemObj instanceof String) {
                for (ItemStack oreStack : OreDictionary.getOres((String)((String)itemObj))) {
                    FUEL_REGISTRY.add(oreStack.func_77946_l());
                }
            } else if (itemObj instanceof Item) {
                FUEL_REGISTRY.add(new ItemStack((Item)itemObj, 1, Short.MAX_VALUE));
            } else if (itemObj instanceof Block && Item.func_150898_a((Block)((Block)itemObj)) != null) {
                FUEL_REGISTRY.add(new ItemStack(Item.func_150898_a((Block)((Block)itemObj)), 1, Short.MAX_VALUE));
            } else {
                throw new IllegalArgumentException("Tried to add " + itemObj + " as an enchanting fuel, which is not an Itemstack, item, block or string.");
            }
        }
    }

    public static void registerFuel(List<Object> list, int count) {
        list.forEach(EnchantingFuelRegistry::registerFuel);
    }

    public static void remove(String fuelOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)fuelOreDict)) {
            EnchantingFuelRegistry.remove(stack);
        }
    }

    public static void remove(ItemStack fuel) {
        FUEL_REGISTRY.remove(fuel);
    }

    public static boolean isFuel(String fuelOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)fuelOreDict)) {
            if (!EnchantingFuelRegistry.isFuel(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack fuel) {
        return FUEL_REGISTRY.isEmpty() || FUEL_REGISTRY.contains(fuel);
    }

    public static ItemStackSet getFuels() {
        return FUEL_REGISTRY;
    }

    public void printFuels() {
        EnchantingFuelRegistry.getFuels().forEach((key, value) -> Logger.info("Enchanting fuel entry: " + Item.field_150901_e.func_148750_c((Object)key.func_77973_b()) + " Meta: " + (key.func_77960_j() == Short.MAX_VALUE ? "any" : Integer.valueOf(key.func_77960_j()))));
    }

    static {
        FUEL_REGISTRY.add(new ItemStack(Items.field_151100_aR, 1, 4));
    }
}

