/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.api;

import ganymedes01.etfuturum.core.utils.ItemStackMap;
import ganymedes01.etfuturum.core.utils.Logger;
import ganymedes01.etfuturum.recipes.ModRecipes;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BrewingFuelRegistry {
    private static final ItemStackMap<Integer> FUEL_REGISTRY = new ItemStackMap();

    public static void registerFuel(Object itemObj, int count) {
        if (count <= 0) {
            throw new IllegalArgumentException("Tried to add a brewing fuel with " + count + " cycles??? It must be able to at least brew 1 set of potions...");
        }
        if (ModRecipes.validateItems(itemObj)) {
            if (itemObj instanceof ItemStack) {
                FUEL_REGISTRY.put(((ItemStack)itemObj).func_77946_l(), count);
            } else if (itemObj instanceof String) {
                for (ItemStack oreStack : OreDictionary.getOres((String)((String)itemObj))) {
                    FUEL_REGISTRY.put(oreStack.func_77946_l(), count);
                }
            } else if (itemObj instanceof Item) {
                FUEL_REGISTRY.put(new ItemStack((Item)itemObj, 1, Short.MAX_VALUE), count);
            } else if (itemObj instanceof Block && Item.func_150898_a((Block)((Block)itemObj)) != null) {
                FUEL_REGISTRY.put(new ItemStack(Item.func_150898_a((Block)((Block)itemObj)), 1, Short.MAX_VALUE), count);
            } else {
                throw new IllegalArgumentException("Tried to add " + itemObj + " as a brewing fuel, which is not an Itemstack, item, block or string.");
            }
        }
    }

    public static void registerFuel(List<Object> list, int count) {
        list.forEach(o -> BrewingFuelRegistry.registerFuel(o, count));
    }

    public static void remove(String fuelOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)fuelOreDict)) {
            BrewingFuelRegistry.remove(stack);
        }
    }

    public static void remove(ItemStack fuel) {
        FUEL_REGISTRY.remove(fuel);
    }

    public static boolean isFuel(String fuelOreDict) {
        for (ItemStack stack : OreDictionary.getOres((String)fuelOreDict)) {
            if (!BrewingFuelRegistry.isFuel(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFuel(ItemStack fuel) {
        return BrewingFuelRegistry.getBrewingAmount(fuel) > 0;
    }

    public static int getBrewingAmount(ItemStack fuel) {
        Integer time = FUEL_REGISTRY.get(fuel);
        if (time != null) {
            return time;
        }
        return 0;
    }

    public static ItemStackMap<Integer> getFuels() {
        return FUEL_REGISTRY;
    }

    public void printFuels() {
        BrewingFuelRegistry.getFuels().forEach((key, value) -> Logger.info("Brewing fuel entry: " + Item.field_150901_e.func_148750_c((Object)key.func_77973_b()) + " Meta: " + (key.func_77960_j() == Short.MAX_VALUE ? "any" : Integer.valueOf(key.func_77960_j()))));
    }

    static {
        FUEL_REGISTRY.put(new ItemStack(Items.field_151065_br), 30);
    }
}

