/*
 * Decompiled with CFR 0.152.
 */
package xonin.backhand.api.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraftforge.common.util.FakePlayer;
import tconstruct.library.tools.HarvestTool;
import xonin.backhand.api.core.IBackhandPlayer;
import xonin.backhand.api.core.IOffhandInventory;
import xonin.backhand.utils.Mods;

@ParametersAreNonnullByDefault
public final class BackhandUtils {
    public static final List<Class<? extends Item>> offhandPriorityItems = new ArrayList<Class<? extends Item>>();
    public static final List<Class<? extends Item>> deprioritizedMainhand = new ArrayList<Class<? extends Item>>();

    public static void setPlayerOffhandItem(EntityPlayer player, @Nullable ItemStack stack) {
        ((IOffhandInventory)player.field_71071_by).backhand$setOffhandItem(stack);
    }

    @Nullable
    public static ItemStack getOffhandItem(EntityPlayer player) {
        return ((IOffhandInventory)player.field_71071_by).backhand$getOffhandItem();
    }

    public static void useOffhandItem(EntityPlayer player, Runnable action) {
        BackhandUtils.useOffhandItem(player, true, action);
    }

    public static void useOffhandItem(EntityPlayer player, boolean syncSlot, Runnable action) {
        BackhandUtils.useOffhandItem(player, syncSlot, () -> {
            action.run();
            return true;
        });
    }

    public static boolean useOffhandItem(EntityPlayer player, BooleanSupplier action) {
        return BackhandUtils.useOffhandItem(player, true, action);
    }

    public static boolean useOffhandItem(EntityPlayer player, boolean syncSlot, BooleanSupplier action) {
        int oldSlot = player.field_71071_by.field_70461_c;
        player.field_71071_by.field_70461_c = BackhandUtils.getOffhandSlot(player);
        if (syncSlot && player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71442_b.func_78750_j();
        }
        boolean result = action.getAsBoolean();
        player.field_71071_by.field_70461_c = oldSlot;
        if (syncSlot && player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71442_b.func_78750_j();
        }
        return result;
    }

    public static boolean isUsingOffhand(EntityPlayer player) {
        return ((IBackhandPlayer)player).isUsingOffhand();
    }

    public static int getOffhandSlot(EntityPlayer player) {
        return ((IOffhandInventory)player.field_71071_by).backhand$getOffhandSlot();
    }

    @SafeVarargs
    public static void addOffhandPriorityItem(Class<? extends Item> ... itemClass) {
        offhandPriorityItems.addAll(Arrays.asList(itemClass));
    }

    @SafeVarargs
    public static void addDeprioritizedMainhandItem(Class<? extends Item> ... itemClass) {
        deprioritizedMainhand.addAll(Arrays.asList(itemClass));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidPlayer(@Nullable Entity entity) {
        if (!(entity instanceof EntityPlayerMP)) return false;
        EntityPlayerMP playerMP = (EntityPlayerMP)entity;
        if (entity instanceof FakePlayer) return false;
        if (playerMP.field_71135_a == null) return false;
        return true;
    }

    public static boolean isItemTool(@Nullable Item item) {
        return Mods.TINKERS_CONSTRUCT.isLoaded() && item instanceof HarvestTool || item instanceof ItemTool || item instanceof ItemSword || item instanceof ItemHoe;
    }

    public static int swapToOffhand(EntityPlayer player) {
        int heldItemTemp = player.field_71071_by.field_70461_c;
        player.field_71071_by.field_70461_c = BackhandUtils.getOffhandSlot(player);
        return heldItemTemp;
    }

    public static void swapBack(EntityPlayer player, int heldItemTemp) {
        player.field_71071_by.field_70461_c = heldItemTemp;
    }
}

