/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.storage;

import appeng.api.implementations.tiles.ITileStorageMonitorable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.me.storage.VoidFluidInventory;
import appeng.me.storage.VoidItemInventory;
import appeng.tile.misc.TileCondenser;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class AEExternalHandler
implements IExternalStorageHandler {
    @Override
    public boolean canHandle(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource mySrc) {
        if (channel == StorageChannel.ITEMS && te instanceof ITileStorageMonitorable) {
            return ((ITileStorageMonitorable)te).getMonitorable(d, mySrc) != null;
        }
        return te instanceof TileCondenser;
    }

    @Override
    public IMEInventory getInventory(TileEntity te, ForgeDirection d, StorageChannel channel, BaseActionSource src) {
        if (te instanceof TileCondenser) {
            if (channel == StorageChannel.ITEMS) {
                return new VoidItemInventory((TileCondenser)te);
            }
            return new VoidFluidInventory((TileCondenser)te);
        }
        if (te instanceof ITileStorageMonitorable) {
            IMEMonitor<IAEFluidStack> fi;
            IMEMonitor<IAEItemStack> ii;
            ITileStorageMonitorable iface = (ITileStorageMonitorable)te;
            IStorageMonitorable sm = iface.getMonitorable(d, src);
            if (channel == StorageChannel.ITEMS && sm != null && (ii = sm.getItemInventory()) != null) {
                return ii;
            }
            if (channel == StorageChannel.FLUIDS && sm != null && (fi = sm.getFluidInventory()) != null) {
                return fi;
            }
        }
        return null;
    }
}

