/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class NBTJson {
    private static final Pattern numberPattern = Pattern.compile("^([-+]?\\d+\\.?\\d*E*\\d*)([bBsSlLfFdD]?)$");

    public static String toJson(NBTTagCompound tag) {
        return NBTJson.toJson(NBTJson.toJsonObject((NBTBase)tag));
    }

    public static String toJson(JsonElement json) {
        return json.toString();
    }

    public static JsonElement toJsonObject(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)nbt;
            Map tagMap = nbtTagCompound.field_74784_a;
            JsonObject root = new JsonObject();
            tagMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(nbtEntry -> root.add((String)nbtEntry.getKey(), NBTJson.toJsonObject((NBTBase)nbtEntry.getValue())));
            return root;
        }
        if (nbt instanceof NBTTagByte) {
            return new JsonPrimitive(Byte.toString(((NBTTagByte)nbt).func_150290_f()) + 'B');
        }
        if (nbt instanceof NBTTagShort) {
            return new JsonPrimitive(Short.toString(((NBTTagShort)nbt).func_150289_e()) + 'S');
        }
        if (nbt instanceof NBTTagInt) {
            return new JsonPrimitive((Number)((NBTTagInt)nbt).func_150287_d());
        }
        if (nbt instanceof NBTTagLong) {
            return new JsonPrimitive(Long.toString(((NBTTagLong)nbt).func_150291_c()) + 'L');
        }
        if (nbt instanceof NBTTagFloat) {
            return new JsonPrimitive(Float.toString(((NBTTagFloat)nbt).func_150288_h()) + 'F');
        }
        if (nbt instanceof NBTTagDouble) {
            return new JsonPrimitive(Double.toString(((NBTTagDouble)nbt).func_150286_g()) + 'D');
        }
        if (nbt instanceof NBTBase.NBTPrimitive) {
            return new JsonPrimitive((Number)((NBTBase.NBTPrimitive)nbt).func_150286_g());
        }
        if (nbt instanceof NBTTagString) {
            return new JsonPrimitive(((NBTTagString)nbt).func_150285_a_());
        }
        if (nbt instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)nbt;
            if (list.field_74747_a.isEmpty()) {
                return NBTJson.createEmptyList(list);
            }
            JsonArray arr = new JsonArray();
            list.field_74747_a.forEach(c -> arr.add(NBTJson.toJsonObject((NBTBase)c)));
            return arr;
        }
        if (nbt instanceof NBTTagIntArray) {
            NBTTagIntArray list = (NBTTagIntArray)nbt;
            if (list.func_150302_c().length == 0) {
                return NBTJson.createEmptyList(list);
            }
            JsonArray arr = new JsonArray();
            for (int i : list.func_150302_c()) {
                arr.add((JsonElement)new JsonPrimitive((Number)i));
            }
            return arr;
        }
        if (nbt instanceof NBTTagByteArray) {
            NBTTagByteArray list = (NBTTagByteArray)nbt;
            if (list.func_150292_c().length == 0) {
                return NBTJson.createEmptyList(list);
            }
            JsonArray arr = new JsonArray();
            for (byte i : list.func_150292_c()) {
                arr.add((JsonElement)new JsonPrimitive(Byte.toString(i) + 'B'));
            }
            return arr;
        }
        throw new IllegalArgumentException("Unsupported NBT Tag: " + NBTBase.field_82578_b[nbt.func_74732_a()] + " - " + nbt);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static NBTBase toNbt(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive jsonPrimitive = (JsonPrimitive)jsonElement;
            String jsonString = jsonPrimitive.getAsString();
            Matcher m = numberPattern.matcher(jsonString);
            if (!m.find()) return new NBTTagString(jsonString);
            String numberString = m.group(1);
            if (m.groupCount() == 2 && m.group(2).length() > 0) {
                char numberType = m.group(2).charAt(0);
                switch (numberType) {
                    case 'B': 
                    case 'b': {
                        return new NBTTagByte(Byte.parseByte(numberString));
                    }
                    case 'S': 
                    case 's': {
                        return new NBTTagShort(Short.parseShort(numberString));
                    }
                    case 'L': 
                    case 'l': {
                        return new NBTTagLong(Long.parseLong(numberString));
                    }
                    case 'F': 
                    case 'f': {
                        return new NBTTagFloat(Float.parseFloat(numberString));
                    }
                    case 'D': 
                    case 'd': {
                        return new NBTTagDouble(Double.parseDouble(numberString));
                    }
                }
                throw new IllegalArgumentException("Unhandled element " + jsonElement);
            }
            if (!numberString.contains(".")) return new NBTTagInt(Integer.parseInt(numberString));
            return new NBTTagDouble(Double.parseDouble(numberString));
        }
        if (jsonElement instanceof JsonArray) {
            JsonArray jsonArray = (JsonArray)jsonElement;
            ArrayList<NBTBase> nbtList = new ArrayList<NBTBase>();
            for (JsonElement element : jsonArray) {
                nbtList.add(NBTJson.toNbt(element));
            }
            if (nbtList.stream().allMatch(n -> n instanceof NBTTagInt)) {
                return new NBTTagIntArray(nbtList.stream().mapToInt(i -> ((NBTTagInt)i).func_150287_d()).toArray());
            }
            if (!nbtList.stream().allMatch(n -> n instanceof NBTTagByte)) {
                NBTTagList nbtTagList = new NBTTagList();
                nbtList.forEach(arg_0 -> ((NBTTagList)nbtTagList).func_74742_a(arg_0));
                return nbtTagList;
            }
            byte[] abyte = new byte[nbtList.size()];
            int i2 = 0;
            while (i2 < nbtList.size()) {
                abyte[i2] = ((NBTTagByte)nbtList.get(i2)).func_150290_f();
                ++i2;
            }
            return new NBTTagByteArray(abyte);
        }
        if (!(jsonElement instanceof JsonObject)) throw new IllegalArgumentException("Unhandled element " + jsonElement);
        JsonObject jsonObject = (JsonObject)jsonElement;
        NBTBase custom = NBTJson.restoreEmptyList(jsonObject);
        if (custom != null) return custom;
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        Iterator iterator = jsonObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry jsonEntry = (Map.Entry)iterator.next();
            nbtTagCompound.func_74782_a((String)jsonEntry.getKey(), NBTJson.toNbt((JsonElement)jsonEntry.getValue()));
        }
        return nbtTagCompound;
    }

    protected static JsonObject createEmptyList(Object obj) {
        JsonObject empty = new JsonObject();
        empty.add("__custom_type", (JsonElement)new JsonPrimitive(obj.getClass().getName()));
        return empty;
    }

    protected static NBTBase restoreEmptyList(JsonObject obj) {
        if (obj.has("__custom_type")) {
            try {
                String className = obj.get("__custom_type").getAsString();
                return (NBTBase)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }
        return null;
    }
}

