/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen.terrain;

import com.hbm.world.gen.MapGenBaseMeta;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class MapGenBubble
extends MapGenBaseMeta {
    private final int frequency;
    private int minSize = 8;
    private int maxSize = 64;
    public int minY = 0;
    public int rangeY = 25;
    public boolean fuzzy;
    public Block block;
    public byte meta = 0;
    public Block replace = Blocks.field_150348_b;
    public Predicate<BiomeGenBase> canSpawn;

    public MapGenBubble(int frequency) {
        this.frequency = frequency;
    }

    public void setSize(int minSize, int maxSize) {
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.field_75040_a = maxSize / 8 + 1;
    }

    protected void func_151538_a(World world, int offsetX, int offsetZ, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75038_b.nextInt(this.frequency) == this.frequency - 1 && (this.canSpawn == null || this.canSpawn.test(world.func_72807_a(offsetX * 16, offsetZ * 16)))) {
            int xCoord = (chunkX - offsetX) * 16 + this.field_75038_b.nextInt(16);
            int zCoord = (chunkZ - offsetZ) * 16 + this.field_75038_b.nextInt(16);
            int yCoord = this.field_75038_b.nextInt(this.rangeY) + this.minY;
            double radius = this.field_75038_b.nextInt(this.maxSize - this.minSize) + this.minSize;
            double radiusSqr = radius * radius / 2.0;
            int yMin = Math.max(1, MathHelper.func_76128_c((double)((double)yCoord - radius)));
            int yMax = MathHelper.func_76143_f((double)((double)yCoord + radius));
            for (int bx = 15; bx >= 0; --bx) {
                for (int bz = 15; bz >= 0; --bz) {
                    for (int by = yMin; by < yMax; ++by) {
                        int index = (bx * 16 + bz) * 256 + by;
                        if (blocks[index] != this.replace) continue;
                        int x = xCoord + bx;
                        int z = zCoord + bz;
                        int y = yCoord - by;
                        double rSqr = x * x + z * z + y * y * 3;
                        if (this.fuzzy) {
                            rSqr -= this.field_75038_b.nextDouble() * radiusSqr / 3.0;
                        }
                        if (!(rSqr < radiusSqr)) continue;
                        blocks[index] = this.block;
                        this.metas[index] = this.meta;
                    }
                }
            }
        }
    }
}

