/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.gen;

import com.hbm.config.GeneralConfig;
import com.hbm.config.StructureConfig;
import com.hbm.world.gen.component.BunkerComponents;
import com.hbm.world.gen.component.CivilianFeatures;
import com.hbm.world.gen.component.OfficeFeatures;
import com.hbm.world.gen.component.SiloComponent;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenNTMFeatures
extends MapGenStructure {
    private static List biomelist;
    private int maxDistanceBetweenScatteredFeatures = StructureConfig.structureMaxChunks;
    private int minDistanceBetweenScatteredFeatures = StructureConfig.structureMinChunks;

    public String func_143025_a() {
        return "NTMFeatures";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        int k = chunkX;
        int l = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int i1 = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int j1 = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(i1, j1, 14357617);
        i1 *= this.maxDistanceBetweenScatteredFeatures;
        j1 *= this.maxDistanceBetweenScatteredFeatures;
        if (k == (i1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && l == (j1 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures))) {
            BiomeGenBase biomegenbase = this.field_75039_c.func_72959_q().func_76935_a(k * 16 + 8, l * 16 + 8);
            if (biomelist == null) {
                biomelist = Arrays.asList(BiomeGenBase.field_76771_b, BiomeGenBase.field_76781_i, BiomeGenBase.field_76776_l, BiomeGenBase.field_76777_m, BiomeGenBase.field_150575_M);
            }
            for (BiomeGenBase biomegenbase1 : biomelist) {
                if (biomegenbase != biomegenbase1) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        if (this.field_75038_b.nextInt(15) == 0) {
            return new BunkerComponents.BunkerStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random rand, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            int i = (chunkX << 4) + 8;
            int j = (chunkZ << 4) + 8;
            BiomeGenBase biome = world.func_72807_a(i, j);
            if (biome.field_76749_E <= 0.25f && rand.nextInt(10) == 0) {
                SiloComponent silo = new SiloComponent(rand, i, j);
                this.field_75075_a.add(silo);
            } else if ((double)biome.field_76750_F >= 1.0 && biome.field_76751_G == 0.0f && !(biome instanceof BiomeGenMesa)) {
                if (rand.nextBoolean()) {
                    CivilianFeatures.NTMHouse1 house1 = new CivilianFeatures.NTMHouse1(rand, i, j);
                    this.field_75075_a.add(house1);
                } else {
                    CivilianFeatures.NTMHouse2 house2 = new CivilianFeatures.NTMHouse2(rand, i, j);
                    this.field_75075_a.add(house2);
                }
            } else {
                switch (rand.nextInt(6)) {
                    case 0: {
                        CivilianFeatures.NTMLab2 lab2 = new CivilianFeatures.NTMLab2(rand, i, j);
                        this.field_75075_a.add(lab2);
                        break;
                    }
                    case 1: {
                        CivilianFeatures.NTMLab1 lab1 = new CivilianFeatures.NTMLab1(rand, i, j);
                        this.field_75075_a.add(lab1);
                        break;
                    }
                    case 2: {
                        OfficeFeatures.LargeOffice office = new OfficeFeatures.LargeOffice(rand, i, j);
                        this.field_75075_a.add(office);
                        break;
                    }
                    case 3: {
                        OfficeFeatures.LargeOfficeCorner officeCorner = new OfficeFeatures.LargeOfficeCorner(rand, i, j);
                        this.field_75075_a.add(officeCorner);
                        break;
                    }
                    case 4: 
                    case 5: {
                        CivilianFeatures.RuralHouse1 ruralHouse = new CivilianFeatures.RuralHouse1(rand, i, j);
                        this.field_75075_a.add(ruralHouse);
                    }
                }
            }
            if (GeneralConfig.enableDebugMode) {
                System.out.print("[Debug] StructureStart at " + i + ", 64, " + j + "\n[Debug] Components: ");
                this.field_75075_a.forEach(component -> System.out.print(MapGenStructureIO.func_143036_a((StructureComponent)((StructureComponent)component)) + " "));
                System.out.print("\n");
            }
            this.func_75072_c();
        }
    }
}

