/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.util.SubChunkKey;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class SubChunkSnapshot {
    public static final SubChunkSnapshot EMPTY = new SubChunkSnapshot(new Block[]{Blocks.field_150350_a}, null);
    private final Block[] palette;
    private final short[] data;

    private SubChunkSnapshot(Block[] p, short[] d) {
        this.palette = p;
        this.data = d;
    }

    public static SubChunkSnapshot getSnapshot(World world, SubChunkKey key, boolean allowGeneration) {
        if (!world.func_72863_F().func_73149_a(key.getChunkXPos(), key.getChunkZPos()) && !allowGeneration) {
            return EMPTY;
        }
        Chunk chunk = world.func_72863_F().func_73154_d(key.getChunkXPos(), key.getChunkZPos());
        ExtendedBlockStorage ebs = chunk.func_76587_i()[key.getSubY()];
        if (ebs == null || ebs.func_76663_a()) {
            return EMPTY;
        }
        short[] data = new short[4096];
        ArrayList<Block> palette = new ArrayList<Block>();
        palette.add(Blocks.field_150350_a);
        HashMap<Block, Short> idxMap = new HashMap<Block, Short>();
        idxMap.put(Blocks.field_150350_a, (short)0);
        boolean allAir = true;
        for (int ly = 0; ly < 16; ++ly) {
            for (int lz = 0; lz < 16; ++lz) {
                for (int lx = 0; lx < 16; ++lx) {
                    int idx;
                    Block block = ebs.func_150819_a(lx, ly, lz);
                    if (block == Blocks.field_150350_a) {
                        idx = 0;
                    } else {
                        allAir = false;
                        Short e = (Short)idxMap.get(block);
                        if (e == null) {
                            idxMap.put(block, (short)palette.size());
                            palette.add(block);
                            idx = palette.size() - 1;
                        } else {
                            idx = e.shortValue();
                        }
                    }
                    data[ly << 8 | lz << 4 | lx] = (short)idx;
                }
            }
        }
        if (allAir) {
            return EMPTY;
        }
        return new SubChunkSnapshot(palette.toArray(new Block[0]), data);
    }

    public Block getBlock(int x, int y, int z) {
        if (this == EMPTY || this.data == null) {
            return Blocks.field_150350_a;
        }
        short idx = this.data[y << 8 | z << 4 | x];
        return idx >= 0 && idx < this.palette.length ? this.palette[idx] : Blocks.field_150350_a;
    }
}

