/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.network;

import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.network.RTTYSystem;
import com.hbm.util.BufferUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;

public class TileEntityRadioTorchLogic
extends TileEntityLoadedBase
implements IControlReceiver {
    public String channel = "";
    public int lastState = 0;
    public long lastUpdate;
    public boolean polling = false;
    public boolean descending = false;
    public String[] mapping = new String[16];
    public int[] conditions;

    public TileEntityRadioTorchLogic() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.mapping[i] = "";
        }
        this.conditions = new int[16];
        for (i = 0; i < 16; ++i) {
            this.conditions[i] = 0;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            RTTYSystem.RTTYChannel chan;
            if (!this.channel.isEmpty() && (chan = RTTYSystem.listen(this.field_145850_b, this.channel)) != null && (this.polling || chan.timeStamp > this.lastUpdate - 1L && chan.timeStamp != -1L)) {
                String msg = "" + chan.signal;
                this.lastUpdate = this.field_145850_b.func_82737_E();
                int nextState = 0;
                if (chan.timeStamp < this.lastUpdate - 2L && this.polling) {
                    msg = "0";
                }
                if (this.descending) {
                    for (int i = 15; i >= 0; --i) {
                        if (this.mapping[i].equals("") || !this.parseSignal(msg, i)) continue;
                        nextState = i;
                        break;
                    }
                } else {
                    for (int i = 0; i <= 15; ++i) {
                        if (this.mapping[i].equals("") || !this.parseSignal(msg, i)) continue;
                        nextState = i;
                        break;
                    }
                }
                if (this.lastState != nextState) {
                    this.lastState = nextState;
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
                    this.func_70296_d();
                }
            }
            this.networkPackNT(50);
        }
    }

    public boolean parseSignal(String signal, int index) {
        if (this.conditions[index] <= 5) {
            int sig = 0;
            int map = 0;
            try {
                sig = Integer.parseInt(signal);
                map = Integer.parseInt(this.mapping[index]);
            }
            catch (Exception x) {
                return false;
            }
            switch (this.conditions[index]) {
                default: {
                    return sig < map;
                }
                case 1: {
                    return sig <= map;
                }
                case 2: {
                    return sig >= map;
                }
                case 3: {
                    return sig > map;
                }
                case 4: {
                    return sig == map;
                }
                case 5: 
            }
            return sig != map;
        }
        switch (this.conditions[index]) {
            default: {
                return signal.equals(this.mapping[index]);
            }
            case 7: {
                return !signal.equals(this.mapping[index]);
            }
            case 8: {
                return signal.contains(this.mapping[index]);
            }
            case 9: 
        }
        return !signal.contains(this.mapping[index]);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        int i;
        super.func_145839_a(nbt);
        this.polling = nbt.func_74767_n("p");
        this.descending = nbt.func_74767_n("d");
        this.lastState = nbt.func_74762_e("l");
        this.lastUpdate = nbt.func_74763_f("u");
        this.channel = nbt.func_74779_i("c");
        for (i = 0; i < 16; ++i) {
            this.mapping[i] = nbt.func_74779_i("m" + i);
        }
        for (i = 0; i < 16; ++i) {
            this.conditions[i] = nbt.func_74762_e("c" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        int i;
        super.func_145841_b(nbt);
        nbt.func_74757_a("p", this.polling);
        nbt.func_74757_a("d", this.descending);
        nbt.func_74768_a("l", this.lastState);
        nbt.func_74772_a("u", this.lastUpdate);
        if (this.channel != null) {
            nbt.func_74778_a("c", this.channel);
        }
        for (i = 0; i < 16; ++i) {
            if (this.mapping[i].equals("")) continue;
            nbt.func_74778_a("m" + i, this.mapping[i]);
        }
        for (i = 0; i < 16; ++i) {
            if (this.conditions[i] <= 0) continue;
            nbt.func_74768_a("c" + i, this.conditions[i]);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        int i;
        buf.writeBoolean(this.polling);
        BufferUtil.writeString(buf, this.channel);
        buf.writeBoolean(this.descending);
        for (i = 0; i < 16; ++i) {
            BufferUtil.writeString(buf, this.mapping[i]);
        }
        for (i = 0; i < 16; ++i) {
            buf.writeInt(this.conditions[i]);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        int i;
        this.polling = buf.readBoolean();
        this.channel = BufferUtil.readString(buf);
        this.descending = buf.readBoolean();
        for (i = 0; i < 16; ++i) {
            this.mapping[i] = BufferUtil.readString(buf);
        }
        for (i = 0; i < 16; ++i) {
            this.conditions[i] = buf.readInt();
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("l", (byte)this.lastState);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        int last = this.lastState;
        this.lastState = pkt.func_148857_g().func_74771_c("l");
        if (this.lastState != last) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70011_f((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) < 16.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        int i;
        if (data.func_74764_b("p")) {
            this.polling = data.func_74767_n("p");
        }
        if (data.func_74764_b("c")) {
            this.channel = data.func_74779_i("c");
        }
        if (data.func_74764_b("d")) {
            this.descending = data.func_74767_n("d");
        }
        for (i = 0; i < 16; ++i) {
            if (!data.func_74764_b("m" + i)) continue;
            this.mapping[i] = data.func_74779_i("m" + i);
        }
        for (i = 0; i < 16; ++i) {
            if (!data.func_74764_b("c" + i)) continue;
            this.conditions[i] = data.func_74762_e("c" + i);
        }
        this.func_70296_d();
    }
}

