/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.machine.rbmk.RBMKControl;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.ICopiable;
import com.hbm.inventory.container.ContainerRBMKControl;
import com.hbm.inventory.gui.GUIRBMKControl;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.util.EnumUtil;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class TileEntityRBMKControlManual
extends TileEntityRBMKControl
implements IControlReceiver,
ICopiable {
    public RBMKColor color;
    public double startingLevel;

    @Override
    public String getName() {
        return "container.rbmkControl";
    }

    @Override
    public boolean isModerated() {
        return ((RBMKControl)this.func_145838_q()).moderated;
    }

    @Override
    public void setTarget(double target) {
        this.targetLevel = target;
        this.startingLevel = this.level;
    }

    @Override
    public double getMult() {
        double surge = 0.0;
        if (this.targetLevel < this.startingLevel && Math.abs(this.level - this.targetLevel) > 0.01) {
            surge = Math.sin(Math.pow(1.0 - this.level, 15.0) * Math.PI) * (this.startingLevel - this.targetLevel) * RBMKDials.getSurgeMod(this.field_145850_b);
        }
        return this.level + surge;
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            this.setTarget(data.func_74769_h("level"));
        }
        if (data.func_74764_b("color")) {
            int c = Math.abs(data.func_74762_e("color")) % RBMKColor.values().length;
            RBMKColor newCol = RBMKColor.values()[c];
            this.color = newCol == this.color ? null : newCol;
        }
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("startingLevel")) {
            this.startingLevel = nbt.func_74769_h("startingLevel");
        }
        this.color = nbt.func_74764_b("color") ? RBMKColor.values()[nbt.func_74762_e("color")] : null;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("startingLevel", this.startingLevel);
        nbt.func_74780_a("mult", this.getMult());
        if (this.color != null) {
            nbt.func_74768_a("color", this.color.ordinal());
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.startingLevel);
        if (this.color != null) {
            buf.writeInt(this.color.ordinal());
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.startingLevel = buf.readDouble();
        if (buf.isReadable(1)) {
            int color = buf.readInt();
            this.color = RBMKColor.values()[MathHelper.func_76125_a((int)color, (int)0, (int)RBMKColor.values().length)];
        }
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.CONTROL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = super.getNBTForConsole();
        if (this.color != null) {
            data.func_74777_a("color", (short)this.color.ordinal());
        } else {
            data.func_74777_a("color", (short)-1);
        }
        return data;
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getColor(Context context, Arguments args) {
        return new Object[]{this.color.ordinal()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] setColor(Context context, Arguments args) {
        int colorI = args.checkInteger(0);
        colorI = MathHelper.func_76125_a((int)colorI, (int)0, (int)4);
        this.color = RBMKColor.values()[colorI];
        return new Object[]{true};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerRBMKControl(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIRBMKControl(player.field_71071_by, this);
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("color", this.color.ordinal());
        return data;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        if (nbt.func_74764_b("color")) {
            this.color = (RBMKColor)((Object)EnumUtil.grabEnumSafely(RBMKColor.class, nbt.func_74762_e("color")));
        }
    }

    public static enum RBMKColor {
        RED,
        YELLOW,
        GREEN,
        BLUE,
        PURPLE;

    }
}

