/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.neutron.RBMKNeutronHandler;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public abstract class TileEntityRBMKControl
extends TileEntityRBMKSlottedBase
implements SimpleComponent,
CompatHandler.OCComponent {
    @SideOnly(value=Side.CLIENT)
    public double lastLevel;
    public double level;
    public static final double speed = 0.00277;
    public double targetLevel;

    public TileEntityRBMKControl() {
        super(0);
    }

    @Override
    public boolean isLidRemovable() {
        return false;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastLevel = this.level;
        } else {
            if (this.level < this.targetLevel) {
                this.level += 0.00277 * RBMKDials.getControlSpeed(this.field_145850_b);
                if (this.level > this.targetLevel) {
                    this.level = this.targetLevel;
                }
            }
            if (this.level > this.targetLevel) {
                this.level -= 0.00277 * RBMKDials.getControlSpeed(this.field_145850_b);
                if (this.level < this.targetLevel) {
                    this.level = this.targetLevel;
                }
            }
        }
        super.func_145845_h();
    }

    public void setTarget(double target) {
        this.targetLevel = target;
    }

    public double getMult() {
        return this.level;
    }

    @Override
    public int trackingRange() {
        return 100;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.level = nbt.func_74769_h("level");
        this.targetLevel = nbt.func_74769_h("targetLevel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("level", this.level);
        nbt.func_74780_a("targetLevel", this.targetLevel);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeDouble(this.level);
        buf.writeDouble(this.targetLevel);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.level = buf.readDouble();
        this.targetLevel = buf.readDouble();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void onMelt(int reduce) {
        int i;
        int count;
        if (this.isModerated()) {
            count = 2 + this.field_145850_b.field_73012_v.nextInt(2);
            for (i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.GRAPHITE);
            }
        }
        count = 2 + this.field_145850_b.field_73012_v.nextInt(2);
        for (i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.ROD);
        }
        this.standardMelt(reduce);
    }

    @Override
    public RBMKNeutronHandler.RBMKType getRBMKType() {
        return RBMKNeutronHandler.RBMKType.CONTROL_ROD;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("level", this.level);
        data.func_74780_a("targetLevel", this.targetLevel);
        return data;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "rbmk_control_rod";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getLevel(Context context, Arguments args) {
        return new Object[]{this.getMult() * 100.0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getTargetLevel(Context context, Arguments args) {
        return new Object[]{this.targetLevel * 100.0};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getCoordinates(Context context, Arguments args) {
        return new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getHeat(Context context, Arguments args) {
        return new Object[]{this.heat};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getInfo(Context context, Arguments args) {
        return new Object[]{this.heat, this.getMult() * 100.0, this.targetLevel * 100.0, this.field_145851_c, this.field_145848_d, this.field_145849_e};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] setLevel(Context context, Arguments args) {
        double newLevel = args.checkDouble(0) / 100.0;
        this.targetLevel = MathHelper.func_151237_a((double)newLevel, (double)0.0, (double)1.0);
        return new Object[0];
    }
}

