/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.fluidmk2.IFluidStandardReceiverMK2;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.tool.ItemTransporterLinker;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.toserver.NBTControlPacket;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.BufferUtil;
import com.hbm.util.InventoryUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityTransporterBase
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver,
IFluidStandardTransceiver {
    private String name = "Transporter";
    public FluidTank[] tanks;
    protected TileEntityTransporterBase linkedTransporter;
    private ItemTransporterLinker.TransporterInfo linkedTransporterInfo;
    private int inputSlotMax;
    private int outputSlotMax;
    private int inputTankMax;
    private int outputTankMax;
    FuelReceiver fuelReceiver = new FuelReceiver();

    public TileEntityTransporterBase(int slotCount, int tankCount, int tankSize) {
        this(slotCount, tankCount, tankSize, 0, 0, 0);
    }

    public TileEntityTransporterBase(int slotCount, int tankCount, int tankSize, int extraSlots, int extraTanks, int extraTankSize) {
        super(slotCount + tankCount / 2 + extraSlots + extraTanks);
        int i;
        this.tanks = new FluidTank[tankCount + extraTanks];
        for (i = 0; i < tankCount; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, tankSize);
        }
        for (i = tankCount; i < tankCount + extraTanks; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, extraTankSize);
        }
        this.inputSlotMax = slotCount / 2;
        this.outputSlotMax = slotCount;
        this.inputTankMax = tankCount / 2;
        this.outputTankMax = tankCount;
    }

    @Override
    public String getName() {
        return "container.transporter";
    }

    @Override
    public void func_145845_h() {
        int o;
        int i;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (i = 0; i < this.inputTankMax; ++i) {
            this.tanks[i].setType(this.outputSlotMax + i, this.slots);
            for (o = i + 1; o < this.inputTankMax; ++o) {
                this.splitFill(this.tanks[i], this.tanks[o]);
            }
        }
        for (i = this.inputTankMax; i < this.outputTankMax; ++i) {
            for (o = i + 1; o < this.outputTankMax; ++o) {
                this.splitFill(this.tanks[i], this.tanks[o]);
            }
        }
        for (i = this.outputTankMax; i < this.tanks.length; ++i) {
            this.tanks[i].setType(this.outputSlotMax + this.inputTankMax + i - this.outputTankMax, this.slots);
        }
        this.updateConnections();
        this.fetchLinkedTransporter();
        if (this.linkedTransporter != null && this.canSend(this.linkedTransporter)) {
            int i2;
            boolean isDirty = false;
            int sentItems = 0;
            int sentFluid = 0;
            for (i2 = 0; i2 < this.inputSlotMax; ++i2) {
                if (this.slots[i2] == null) continue;
                int beforeSize = this.slots[i2].field_77994_a;
                this.slots[i2] = InventoryUtil.tryAddItemToInventory(this.linkedTransporter.slots, this.linkedTransporter.inputSlotMax, this.linkedTransporter.outputSlotMax - 1, this.slots[i2]);
                int afterSize = this.slots[i2] != null ? this.slots[i2].field_77994_a : 0;
                sentItems += beforeSize - afterSize;
                isDirty = true;
            }
            for (i2 = 0; i2 < this.inputTankMax; ++i2) {
                int o2 = i2 + this.inputTankMax;
                this.linkedTransporter.tanks[o2].setTankType(this.tanks[i2].getTankType());
                int sourceFillLevel = this.tanks[i2].getFill();
                int targetFillLevel = this.linkedTransporter.tanks[o2].getFill();
                int spaceAvailable = this.linkedTransporter.tanks[o2].getMaxFill() - targetFillLevel;
                int amountToSend = Math.min(sourceFillLevel, spaceAvailable);
                if (amountToSend <= 0) continue;
                this.linkedTransporter.tanks[o2].setFill(targetFillLevel + amountToSend);
                this.tanks[i2].setFill(sourceFillLevel - amountToSend);
                sentFluid += amountToSend;
                isDirty = true;
            }
            this.hasSent(this.linkedTransporter, sentItems + sentFluid / 1000);
            if (isDirty) {
                this.markChanged();
                this.linkedTransporter.markChanged();
            }
        }
        this.networkPackNT(250);
    }

    private void updateConnections() {
        int i;
        for (DirPos pos : this.getConPos()) {
            for (i = 0; i < this.outputTankMax; ++i) {
                if (this.tanks[i].getTankType() == Fluids.NONE) continue;
                this.trySubscribe(this.tanks[i].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendFluid(this.tanks[i], this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        for (DirPos pos : this.getTankPos()) {
            for (i = this.outputTankMax; i < this.tanks.length; ++i) {
                if (this.tanks[i].getTankType() == Fluids.NONE) continue;
                this.trySubscribeFuel(this.tanks[i].getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
        }
        for (DirPos pos : this.getInsertPos()) {
            this.tryLoad(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
        for (DirPos pos : this.getExtractPos()) {
            this.tryUnload(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    private void tryLoad(int x, int y, int z, ForgeDirection dir) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)te;
        ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int[] access = sided != null ? sided.func_94128_d(dir.ordinal()) : null;
        for (int i = 0; i < (access != null ? access.length : inv.func_70302_i_()); ++i) {
            int j;
            int slot = access != null ? access[i] : i;
            ItemStack stack = inv.func_70301_a(slot);
            if (stack == null || sided != null && !sided.func_102008_b(slot, stack, dir.ordinal())) continue;
            for (j = 0; j < this.inputSlotMax; ++j) {
                if (this.slots[j] == null || !(this.slots[j].field_77994_a < this.slots[j].func_77976_d() & InventoryUtil.doesStackDataMatch(this.slots[j], stack))) continue;
                inv.func_70298_a(slot, 1);
                ++this.slots[j].field_77994_a;
                return;
            }
            for (j = 0; j < this.inputSlotMax; ++j) {
                if (this.slots[j] != null) continue;
                this.slots[j] = stack.func_77946_l();
                this.slots[j].field_77994_a = 1;
                inv.func_70298_a(slot, 1);
                return;
            }
        }
    }

    private void tryUnload(int x, int y, int z, ForgeDirection dir) {
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (!(te instanceof IInventory)) {
            return;
        }
        IInventory inv = (IInventory)te;
        ISidedInventory sided = inv instanceof ISidedInventory ? (ISidedInventory)inv : null;
        int[] access = sided != null ? sided.func_94128_d(dir.ordinal()) : null;
        for (int i = this.inputSlotMax; i < this.outputSlotMax; ++i) {
            int slot;
            int j;
            ItemStack out = this.slots[i];
            if (out == null) continue;
            for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                ItemStack target;
                int n = slot = access != null ? access[j] : j;
                if (!inv.func_94041_b(slot, out) || !InventoryUtil.doesStackDataMatch(out, target = inv.func_70301_a(slot)) || target.field_77994_a >= Math.min(target.func_77976_d(), inv.func_70297_j_())) continue;
                this.func_70298_a(i, 1);
                ++target.field_77994_a;
                return;
            }
            for (j = 0; j < (access != null ? access.length : inv.func_70302_i_()); ++j) {
                int n = slot = access != null ? access[j] : j;
                if (!inv.func_94041_b(slot, out) || inv.func_70301_a(slot) != null || !(sided != null ? sided.func_102007_a(slot, out, dir.ordinal()) : inv.func_94041_b(slot, out))) continue;
                ItemStack copy = out.func_77946_l();
                copy.field_77994_a = 1;
                inv.func_70299_a(slot, copy);
                this.func_70298_a(i, 1);
                return;
            }
        }
    }

    public void trySubscribeFuel(FluidType type, World world, int x, int y, int z, ForgeDirection dir) {
        this.fuelReceiver.trySubscribe(type, world, x, y, z, dir);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.fuelReceiver.valid = false;
    }

    private void splitFill(FluidTank in, FluidTank out) {
        if (in.getTankType() == out.getTankType()) {
            int fill = in.getFill() + out.getFill();
            float iFill = in.getMaxFill();
            float oFill = out.getMaxFill();
            float total = iFill + oFill;
            float iFrac = iFill / total;
            float oFrac = oFill / total;
            in.setFill(MathHelper.func_76123_f((float)(iFrac * (float)fill)));
            out.setFill(MathHelper.func_76128_c((double)(oFrac * (float)fill)));
            if (out.getFill() == out.getMaxFill() - 1) {
                out.setFill(out.getMaxFill());
            }
        }
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return Arrays.copyOfRange(this.tanks, this.inputTankMax, this.outputTankMax);
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return Arrays.copyOfRange(this.tanks, 0, this.inputTankMax);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        if (this.linkedTransporterInfo != null) {
            buf.writeBoolean(true);
            buf.writeInt(this.linkedTransporterInfo.dimensionId);
            buf.writeInt(this.linkedTransporterInfo.x);
            buf.writeInt(this.linkedTransporterInfo.y);
            buf.writeInt(this.linkedTransporterInfo.z);
        } else {
            buf.writeBoolean(false);
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
        BufferUtil.writeString(buf, this.name);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.linkedTransporter = null;
        if (buf.readBoolean()) {
            int id = buf.readInt();
            int x = buf.readInt();
            int y = buf.readInt();
            int z = buf.readInt();
            this.linkedTransporterInfo = new ItemTransporterLinker.TransporterInfo("Linked Transporter", id, x, y, z);
        } else {
            this.linkedTransporterInfo = null;
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
        this.name = BufferUtil.readString(buf);
    }

    protected abstract DirPos[] getConPos();

    protected abstract DirPos[] getTankPos();

    protected abstract DirPos[] getInsertPos();

    protected abstract DirPos[] getExtractPos();

    protected abstract boolean canSend(TileEntityTransporterBase var1);

    protected abstract void hasSent(TileEntityTransporterBase var1, int var2);

    protected abstract void hasConnected(TileEntityTransporterBase var1);

    protected int itemCount() {
        int i;
        int count = 0;
        for (i = 0; i < this.inputSlotMax; ++i) {
            if (this.slots[i] == null) continue;
            count += this.slots[i].field_77994_a;
        }
        for (i = 0; i < this.inputTankMax; ++i) {
            count += this.tanks[i].getFill() / 1000;
        }
        return count;
    }

    public String getTransporterName() {
        return this.name;
    }

    public void setTransporterName(String name) {
        this.name = name;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("name", name);
        PacketDispatcher.wrapper.sendToServer(new NBTControlPacket(data, this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    private void fetchLinkedTransporter() {
        WorldServer transporterWorld;
        TileEntity te;
        if (this.linkedTransporter == null && this.linkedTransporterInfo != null && (te = (transporterWorld = DimensionManager.getWorld((int)this.linkedTransporterInfo.dimensionId)).func_147438_o(this.linkedTransporterInfo.x, this.linkedTransporterInfo.y, this.linkedTransporterInfo.z)) != null && te instanceof TileEntityTransporterBase) {
            this.linkedTransporter = (TileEntityTransporterBase)te;
        }
    }

    public ItemTransporterLinker.TransporterInfo getLinkedTransporter() {
        return this.linkedTransporterInfo;
    }

    @Override
    public int[] func_94128_d(int side) {
        return IntStream.range(0, this.outputSlotMax).toArray();
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i < this.inputSlotMax;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int side) {
        return i >= this.inputSlotMax && i < this.outputSlotMax;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.name = nbt.func_74779_i("name");
        this.linkedTransporter = null;
        int dimensionId = nbt.func_74762_e("dimensionId");
        int[] coords = nbt.func_74759_k("linkedTo");
        this.linkedTransporterInfo = coords.length > 0 ? new ItemTransporterLinker.TransporterInfo("Linked Transporter", dimensionId, coords[0], coords[1], coords[2]) : null;
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("name", this.name);
        if (this.linkedTransporterInfo != null) {
            nbt.func_74768_a("dimensionId", this.linkedTransporterInfo.dimensionId);
            nbt.func_74783_a("linkedTo", new int[]{this.linkedTransporterInfo.x, this.linkedTransporterInfo.y, this.linkedTransporterInfo.z});
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    public void unlinkTransporter() {
        if (this.linkedTransporter != null) {
            this.linkedTransporter.linkedTransporter = null;
            this.linkedTransporter.linkedTransporterInfo = null;
        }
        this.linkedTransporter = null;
        this.linkedTransporterInfo = null;
    }

    @Override
    public void receiveControl(NBTTagCompound nbt) {
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("unlink")) {
            this.unlinkTransporter();
        }
        if (nbt.func_74764_b("linkedTo")) {
            if (this.linkedTransporter != null) {
                this.linkedTransporter.linkedTransporter = null;
                this.linkedTransporter.linkedTransporterInfo = null;
            }
            this.linkedTransporter = null;
            int[] coords = nbt.func_74759_k("linkedTo");
            int dimensionId = nbt.func_74762_e("dimensionId");
            this.linkedTransporterInfo = new ItemTransporterLinker.TransporterInfo("Linked Transporter", dimensionId, coords[0], coords[1], coords[2]);
            this.fetchLinkedTransporter();
            if (this.linkedTransporter != null) {
                this.linkedTransporter.linkedTransporterInfo = ItemTransporterLinker.TransporterInfo.from(this.field_145850_b.field_73011_w.field_76574_g, this);
                this.linkedTransporter.fetchLinkedTransporter();
                this.hasConnected(this.linkedTransporter);
            }
        }
        this.func_70296_d();
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    private class FuelReceiver
    implements IFluidStandardReceiverMK2 {
        boolean valid = true;

        private FuelReceiver() {
        }

        @Override
        public boolean isLoaded() {
            return this.valid && TileEntityTransporterBase.this.isLoaded();
        }

        @Override
        public FluidTank[] getAllTanks() {
            return TileEntityTransporterBase.this.getAllTanks();
        }

        @Override
        public FluidTank[] getReceivingTanks() {
            return Arrays.copyOfRange(TileEntityTransporterBase.this.tanks, TileEntityTransporterBase.this.outputTankMax, TileEntityTransporterBase.this.tanks.length);
        }

        @Override
        public IEnergyReceiverMK2.ConnectionPriority getFluidPriority() {
            return IEnergyReceiverMK2.ConnectionPriority.HIGH;
        }
    }
}

