/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluidmk2.IFluidStandardTransceiverMK2;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.TileEntityLoadedBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;

public class TileEntitySolarBoiler
extends TileEntityLoadedBase
implements IFluidStandardTransceiverMK2,
IBufPacketReceiver,
IFluidCopiable {
    private FluidTank water;
    private FluidTank steam;
    public int display;
    public int heat;
    public HashSet<ChunkCoordinates> primary = new HashSet();
    public HashSet<ChunkCoordinates> secondary = new HashSet();
    AxisAlignedBB bb = null;

    public TileEntitySolarBoiler() {
        this.water = new FluidTank(Fluids.WATER, 100);
        this.steam = new FluidTank(Fluids.STEAM, 10000);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int process;
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, Library.POS_Y);
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            float sunPower = this.field_145850_b.field_73011_w instanceof WorldProviderOrbit ? ((WorldProviderOrbit)this.field_145850_b.field_73011_w).getSunPower() : CelestialBody.getBody(this.field_145850_b).getSunPower();
            this.display = process = (int)((float)this.heat * sunPower) / 50;
            process = Math.min(process, this.water.getFill());
            process = Math.min(process, (this.steam.getMaxFill() - this.steam.getFill()) / 100);
            if (process < 0) {
                process = 0;
            }
            this.water.setFill(this.water.getFill() - process);
            this.steam.setFill(this.steam.getFill() + process * 100);
            this.tryProvide(this.steam, this.field_145850_b, this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, Library.POS_Y);
            this.tryProvide(this.steam, this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, Library.NEG_Y);
            this.heat = 0;
            this.networkPackNT(15);
        } else {
            this.secondary.clear();
            this.secondary.addAll(this.primary);
            this.primary.clear();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.water.readFromNBT(nbt, "water");
        this.steam.readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.water.writeToNBT(nbt, "water");
        this.steam.writeToNBT(nbt, "steam");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam};
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.display);
        this.water.serialize(buf);
        this.steam.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.display = buf.readInt();
        this.water.deserialize(buf);
        this.steam.deserialize(buf);
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }
}

