/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.UpgradeManagerNT;
import com.hbm.inventory.container.ContainerAssemfac;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIAssemfac;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IUpgradeInfoProvider;
import com.hbm.tileentity.machine.TileEntityMachineAssemblerBase;
import com.hbm.util.BobMathUtil;
import com.hbm.util.fauxpointtwelve.DirPos;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Deprecated
public class TileEntityMachineAssemfac
extends TileEntityMachineAssemblerBase
implements IFluidStandardTransceiver,
IUpgradeInfoProvider,
IFluidCopiable {
    public AssemblerArm[] arms;
    public FluidTank water;
    public FluidTank steam;
    public UpgradeManagerNT upgradeManager = new UpgradeManagerNT();
    AxisAlignedBB bb = null;
    DirPos[] inpos;
    DirPos[] outpos;

    public TileEntityMachineAssemfac() {
        super(117);
        this.arms = new AssemblerArm[6];
        for (int i = 0; i < this.arms.length; ++i) {
            this.arms[i] = new AssemblerArm(i % 3 == 1 ? 1 : 0);
        }
        this.water = new FluidTank(Fluids.WATER, 64000);
        this.steam = new FluidTank(Fluids.SPENTSTEAM, 64000);
    }

    @Override
    public String getName() {
        return "container.assemfac";
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 1 && i <= 4 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.updateConnections();
            }
            this.speed = 100;
            this.consumption = 100;
            this.upgradeManager.checkSlots(this, this.slots, 1, 4);
            int speedLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.SPEED);
            int powerLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.POWER);
            int overLevel = this.upgradeManager.getLevel(ItemMachineUpgrade.UpgradeType.OVERDRIVE);
            this.speed -= speedLevel * 15;
            this.consumption += speedLevel * 300;
            this.speed += powerLevel * 5;
            this.consumption -= powerLevel * 30;
            this.speed /= overLevel + 1;
            this.consumption *= overLevel + 1;
            for (DirPos pos : this.getConPos()) {
                this.sendFluid(this.steam, this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            this.networkPackNT(150);
        } else {
            for (AssemblerArm arm : this.arms) {
                arm.updateInterp();
                if (!this.isProgressing) continue;
                arm.updateArm();
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        for (int i = 0; i < this.getRecipeCount(); ++i) {
            buf.writeInt(this.progress[i]);
            buf.writeInt(this.maxProgress[i]);
        }
        buf.writeBoolean(this.isProgressing);
        this.water.serialize(buf);
        this.steam.serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        for (int i = 0; i < this.getRecipeCount(); ++i) {
            this.progress[i] = buf.readInt();
            this.maxProgress[i] = buf.readInt();
        }
        this.isProgressing = buf.readBoolean();
        this.water.deserialize(buf);
        this.steam.deserialize(buf);
    }

    private int getWaterRequired() {
        return 1000 / this.speed;
    }

    @Override
    protected boolean canProcess(int index) {
        return super.canProcess(index) && this.water.getFill() >= this.getWaterRequired() && this.steam.getFill() + this.getWaterRequired() <= this.steam.getMaxFill();
    }

    @Override
    protected void process(int index) {
        super.process(index);
        this.water.setFill(this.water.getFill() - this.getWaterRequired());
        this.steam.setFill(this.steam.getFill() + this.getWaterRequired());
    }

    private void updateConnections() {
        for (DirPos pos : this.getConPos()) {
            this.trySubscribe(this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            this.trySubscribe(this.water.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
        }
    }

    public DirPos[] getConPos() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        return new DirPos[]{new DirPos(this.field_145851_c - dir.offsetX * 3 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 + rot.offsetZ * 5, rot), new DirPos(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * 5, rot), new DirPos(this.field_145851_c - dir.offsetX * 3 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 3 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 2 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 5 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 + rot.offsetZ * 3, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 5 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 - rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 3, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 3, dir), new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ * 2, dir)};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)this.field_145848_d, (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 5));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public int getRecipeCount() {
        return 8;
    }

    @Override
    public int getTemplateIndex(int index) {
        return 17 + index * 14;
    }

    @Override
    public int[] getSlotIndicesFromIndex(int index) {
        return new int[]{5 + index * 14, 16 + index * 14, 18 + index * 14};
    }

    @Override
    public DirPos[] getInputPositions() {
        if (this.inpos != null) {
            return this.inpos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.inpos = new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 - rot.offsetX * 1, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 - rot.offsetZ * 1, dir), new DirPos(this.field_145851_c - dir.offsetX * 5 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 + rot.offsetZ * 2, dir.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 1 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 + rot.offsetZ * 5, rot)};
        return this.inpos;
    }

    @Override
    public DirPos[] getOutputPositions() {
        if (this.outpos != null) {
            return this.outpos;
        }
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        this.outpos = new DirPos[]{new DirPos(this.field_145851_c + dir.offsetX * 4 + rot.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 4 + rot.offsetZ * 2, dir), new DirPos(this.field_145851_c - dir.offsetX * 5 - rot.offsetX * 1, this.field_145848_d, this.field_145849_e - dir.offsetZ * 5 - rot.offsetZ * 1, dir.getOpposite()), new DirPos(this.field_145851_c + dir.offsetX * 1 - rot.offsetX * 4, this.field_145848_d, this.field_145849_e + dir.offsetZ * 1 - rot.offsetZ * 4, rot.getOpposite()), new DirPos(this.field_145851_c - dir.offsetX * 2 + rot.offsetX * 5, this.field_145848_d, this.field_145849_e - dir.offsetZ * 2 + rot.offsetZ * 5, rot)};
        return this.outpos;
    }

    @Override
    public int getPowerSlot() {
        return 0;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.steam};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.water};
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.water, this.steam};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerAssemfac(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIAssemfac(player.field_71071_by, this);
    }

    @Override
    public boolean canProvideInfo(ItemMachineUpgrade.UpgradeType type, int level, boolean extendedInfo) {
        return type == ItemMachineUpgrade.UpgradeType.SPEED || type == ItemMachineUpgrade.UpgradeType.POWER || type == ItemMachineUpgrade.UpgradeType.OVERDRIVE;
    }

    @Override
    public void provideInfo(ItemMachineUpgrade.UpgradeType type, int level, List<String> info, boolean extendedInfo) {
        info.add(IUpgradeInfoProvider.getStandardLabel(ModBlocks.machine_assemfac));
        if (type == ItemMachineUpgrade.UpgradeType.SPEED) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.delay", "-" + level * 15 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.consumption", "+" + level * 300 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.POWER) {
            info.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("upgrade.consumption", "-" + level * 30 + "%"));
            info.add(EnumChatFormatting.RED + I18nUtil.resolveKey("upgrade.delay", "+" + level * 5 + "%"));
        }
        if (type == ItemMachineUpgrade.UpgradeType.OVERDRIVE) {
            info.add((BobMathUtil.getBlink() ? EnumChatFormatting.RED : EnumChatFormatting.DARK_GRAY) + "YES");
        }
    }

    @Override
    public HashMap<ItemMachineUpgrade.UpgradeType, Integer> getValidUpgrades() {
        HashMap<ItemMachineUpgrade.UpgradeType, Integer> upgrades = new HashMap<ItemMachineUpgrade.UpgradeType, Integer>();
        upgrades.put(ItemMachineUpgrade.UpgradeType.SPEED, 6);
        upgrades.put(ItemMachineUpgrade.UpgradeType.POWER, 3);
        upgrades.put(ItemMachineUpgrade.UpgradeType.OVERDRIVE, 12);
        return upgrades;
    }

    @Override
    public FluidTank getTankToPaste() {
        return null;
    }

    public static class AssemblerArm {
        public double[] angles = new double[4];
        public double[] prevAngles = new double[4];
        public double[] targetAngles = new double[4];
        public double[] speed = new double[4];
        Random rand = new Random();
        int actionMode;
        ArmActionState state;
        int actionDelay = 0;

        public AssemblerArm(int actionMode) {
            this.actionMode = actionMode;
            if (this.actionMode == 0) {
                this.speed[0] = 15.0;
                this.speed[1] = 15.0;
                this.speed[2] = 15.0;
                this.speed[3] = 0.5;
            } else if (this.actionMode == 1) {
                this.speed[0] = 3.0;
                this.speed[1] = 3.0;
                this.speed[2] = 1.0;
                this.speed[3] = 0.125;
            }
            this.state = ArmActionState.ASSUME_POSITION;
            this.chooseNewArmPoistion();
            this.actionDelay = this.rand.nextInt(20);
        }

        public void updateArm() {
            if (this.actionDelay > 0) {
                --this.actionDelay;
                return;
            }
            switch (this.state) {
                case ASSUME_POSITION: {
                    if (!this.move()) break;
                    if (this.actionMode == 0) {
                        this.actionDelay = 2;
                    } else if (this.actionMode == 1) {
                        this.actionDelay = 10;
                    }
                    this.state = ArmActionState.EXTEND_STRIKER;
                    this.targetAngles[3] = 1.0;
                    break;
                }
                case EXTEND_STRIKER: {
                    if (!this.move()) break;
                    if (this.actionMode == 0) {
                        this.state = ArmActionState.RETRACT_STRIKER;
                        this.targetAngles[3] = 0.0;
                        break;
                    }
                    if (this.actionMode != 1) break;
                    this.state = ArmActionState.WELD;
                    this.targetAngles[2] = this.targetAngles[2] - 20.0;
                    this.actionDelay = 5 + this.rand.nextInt(5);
                    break;
                }
                case WELD: {
                    if (!this.move()) break;
                    this.state = ArmActionState.RETRACT_STRIKER;
                    this.targetAngles[3] = 0.0;
                    this.actionDelay = 10 + this.rand.nextInt(5);
                    break;
                }
                case RETRACT_STRIKER: {
                    if (!this.move()) break;
                    if (this.actionMode == 0) {
                        this.actionDelay = 2 + this.rand.nextInt(5);
                    } else if (this.actionMode == 1) {
                        this.actionDelay = 5 + this.rand.nextInt(3);
                    }
                    this.chooseNewArmPoistion();
                    this.state = ArmActionState.ASSUME_POSITION;
                }
            }
        }

        public void chooseNewArmPoistion() {
            if (this.actionMode == 0) {
                this.targetAngles[0] = -this.rand.nextInt(50);
                this.targetAngles[1] = -this.targetAngles[0];
                this.targetAngles[2] = this.rand.nextInt(30) - 15;
            } else if (this.actionMode == 1) {
                this.targetAngles[0] = -this.rand.nextInt(30) + 10;
                this.targetAngles[1] = -this.targetAngles[0];
                this.targetAngles[2] = this.rand.nextInt(10) + 10;
            }
        }

        private void updateInterp() {
            for (int i = 0; i < this.angles.length; ++i) {
                this.prevAngles[i] = this.angles[i];
            }
        }

        private boolean move() {
            boolean didMove = false;
            for (int i = 0; i < this.angles.length; ++i) {
                if (this.angles[i] == this.targetAngles[i]) continue;
                didMove = true;
                double angle = this.angles[i];
                double target = this.targetAngles[i];
                double turn = this.speed[i];
                double delta = Math.abs(angle - target);
                if (delta <= turn) {
                    this.angles[i] = this.targetAngles[i];
                    continue;
                }
                if (angle < target) {
                    int n = i;
                    this.angles[n] = this.angles[n] + turn;
                    continue;
                }
                int n = i;
                this.angles[n] = this.angles[n] - turn;
            }
            return !didMove;
        }

        public static enum ArmActionState {
            ASSUME_POSITION,
            EXTEND_STRIKER,
            WELD,
            RETRACT_STRIKER;

        }
    }
}

