/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.inventory.container.ContainerICFPress;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUIICFPress;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemICFPellet;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntityICFPress
extends TileEntityMachineBase
implements IFluidStandardReceiver,
IGUIProvider,
IFluidCopiable {
    public FluidTank[] tanks = new FluidTank[2];
    public int muon;
    public static final int maxMuon = 16;
    public static boolean[] usedFluid = new boolean[2];
    public static final int[] topBottom = new int[]{0, 1, 2, 3, 4};
    public static final int[] sides = new int[]{0, 1, 2, 3, 5};

    public TileEntityICFPress() {
        super(8);
        this.tanks[0] = new FluidTank(Fluids.DEUTERIUM, 16000);
        this.tanks[1] = new FluidTank(Fluids.TRITIUM, 16000);
    }

    @Override
    public String getName() {
        return "container.machineICFPress";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].setType(6, this.slots);
            this.tanks[1].setType(7, this.slots);
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                this.subscribeToAllAround(this.tanks[0].getTankType(), this);
                this.subscribeToAllAround(this.tanks[1].getTankType(), this);
            }
            if (this.muon <= 0 && this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.particle_muon) {
                ItemStack container = this.slots[2].func_77973_b().getContainerItem(this.slots[2]);
                boolean canStore = false;
                if (container == null) {
                    canStore = true;
                } else if (this.slots[3] == null) {
                    this.slots[3] = container.func_77946_l();
                    canStore = true;
                } else if (this.slots[3].func_77973_b() == container.func_77973_b() && this.slots[3].func_77960_j() == container.func_77960_j() && this.slots[3].field_77994_a < this.slots[3].func_77976_d()) {
                    ++this.slots[3].field_77994_a;
                    canStore = true;
                }
                if (canStore) {
                    this.muon = 16;
                    this.func_70298_a(2, 1);
                    this.func_70296_d();
                }
            }
            this.press();
            this.networkPackNT(15);
        }
    }

    public void press() {
        if (this.slots[0] == null || this.slots[0].func_77973_b() != ModItems.icf_pellet_empty) {
            return;
        }
        if (this.slots[1] != null) {
            return;
        }
        ItemICFPellet.init();
        ItemICFPellet.EnumICFFuel fuel1 = this.getFuel(this.tanks[0], this.slots[4], 0);
        ItemICFPellet.EnumICFFuel fuel2 = this.getFuel(this.tanks[1], this.slots[5], 1);
        if (fuel1 == null || fuel2 == null || fuel1 == fuel2) {
            return;
        }
        this.slots[1] = ItemICFPellet.setup(fuel1, fuel2, this.muon > 0);
        if (this.muon > 0) {
            --this.muon;
        }
        this.func_70298_a(0, 1);
        if (usedFluid[0]) {
            this.tanks[0].setFill(this.tanks[0].getFill() - 1000);
        } else {
            this.func_70298_a(4, 1);
        }
        if (usedFluid[1]) {
            this.tanks[1].setFill(this.tanks[1].getFill() - 1000);
        } else {
            this.func_70298_a(5, 1);
        }
        this.markChanged();
    }

    public ItemICFPellet.EnumICFFuel getFuel(FluidTank tank, ItemStack slot, int index) {
        TileEntityICFPress.usedFluid[index] = false;
        if (tank.getFill() >= 1000 && ItemICFPellet.fluidMap.containsKey(tank.getTankType())) {
            TileEntityICFPress.usedFluid[index] = true;
            return ItemICFPellet.fluidMap.get(tank.getTankType());
        }
        if (slot == null) {
            return null;
        }
        List<Mats.MaterialStack> mats = Mats.getMaterialsFromItem(slot);
        if (mats == null || mats.size() != 1) {
            return null;
        }
        Mats.MaterialStack mat = mats.get(0);
        if (mat.amount != MaterialShapes.INGOT.q(1)) {
            return null;
        }
        return ItemICFPellet.materialMap.get(mat.material);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeByte((int)((byte)this.muon));
        this.tanks[0].serialize(buf);
        this.tanks[1].serialize(buf);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.muon = buf.readByte();
        this.tanks[0].deserialize(buf);
        this.tanks[1].deserialize(buf);
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_77973_b() == ModItems.icf_pellet_empty) {
            return slot == 0;
        }
        if (stack.func_77973_b() == ModItems.particle_muon) {
            return slot == 2;
        }
        return slot == 4 || slot == 5;
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 || side == 1 ? topBottom : sides;
    }

    @Override
    public boolean func_102008_b(int slot, ItemStack itemStack, int side) {
        return slot == 1 || slot == 3;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "t0");
        this.tanks[1].readFromNBT(nbt, "t1");
        this.muon = nbt.func_74771_c("muon");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "t0");
        this.tanks[1].writeToNBT(nbt, "t1");
        nbt.func_74774_a("muon", (byte)this.muon);
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerICFPress(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIICFPress(player.field_71071_by, this);
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }
}

