/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import api.hbm.tile.IHeatSource;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerOilburner;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.fluid.trait.FluidTrait;
import com.hbm.inventory.gui.GUIOilburner;
import com.hbm.lib.Library;
import com.hbm.tileentity.IFluidCopiable;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class TileEntityHeaterOilburner
extends TileEntityMachinePolluting
implements IGUIProvider,
IFluidStandardTransceiver,
IHeatSource,
IControlReceiver,
IFluidCopiable {
    public boolean isOn = false;
    public FluidTank tank = new FluidTank(Fluids.HEATINGOIL, 16000);
    public int setting = 1;
    public int heatEnergy;
    public static final int maxHeatEnergy = 100000;
    AxisAlignedBB bb = null;

    public TileEntityHeaterOilburner() {
        super(3, 100);
    }

    @Override
    public String getName() {
        return "container.heaterOilburner";
    }

    public DirPos[] getConPos() {
        return new DirPos[]{new DirPos(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X), new DirPos(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z), new DirPos(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z)};
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tank.loadTank(0, 1, this.slots);
            this.tank.setType(2, this.slots);
            for (DirPos pos : this.getConPos()) {
                this.trySubscribe(this.tank.getTankType(), this.field_145850_b, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
                this.sendSmoke(pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
            }
            boolean shouldCool = true;
            if (this.isOn && this.heatEnergy < 100000 && this.tank.getTankType().hasTrait(FT_Flammable.class)) {
                FT_Flammable type = this.tank.getTankType().getTrait(FT_Flammable.class);
                int burnRate = this.setting;
                int toBurn = Math.min(burnRate, this.tank.getFill());
                if (toBurn > 0 && this.breatheAir(toBurn)) {
                    this.tank.setFill(this.tank.getFill() - toBurn);
                    int heat = (int)(type.getHeatEnergy() / 1000L);
                    this.heatEnergy += heat * toBurn;
                    if (this.field_145850_b.func_82737_E() % 5L == 0L && toBurn > 0) {
                        super.pollute(this.tank.getTankType(), FluidTrait.FluidReleaseType.BURN, toBurn * 5);
                    }
                    shouldCool = false;
                }
            }
            if (this.heatEnergy >= 100000) {
                shouldCool = false;
            }
            if (shouldCool) {
                this.heatEnergy = Math.max(this.heatEnergy - Math.max(this.heatEnergy / 1000, 1), 0);
            }
            this.networkPackNT(25);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        this.tank.serialize(buf);
        buf.writeBoolean(this.isOn);
        buf.writeInt(this.heatEnergy);
        buf.writeByte((int)((byte)this.setting));
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.tank.deserialize(buf);
        this.isOn = buf.readBoolean();
        this.heatEnergy = buf.readInt();
        this.setting = buf.readByte();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tank.readFromNBT(nbt, "tank");
        this.isOn = nbt.func_74767_n("isOn");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
        this.setting = nbt.func_74771_c("setting");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tank.writeToNBT(nbt, "tank");
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
        nbt.func_74774_a("setting", (byte)this.setting);
    }

    public void toggleSetting() {
        ++this.setting;
        if (this.setting > 10) {
            this.setting = 1;
        }
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerOilburner(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIOilburner(player.field_71071_by, this);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return player.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 256.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("toggle")) {
            this.isOn = !this.isOn;
        }
        this.markChanged();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[]{this.tank};
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    @Override
    public NBTTagCompound getSettings(World world, int x, int y, int z) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("fluidID", new int[]{this.tank.getTankType().getID()});
        tag.func_74768_a("burnRate", this.setting);
        tag.func_74757_a("isOn", this.isOn);
        return tag;
    }

    @Override
    public void pasteSettings(NBTTagCompound nbt, int index, World world, EntityPlayer player, int x, int y, int z) {
        int id = nbt.func_74759_k("fluidID")[index];
        this.tank.setTankType(Fluids.fromID(id));
        if (nbt.func_74764_b("isOn")) {
            this.isOn = nbt.func_74767_n("isOn");
        }
        if (nbt.func_74764_b("burnRate")) {
            this.setting = nbt.func_74762_e("burnRate");
        }
    }
}

