/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockHadronCoil;
import com.hbm.blocks.machine.BlockHadronPlating;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.inventory.container.ContainerHadron;
import com.hbm.inventory.gui.GUIHadron;
import com.hbm.inventory.recipes.HadronRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityHadronDiode;
import com.hbm.tileentity.machine.TileEntityHadronPower;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHadron
extends TileEntityMachineBase
implements IEnergyReceiverMK2,
IGUIProvider {
    public long power;
    public static final long maxPower = 10000000L;
    public boolean isOn = false;
    public boolean analysisOnly = false;
    public int ioMode = 0;
    public static final int MODE_DEFAULT = 0;
    public static final int MODE_HOPPER = 1;
    public static final int MODE_SINGLE = 2;
    private int delay;
    public EnumHadronState state = EnumHadronState.IDLE;
    private static final int delaySuccess = 20;
    private static final int delayNoResult = 60;
    private static final int delayError = 100;
    public boolean stat_success = false;
    public EnumHadronState stat_state = EnumHadronState.IDLE;
    public int stat_charge = 0;
    public int stat_x = 0;
    public int stat_y = 0;
    public int stat_z = 0;
    private static final int[] access = new int[]{0, 1, 2, 3};
    static final int maxParticles = 1;
    List<Particle> particles = new ArrayList<Particle>();
    List<Particle> particlesToRemove = new ArrayList<Particle>();
    List<Particle> particlesToAdd = new ArrayList<Particle>();
    List<Particle> particlesCompleted = new ArrayList<Particle>();

    public TileEntityHadron() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.hadron";
    }

    @Override
    public int[] func_94128_d(int side) {
        return access;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2 || i == 3;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i != 0 && i != 1) {
            return false;
        }
        if (this.ioMode == 2) {
            return this.slots[i] == null;
        }
        if (this.slots[0] != null && this.slots[1] != null && this.slots[0].func_77973_b() == this.slots[1].func_77973_b() && this.slots[0].func_77960_j() == this.slots[1].func_77960_j()) {
            if (i == 0) {
                return this.slots[1].field_77994_a - this.slots[0].field_77994_a >= 0;
            }
            if (i == 1) {
                return this.slots[0].field_77994_a - this.slots[1].field_77994_a >= 0;
            }
        }
        return true;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 4, this.power, 10000000L);
            this.drawPower();
            this.particles.addAll(this.particlesToAdd);
            this.particlesToAdd.clear();
            if (this.delay <= 0 && this.isOn && this.particles.size() < 1 && this.slots[0] != null && this.slots[1] != null && (double)this.power >= 7500000.0 && (this.ioMode != 1 || this.slots[0].field_77994_a > 1 && this.slots[1].field_77994_a > 1)) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                this.particles.add(new Particle(this.slots[0], this.slots[1], dir, this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
                this.power = (long)((double)this.power - 7500000.0);
                this.state = EnumHadronState.PROGRESS;
            }
            if (this.delay > 0) {
                --this.delay;
            } else if (this.particles.isEmpty()) {
                this.state = EnumHadronState.IDLE;
            }
            if (!this.particles.isEmpty()) {
                this.updateParticles();
            }
            for (Particle p : this.particlesToRemove) {
                this.particles.remove(p);
            }
            this.particlesToRemove.clear();
            if (this.particles.isEmpty() && !this.particlesCompleted.isEmpty()) {
                ItemStack[] result = null;
                Particle particle = null;
                this.particlesCompleted.sort((p1, p2) -> p1.momentum - p2.momentum);
                Iterator<Particle> iterator = this.particlesCompleted.iterator();
                while (iterator.hasNext()) {
                    Particle p;
                    particle = p = iterator.next();
                    result = HadronRecipes.getOutput(p.item1, p.item2, p.momentum, this.analysisOnly);
                    if (result == null) continue;
                    break;
                }
                this.process(particle, result);
                this.particlesCompleted.clear();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74772_a("power", this.power);
            data.func_74757_a("analysis", this.analysisOnly);
            data.func_74768_a("ioMode", this.ioMode);
            data.func_74774_a("state", (byte)this.state.ordinal());
            data.func_74757_a("stat_success", this.stat_success);
            data.func_74774_a("stat_state", (byte)this.stat_state.ordinal());
            data.func_74768_a("stat_charge", this.stat_charge);
            data.func_74768_a("stat_x", this.stat_x);
            data.func_74768_a("stat_y", this.stat_y);
            data.func_74768_a("stat_z", this.stat_z);
            this.networkPackNT(50);
        }
    }

    private void process(Particle p, ItemStack[] result) {
        p.consumePower();
        if (result == null) {
            this.state = HadronRecipes.returnCode;
            this.setStats(this.state, p.momentum, false);
            this.delay = 60;
            this.field_145850_b.func_72908_a((double)p.posX, (double)p.posY, (double)p.posZ, "random.orb", 2.0f, 0.5f);
            return;
        }
        if ((this.slots[2] == null || this.slots[2].func_77973_b() == result[0].func_77973_b() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) && (this.slots[3] == null || this.slots[3].func_77973_b() == result[1].func_77973_b() && this.slots[3].field_77994_a < this.slots[3].func_77976_d())) {
            for (int i = 2; i <= 3; ++i) {
                if (this.slots[i] == null) {
                    this.slots[i] = result[i - 2].func_77946_l();
                    continue;
                }
                ++this.slots[i].field_77994_a;
            }
            if (result[0].func_77973_b() == ModItems.particle_digamma) {
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(128.0, 50.0, 128.0));
                for (EntityPlayer player : players) {
                    player.func_71029_a((StatBase)MainRegistry.achOmega12);
                }
            }
        }
        this.field_145850_b.func_72908_a((double)p.posX, (double)p.posY, (double)p.posZ, "random.orb", 2.0f, 1.0f);
        this.delay = 20;
        this.state = EnumHadronState.SUCCESS;
        this.setStats(this.state, p.momentum, true);
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isOn);
        buf.writeLong(this.power);
        buf.writeBoolean(this.analysisOnly);
        buf.writeInt(this.ioMode);
        buf.writeByte((int)((byte)this.state.ordinal()));
        buf.writeBoolean(this.stat_success);
        buf.writeByte((int)((byte)this.stat_state.ordinal()));
        buf.writeInt(this.stat_charge);
        buf.writeInt(this.stat_x);
        buf.writeInt(this.stat_y);
        buf.writeInt(this.stat_z);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isOn = buf.readBoolean();
        this.power = buf.readLong();
        this.analysisOnly = buf.readBoolean();
        this.ioMode = buf.readInt();
        this.state = EnumHadronState.values()[buf.readByte()];
        this.stat_success = buf.readBoolean();
        this.stat_state = EnumHadronState.values()[buf.readByte()];
        this.stat_charge = buf.readInt();
        this.stat_x = buf.readInt();
        this.stat_y = buf.readInt();
        this.stat_z = buf.readInt();
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (meta == 1) {
            boolean bl = this.analysisOnly = !this.analysisOnly;
        }
        if (meta == 2) {
            ++this.ioMode;
            if (this.ioMode > 2) {
                this.ioMode = 0;
            }
        }
        this.markChanged();
    }

    private void drawPower() {
        for (ForgeDirection dir : this.getRandomDirs()) {
            if (this.power == 10000000L) {
                return;
            }
            int x = this.field_145851_c + dir.offsetX * 2;
            int y = this.field_145848_d + dir.offsetY * 2;
            int z = this.field_145849_e + dir.offsetZ * 2;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (!(te instanceof TileEntityHadronPower)) continue;
            TileEntityHadronPower plug = (TileEntityHadronPower)te;
            long toDraw = Math.min(10000000L - this.power, plug.getPower());
            this.setPower(this.power + toDraw);
            plug.setPower(plug.getPower() - toDraw);
        }
    }

    private void finishParticle(Particle p) {
        this.particlesToRemove.add(p);
        if (!p.isExpired()) {
            this.particlesCompleted.add(p);
        }
        p.expired = true;
    }

    private void updateParticles() {
        for (Particle particle : this.particles) {
            particle.update();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOn = nbt.func_74767_n("isOn");
        this.power = nbt.func_74763_f("power");
        this.analysisOnly = nbt.func_74767_n("analysis");
        this.ioMode = nbt.func_74762_e("ioMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("analysis", this.analysisOnly);
        nbt.func_74768_a("ioMode", this.ioMode);
    }

    public int getPowerScaled(int i) {
        return (int)(this.power * (long)i / 10000000L);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
        this.func_70296_d();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public boolean canConnect(ForgeDirection dir) {
        return false;
    }

    private void setStats(EnumHadronState state, int count, boolean success) {
        this.stat_state = state;
        this.stat_charge = count;
        this.stat_success = success;
    }

    private void setExpireStats(EnumHadronState state, int count, int x, int y, int z) {
        this.stat_state = state;
        this.stat_charge = count;
        this.stat_x = x;
        this.stat_y = y;
        this.stat_z = z;
        this.stat_success = false;
    }

    public void expire(Particle particle, EnumHadronState reason) {
        if (particle.expired) {
            return;
        }
        particle.consumePower();
        for (Particle p : this.particles) {
            p.expired = true;
            this.particlesToRemove.add(p);
        }
        this.field_145850_b.func_72885_a(null, (double)particle.posX + 0.5, (double)particle.posY + 0.5, (double)particle.posZ + 0.5, 10.0f, false, false);
        this.particlesCompleted.clear();
        this.state = reason;
        this.delay = 100;
        this.setExpireStats(reason, particle.momentum, particle.posX, particle.posY, particle.posZ);
    }

    public void makeSteppy(Particle p) {
        ForgeDirection dir = p.dir;
        p.posX += dir.offsetX;
        p.posY += dir.offsetY;
        p.posZ += dir.offsetZ;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityHadron) {
            if (p.analysis != 3) {
                this.expire(p, EnumHadronState.ERROR_NO_ANALYSIS);
            } else {
                this.finishParticle(p);
            }
            return;
        }
        if (block.func_149688_o() != Material.field_151579_a && block != ModBlocks.hadron_diode) {
            this.expire(p, EnumHadronState.ERROR_OBSTRUCTED_CHANNEL);
        }
        if (block == ModBlocks.hadron_diode) {
            p.isCheckExempt = true;
        }
        if (this.isValidCoil(this.field_145850_b.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ))) {
            p.isCheckExempt = true;
        }
    }

    public void checkSegment(Particle p) {
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int dX = 1 - Math.abs(dir.offsetX);
        int dY = 1 - Math.abs(dir.offsetY);
        int dZ = 1 - Math.abs(dir.offsetZ);
        boolean analysis = true;
        int totalValue = 0;
        for (int a = x - dX * 2; a <= x + dX * 2; ++a) {
            for (int b = y - dY * 2; b <= y + dY * 2; ++b) {
                for (int c = z - dZ * 2; c <= z + dZ * 2; ++c) {
                    Block block = this.field_145850_b.func_147439_a(a, b, c);
                    if (a == x && b == y && c == z) {
                        if (block.func_149688_o() == Material.field_151579_a) continue;
                        analysis = false;
                        continue;
                    }
                    int ix = Math.abs(x - a);
                    int iy = Math.abs(y - b);
                    int iz = Math.abs(z - c);
                    if (ix <= 1 && iy <= 1 && iz <= 1) {
                        if (p.isCheckExempt && ix + iy + iz == 1 || block.func_149688_o() == Material.field_151579_a && analysis) continue;
                        analysis = false;
                        int coilVal = this.coilValue(block);
                        if (!this.isValidCoil(block)) {
                            this.expire(p, EnumHadronState.ERROR_EXPECTED_COIL);
                            continue;
                        }
                        p.charge -= coilVal;
                        totalValue += coilVal;
                        continue;
                    }
                    if (ix + iy + iz > 3 || this.isAnalysis(block)) continue;
                    analysis = false;
                    if (this.isPlating(block)) continue;
                    TileEntity te = this.field_145850_b.func_147438_o(a, b, c);
                    if (te instanceof TileEntityHadronPower) {
                        TileEntityHadronPower plug = (TileEntityHadronPower)te;
                        long bit = 10000L;
                        int times = (int)(plug.getPower() / bit);
                        p.charge += times;
                        p.plugs.add(plug);
                        continue;
                    }
                    if (p.isCheckExempt && ix + iy + iz == 2) continue;
                    this.expire(p, EnumHadronState.ERROR_MALFORMED_SEGMENT);
                }
            }
        }
        p.incrementCharge(totalValue);
        if (analysis) {
            ++p.analysis;
            if (p.analysis > 3) {
                this.expire(p, EnumHadronState.ERROR_ANALYSIS_TOO_LONG);
            }
            if (p.analysis == 2) {
                if (this.state != EnumHadronState.ANALYSIS) {
                    this.field_145850_b.func_72908_a((double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, "fireworks.blast", 2.0f, 2.0f);
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74778_a("type", "hadron");
                    PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(data, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, 25.0));
                }
                this.state = EnumHadronState.ANALYSIS;
            }
            if (this.analysisOnly && p.analysis == 2) {
                this.finishParticle(p);
            }
        } else if (p.analysis > 0 && p.analysis < 3) {
            this.expire(p, EnumHadronState.ERROR_ANALYSIS_TOO_SHORT);
        }
    }

    public void changeDirection(Particle p) {
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int nx = x + dir.offsetX;
        int ny = y + dir.offsetY;
        int nz = z + dir.offsetZ;
        Block next = this.field_145850_b.func_147439_a(nx, ny, nz);
        TileEntity te = this.field_145850_b.func_147438_o(nx, ny, nz);
        if (te instanceof TileEntityHadronDiode) {
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            if (diode.getConfig(p.dir.getOpposite().ordinal()) != TileEntityHadronDiode.DiodeConfig.IN) {
                this.expire(p, EnumHadronState.ERROR_DIODE_COLLISION);
            }
            p.isCheckExempt = true;
            return;
        }
        te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityHadronDiode) {
            p.isCheckExempt = true;
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            boolean hasTurnedCurrent = false;
            if (!p.history.containsKey(diode)) {
                p.history.put(diode, new ArrayList());
            }
            List<ForgeDirection> usedDirections = p.history.get(diode);
            for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
                if (usedDirections.contains(d) || diode.getConfig(d.ordinal()) != TileEntityHadronDiode.DiodeConfig.OUT) continue;
                if (!hasTurnedCurrent) {
                    p.dir = d;
                    hasTurnedCurrent = true;
                    continue;
                }
                Particle clone = p.clone(d);
                clone.history.get(diode).add(d);
                this.particlesToAdd.add(clone);
            }
            usedDirections.add(p.dir);
            if (!hasTurnedCurrent) {
                this.expire(p, EnumHadronState.ERROR_DIODE_COLLISION);
            }
            return;
        }
        if (next.func_149688_o() == Material.field_151579_a || next == ModBlocks.hadron_core) {
            return;
        }
        if (this.isValidCoil(next)) {
            ForgeDirection validDir = ForgeDirection.UNKNOWN;
            List<ForgeDirection> dirs = this.getRandomDirs();
            for (ForgeDirection d : dirs) {
                if (d == dir || d == dir.getOpposite() || this.field_145850_b.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ).func_149688_o() != Material.field_151579_a) continue;
                if (validDir == ForgeDirection.UNKNOWN) {
                    validDir = d;
                    continue;
                }
                this.expire(p, EnumHadronState.ERROR_BRANCHING_TURN);
                return;
            }
            p.dir = validDir;
            p.isCheckExempt = true;
            return;
        }
        this.expire(p, EnumHadronState.ERROR_OBSTRUCTED_CHANNEL);
    }

    private List<ForgeDirection> getRandomDirs() {
        List<Integer> rands = Arrays.asList(0, 1, 2, 3, 4, 5);
        Collections.shuffle(rands);
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (Integer i : rands) {
            dirs.add(ForgeDirection.getOrientation((int)i));
        }
        return dirs;
    }

    public boolean isValidCoil(Block b) {
        return this.coilValue(b) > 0;
    }

    public int coilValue(Block b) {
        if (b instanceof BlockHadronCoil) {
            return ((BlockHadronCoil)b).factor;
        }
        return 0;
    }

    public boolean isPlating(Block b) {
        return b instanceof BlockHadronPlating || b instanceof BlockHadronCoil || b == ModBlocks.hadron_plating_glass || b == ModBlocks.hadron_analysis_glass || b == ModBlocks.hadron_access;
    }

    public boolean isAnalysis(Block b) {
        return b == ModBlocks.hadron_analysis || b == ModBlocks.hadron_analysis_glass;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerHadron(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIHadron(player.field_71071_by, this);
    }

    public static enum EnumHadronState {
        IDLE(0x8080FF),
        PROGRESS(0xFFFF00),
        ANALYSIS(0xFFFF00),
        NORESULT(0xFF8000),
        NORESULT_TOO_SLOW(0xFF8000),
        NORESULT_WRONG_INGREDIENT(0xFF8000),
        NORESULT_WRONG_MODE(0xFF8000),
        SUCCESS(65280),
        ERROR_NO_CHARGE(0xFF0000, true),
        ERROR_NO_ANALYSIS(0xFF0000, true),
        ERROR_OBSTRUCTED_CHANNEL(0xFF0000, true),
        ERROR_EXPECTED_COIL(0xFF0000, true),
        ERROR_MALFORMED_SEGMENT(0xFF0000, true),
        ERROR_ANALYSIS_TOO_LONG(0xFF0000, true),
        ERROR_ANALYSIS_TOO_SHORT(0xFF0000, true),
        ERROR_DIODE_COLLISION(0xFF0000, true),
        ERROR_BRANCHING_TURN(0xFF0000, true),
        ERROR_GENERIC(0xFF0000, true);

        public int color;
        public boolean showCoord;

        private EnumHadronState(int color) {
            this(color, false);
        }

        private EnumHadronState(int color, boolean showCoord) {
            this.color = color;
            this.showCoord = showCoord;
        }
    }

    public class Particle {
        ItemStack item1;
        ItemStack item2;
        ForgeDirection dir;
        int posX;
        int posY;
        int posZ;
        int momentum;
        int charge;
        int analysis;
        boolean isCheckExempt = false;
        boolean expired = false;
        boolean cloned = false;
        List<TileEntityHadronPower> plugs = new ArrayList<TileEntityHadronPower>();
        HashMap<TileEntityHadronDiode, List<ForgeDirection>> history = new HashMap();

        public Particle(ItemStack item1, ItemStack item2, ForgeDirection dir, int posX, int posY, int posZ) {
            this.item1 = item1.func_77946_l();
            this.item2 = item2.func_77946_l();
            this.item1.field_77994_a = 1;
            this.item2.field_77994_a = 1;
            this.dir = dir;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.charge = 750;
            this.momentum = 0;
        }

        public Particle clone(ForgeDirection dir) {
            Particle p = new Particle(this.item1, this.item2, dir, this.posX, this.posY, this.posZ);
            p.momentum = this.momentum;
            p.charge = this.charge;
            p.analysis = this.analysis;
            p.isCheckExempt = this.isCheckExempt;
            p.expired = this.expired;
            p.plugs = new ArrayList<TileEntityHadronPower>(this.plugs);
            p.cloned = true;
            p.history = new HashMap<TileEntityHadronDiode, List<ForgeDirection>>(this.history);
            for (TileEntityHadronDiode diode : p.history.keySet()) {
                p.history.put(diode, new ArrayList(p.history.get(diode)));
            }
            return p;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void update() {
            if (this.expired) {
                return;
            }
            if (this.cloned) {
                this.cloned = false;
            } else {
                TileEntityHadron.this.changeDirection(this);
            }
            TileEntityHadron.this.makeSteppy(this);
            if (!this.isExpired()) {
                TileEntityHadron.this.checkSegment(this);
            }
            this.isCheckExempt = false;
            if (this.charge < 0) {
                TileEntityHadron.this.expire(this, EnumHadronState.ERROR_NO_CHARGE);
            }
        }

        public void incrementCharge(int coilVal) {
            this.momentum += coilVal;
        }

        public void consumePower() {
            for (TileEntityHadronPower plug : this.plugs) {
                long bit = 10000L;
                int times = (int)(plug.getPower() / bit);
                plug.setPower(plug.getPower() - (long)times * bit);
            }
        }
    }
}

