/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardSender;
import api.hbm.tile.IHeatSource;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.items.ItemEnums;
import com.hbm.module.ModuleBurnTime;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachinePolluting;
import com.hbm.tileentity.machine.TileEntityAshpit;
import com.hbm.util.ItemStackUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityFireboxBase
extends TileEntityMachinePolluting
implements IFluidStandardSender,
IGUIProvider,
IHeatSource {
    public int maxBurnTime;
    public int burnTime;
    public int burnHeat;
    public boolean wasOn = false;
    private int playersUsing = 0;
    public float doorAngle = 0.0f;
    public float prevDoorAngle = 0.0f;
    public int heatEnergy;
    AxisAlignedBB bb = null;

    public TileEntityFireboxBase() {
        super(2, 50);
    }

    @Override
    public void func_70295_k_() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.playersUsing;
        }
    }

    @Override
    public void func_70305_f() {
        if (!this.field_145850_b.field_72995_K) {
            --this.playersUsing;
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            boolean canOperate = false;
            for (i = 2; i < 6; ++i) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)i);
                ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
                for (int j = -1; j <= 1; ++j) {
                    this.sendSmoke(this.field_145851_c + dir.offsetX * 2 + rot.offsetX * j, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2 + rot.offsetZ * j, dir);
                }
            }
            this.wasOn = false;
            if (this.burnTime <= 0) {
                canOperate = this.breatheAir(0);
                for (i = 0; i < 2; ++i) {
                    int baseTime;
                    if (this.slots[i] == null || (baseTime = this.getModule().getBurnTime(this.slots[i])) <= 0) continue;
                    int fuel = (int)((double)baseTime * this.getTimeMult());
                    TileEntity below = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                    if (below instanceof TileEntityAshpit) {
                        TileEntityAshpit ashpit = (TileEntityAshpit)below;
                        ItemEnums.EnumAshType type = TileEntityFireboxBase.getAshFromFuel(this.slots[i]);
                        if (type == ItemEnums.EnumAshType.WOOD) {
                            ashpit.ashLevelWood += baseTime;
                        }
                        if (type == ItemEnums.EnumAshType.COAL) {
                            ashpit.ashLevelCoal += baseTime;
                        }
                        if (type == ItemEnums.EnumAshType.MISC) {
                            ashpit.ashLevelMisc += baseTime;
                        }
                    }
                    this.maxBurnTime = this.burnTime = fuel;
                    this.burnHeat = this.getModule().getBurnHeat(this.getBaseHeat(), this.slots[i]);
                    --this.slots[i].field_77994_a;
                    if (this.slots[i].field_77994_a == 0) {
                        this.slots[i] = this.slots[i].func_77973_b().getContainerItem(this.slots[i]);
                    }
                    this.wasOn = true;
                    break;
                }
            } else {
                if (this.heatEnergy < this.getMaxHeat()) {
                    canOperate = this.breatheAir(this.field_145850_b.func_82737_E() % (long)(500 / this.getBaseHeat()) == 0L ? 1 : 0);
                    if (canOperate) {
                        --this.burnTime;
                        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                            this.pollute(PollutionHandler.PollutionType.SOOT, 0.12f);
                        }
                    }
                } else {
                    canOperate = this.breatheAir(0);
                }
                if (canOperate) {
                    this.wasOn = true;
                    if (this.field_145850_b.field_73012_v.nextInt(15) == 0 && !this.muffled) {
                        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fire.fire", 1.0f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f);
                    }
                }
            }
            if (this.wasOn) {
                this.heatEnergy = Math.min(this.heatEnergy + this.burnHeat, this.getMaxHeat());
            } else {
                this.heatEnergy = Math.max(this.heatEnergy - Math.max(this.heatEnergy / 1000, 1), 0);
                if (canOperate) {
                    this.burnHeat = 0;
                }
            }
            this.networkPackNT(50);
        } else {
            this.prevDoorAngle = this.doorAngle;
            float swingSpeed = this.doorAngle / 10.0f + 3.0f;
            this.doorAngle = this.playersUsing > 0 ? (this.doorAngle += swingSpeed) : (this.doorAngle -= swingSpeed);
            this.doorAngle = MathHelper.func_76131_a((float)this.doorAngle, (float)0.0f, (float)135.0f);
            if (this.wasOn && this.field_145850_b.func_82737_E() % 5L == 0L) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                double x = (double)this.field_145851_c + 0.5 + (double)dir.offsetX;
                double y = (double)this.field_145848_d + 0.25;
                double z = (double)this.field_145849_e + 0.5 + (double)dir.offsetZ;
                this.field_145850_b.func_72869_a("flame", x + this.field_145850_b.field_73012_v.nextDouble() * 0.5 - 0.25, y + this.field_145850_b.field_73012_v.nextDouble() * 0.25, z + this.field_145850_b.field_73012_v.nextDouble() * 0.5 - 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeInt(this.maxBurnTime);
        buf.writeInt(this.burnTime);
        buf.writeInt(this.burnHeat);
        buf.writeInt(this.heatEnergy);
        buf.writeInt(this.playersUsing);
        buf.writeBoolean(this.wasOn);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.maxBurnTime = buf.readInt();
        this.burnTime = buf.readInt();
        this.burnHeat = buf.readInt();
        this.heatEnergy = buf.readInt();
        this.playersUsing = buf.readInt();
        this.wasOn = buf.readBoolean();
    }

    public static ItemEnums.EnumAshType getAshFromFuel(ItemStack stack) {
        List<String> names = ItemStackUtil.getOreDictNames(stack);
        for (String name : names) {
            if (name.contains("Coke")) {
                return ItemEnums.EnumAshType.COAL;
            }
            if (name.contains("Coal")) {
                return ItemEnums.EnumAshType.COAL;
            }
            if (name.contains("Lignite")) {
                return ItemEnums.EnumAshType.COAL;
            }
            if (name.startsWith("log")) {
                return ItemEnums.EnumAshType.WOOD;
            }
            if (name.contains("Wood")) {
                return ItemEnums.EnumAshType.WOOD;
            }
            if (!name.contains("Sapling")) continue;
            return ItemEnums.EnumAshType.WOOD;
        }
        return ItemEnums.EnumAshType.MISC;
    }

    public abstract ModuleBurnTime getModule();

    public abstract int getBaseHeat();

    public abstract double getTimeMult();

    public abstract int getMaxHeat();

    @Override
    public int[] func_94128_d(int meta) {
        return new int[]{0, 1};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return this.getModule().getBurnTime(itemStack) > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.maxBurnTime = nbt.func_74762_e("maxBurnTime");
        this.burnTime = nbt.func_74762_e("burnTime");
        this.burnHeat = nbt.func_74762_e("burnHeat");
        this.heatEnergy = nbt.func_74762_e("heatEnergy");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("maxBurnTime", this.maxBurnTime);
        nbt.func_74768_a("burnTime", this.burnTime);
        nbt.func_74768_a("burnHeat", this.burnHeat);
        nbt.func_74768_a("heatEnergy", this.heatEnergy);
    }

    @Override
    public int getHeatStored() {
        return this.heatEnergy;
    }

    @Override
    public void useUpHeat(int heat) {
        this.heatEnergy = Math.max(0, this.heatEnergy - heat);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[0];
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return this.getSmokeTanks();
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return dir != ForgeDirection.UNKNOWN && dir != ForgeDirection.DOWN;
    }
}

