/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineStardar;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityMachineStardar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityDishControl
extends TileEntityMachineBase {
    private TileEntityMachineStardar dish;
    public int[] linkPosition = new int[3];
    public boolean isLinked;
    private boolean foundLink = false;
    AxisAlignedBB bb = null;

    public TileEntityDishControl() {
        super(0);
    }

    @Override
    public String getName() {
        return "container.dishControl";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isLinked = nbt.func_74767_n("isLinked");
        this.linkPosition[0] = nbt.func_74762_e("linkPosX");
        this.linkPosition[1] = nbt.func_74762_e("linkPosY");
        this.linkPosition[2] = nbt.func_74762_e("linkPosZ");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isLinked", this.isLinked);
        if (this.linkPosition[0] != 0 || this.linkPosition[1] != 0 || this.linkPosition[2] != 0) {
            nbt.func_74768_a("linkPosX", this.linkPosition[0]);
            nbt.func_74768_a("linkPosY", this.linkPosition[1]);
            nbt.func_74768_a("linkPosZ", this.linkPosition[2]);
        }
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.foundLink && this.isLinked) {
            this.isLinked = this.establishLink(this.linkPosition[0], this.linkPosition[1], this.linkPosition[2]);
            this.foundLink = true;
        }
        this.networkPackNT(15);
    }

    @SideOnly(value=Side.CLIENT)
    public TileEntityMachineStardar getLinkedDishClientSafe() {
        TileEntity te;
        if (this.dish == null && this.isLinked && (te = this.field_145850_b.func_147438_o(this.linkPosition[0], this.linkPosition[1], this.linkPosition[2])) instanceof TileEntityMachineStardar) {
            this.dish = (TileEntityMachineStardar)te;
        }
        return this.dish;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean starDarHasDisk() {
        TileEntityMachineStardar link = this.getLinkedDishClientSafe();
        return link != null && link.slots[0] != null;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.isLinked);
        buf.writeInt(this.linkPosition[0]);
        buf.writeInt(this.linkPosition[1]);
        buf.writeInt(this.linkPosition[2]);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.isLinked = buf.readBoolean();
        this.linkPosition[0] = buf.readInt();
        this.linkPosition[1] = buf.readInt();
        this.linkPosition[2] = buf.readInt();
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void TryLink(ItemStack stack) {
        this.isLinked = this.linkWithSensor(stack);
    }

    private boolean linkWithSensor(ItemStack stack) {
        if (stack.func_77973_b() != null && stack.field_77990_d != null) {
            int x = stack.field_77990_d.func_74762_e("x");
            int y = stack.field_77990_d.func_74762_e("y");
            int z = stack.field_77990_d.func_74762_e("z");
            return this.establishLink(x, y, z);
        }
        return false;
    }

    private boolean establishLink(int x, int y, int z) {
        TileEntity tile;
        int[] pos;
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b == ModBlocks.machine_stardar && (pos = ((MachineStardar)ModBlocks.machine_stardar).findCore(this.field_145850_b, x, y, z)) != null && (tile = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityMachineStardar) {
            this.linkPosition = pos;
            return true;
        }
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }
}

