/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluidmk2.IFluidReceiverMK2;
import com.hbm.handler.pollution.PollutionHandler;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.IBufPacketReceiver;
import com.hbm.tileentity.TileEntityLoadedBase;
import com.hbm.tileentity.machine.TileEntityAshpit;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileEntityChimneyBase
extends TileEntityLoadedBase
implements IFluidReceiverMK2,
IBufPacketReceiver {
    public long ashTick = 0L;
    public long sootTick = 0L;
    public int onTicks;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                FluidType[] types;
                for (FluidType type : types = new FluidType[]{Fluids.SMOKE, Fluids.SMOKE_LEADED, Fluids.SMOKE_POISON}) {
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, Library.POS_X);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, Library.NEG_X);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, Library.POS_Z);
                    this.trySubscribe(type, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, Library.NEG_Z);
                }
            }
            if (this.ashTick > 0L || this.sootTick > 0L) {
                TileEntity below = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
                if (below instanceof TileEntityAshpit) {
                    TileEntityAshpit ashpit = (TileEntityAshpit)below;
                    ashpit.ashLevelFly = (int)((long)ashpit.ashLevelFly + this.ashTick);
                    ashpit.ashLevelSoot = (int)((long)ashpit.ashLevelSoot + this.sootTick);
                }
                this.ashTick = 0L;
                this.sootTick = 0L;
            }
            this.networkPackNT(150);
            if (this.onTicks > 0) {
                --this.onTicks;
            }
        } else if (this.onTicks > 0) {
            this.spawnParticles();
        }
    }

    public boolean cpaturesAsh() {
        return true;
    }

    public boolean cpaturesSoot() {
        return false;
    }

    public void spawnParticles() {
    }

    @Override
    public void serialize(ByteBuf buf) {
        buf.writeInt(this.onTicks);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        this.onTicks = buf.readInt();
    }

    @Override
    public boolean canConnect(FluidType type, ForgeDirection dir) {
        return !(dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH && dir != ForgeDirection.EAST && dir != ForgeDirection.WEST || type != Fluids.SMOKE && type != Fluids.SMOKE_LEADED && type != Fluids.SMOKE_POISON);
    }

    @Override
    public long transferFluid(FluidType type, int pressure, long fluid) {
        if (type != Fluids.SMOKE && type != Fluids.SMOKE_LEADED && type != Fluids.SMOKE_POISON) {
            return fluid;
        }
        this.onTicks = 20;
        if (this.cpaturesAsh()) {
            this.ashTick += fluid;
        }
        if (this.cpaturesSoot()) {
            this.sootTick += fluid;
        }
        fluid = (long)((double)fluid * this.getPollutionMod());
        if (type == Fluids.SMOKE) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.SOOT, (float)fluid / 100.0f);
        }
        if (type == Fluids.SMOKE_LEADED) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.HEAVYMETAL, (float)fluid / 100.0f);
        }
        if (type == Fluids.SMOKE_POISON) {
            PollutionHandler.incrementPollution(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, PollutionHandler.PollutionType.POISON, (float)fluid / 100.0f);
        }
        return 0L;
    }

    public abstract double getPollutionMod();

    @Override
    public long getDemand(FluidType type, int pressure) {
        return 1000000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return new FluidTank[0];
    }
}

