/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.fluid.IFluidStandardTransceiver;
import com.hbm.dim.orbit.WorldProviderOrbit;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.tileentity.TileEntityMachineBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityAlgaeFilm
extends TileEntityMachineBase
implements IFluidStandardTransceiver {
    public FluidTank[] tanks = new FluidTank[2];
    public boolean canOperate;

    public TileEntityAlgaeFilm() {
        super(0);
        this.tanks[0] = new FluidTank(Fluids.CARBONDIOXIDE, 8000);
        this.tanks[1] = new FluidTank(Fluids.OXYGEN, 8000);
    }

    @Override
    public String getName() {
        return "container.algaeFilm";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ForgeDirection[] dirs;
            this.canOperate = this.field_145850_b.field_73011_w instanceof WorldProviderOrbit;
            if (this.canOperate && this.field_145850_b.field_73012_v.nextBoolean() && this.tanks[0].getFill() > 0 && this.tanks[1].getFill() < this.tanks[1].getMaxFill()) {
                this.tanks[0].setFill(this.tanks[0].getFill() - 1);
                this.tanks[1].setFill(this.tanks[1].getFill() + 1);
            }
            ForgeDirection d = ForgeDirection.getOrientation((int)this.func_145832_p()).getRotation(ForgeDirection.UP);
            for (ForgeDirection dir : dirs = new ForgeDirection[]{d, d.getOpposite()}) {
                this.trySubscribe(this.tanks[0].getTankType(), this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                this.sendFluid(this.tanks[1], this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
            }
            this.networkPackNT(20);
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.canOperate);
        for (FluidTank tank : this.tanks) {
            tank.serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.canOperate = buf.readBoolean();
        for (FluidTank tank : this.tanks) {
            tank.deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getSendingTanks() {
        return new FluidTank[]{this.tanks[1]};
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return new FluidTank[]{this.tanks[0]};
    }
}

