/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.item.IDesignatorItem;
import com.hbm.entity.missile.EntityMissileBaseNT;
import com.hbm.entity.missile.EntityMissileTier4;
import com.hbm.interfaces.IBomb;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerLaunchPadRusted;
import com.hbm.inventory.gui.GUILaunchPadRusted;
import com.hbm.items.ModItems;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.TrackerUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityLaunchPadRusted
extends TileEntityMachineBase
implements IGUIProvider,
IControlReceiver {
    public int prevRedstonePower;
    public int redstonePower;
    public Set<BlockPos> activatedBlocks = new HashSet<BlockPos>(4);
    public boolean missileLoaded;
    AxisAlignedBB bb = null;

    public TileEntityLaunchPadRusted() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.launchPadRusted";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.redstonePower > 0 && this.prevRedstonePower <= 0) {
                this.launch();
            }
            this.prevRedstonePower = this.redstonePower;
            this.networkPackNT(250);
        } else {
            List entities = this.field_145850_b.func_72872_a(EntityMissileBaseNT.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 10), (double)((double)this.field_145849_e + 1.5)));
            if (!entities.isEmpty()) {
                for (int i = 0; i < 15; ++i) {
                    ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        dir = dir.getOpposite();
                    }
                    if (this.field_145850_b.field_73012_v.nextBoolean()) {
                        dir = dir.getRotation(ForgeDirection.UP);
                    }
                    float moX = (float)(this.field_145850_b.field_73012_v.nextGaussian() * (double)0.15f + 0.75) * (float)dir.offsetX;
                    float moZ = (float)(this.field_145850_b.field_73012_v.nextGaussian() * (double)0.15f + 0.75) * (float)dir.offsetZ;
                    NBTTagCompound data = new NBTTagCompound();
                    data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
                    data.func_74780_a("posY", (double)this.field_145848_d + 0.25);
                    data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
                    data.func_74778_a("type", "launchSmoke");
                    data.func_74780_a("moX", (double)moX);
                    data.func_74780_a("moY", 0.0);
                    data.func_74780_a("moZ", (double)moZ);
                    MainRegistry.proxy.effectNT(data);
                }
            }
        }
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeBoolean(this.missileLoaded);
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.missileLoaded = buf.readBoolean();
    }

    public IBomb.BombReturnCode launch() {
        if (this.slots[1] != null && this.slots[2] != null && this.slots[3] != null && this.missileLoaded && this.slots[1].func_77973_b() == ModItems.launch_code && this.slots[2].func_77973_b() == ModItems.launch_key && this.slots[3] != null && this.slots[3].func_77973_b() instanceof IDesignatorItem) {
            IDesignatorItem designator = (IDesignatorItem)this.slots[3].func_77973_b();
            if (!designator.isReady(this.field_145850_b, this.slots[3], this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
            }
            Vec3 coords = designator.getCoords(this.field_145850_b, this.slots[3], this.field_145851_c, this.field_145848_d, this.field_145849_e);
            int targetX = (int)Math.floor(coords.field_72450_a);
            int targetZ = (int)Math.floor(coords.field_72449_c);
            EntityMissileTier4.EntityMissileDoomsdayRusted missile = new EntityMissileTier4.EntityMissileDoomsdayRusted(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 1.0f, (float)this.field_145849_e + 0.5f, targetX, targetZ);
            this.field_145850_b.func_72838_d((Entity)missile);
            TrackerUtil.setTrackingRange(this.field_145850_b, missile, 500);
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d, (double)this.field_145849_e + 0.5, "hbm:weapon.missileTakeOff", 2.0f, 1.0f);
            this.missileLoaded = false;
            this.func_70298_a(1, 1);
            this.func_70296_d();
            return IBomb.BombReturnCode.LAUNCHED;
        }
        return IBomb.BombReturnCode.ERROR_MISSING_COMPONENT;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.missileLoaded = nbt.func_74767_n("missileLoaded");
        this.redstonePower = nbt.func_74762_e("redstonePower");
        this.prevRedstonePower = nbt.func_74762_e("prevRedstonePower");
        NBTTagCompound activatedBlocks = nbt.func_74775_l("activatedBlocks");
        this.activatedBlocks.clear();
        for (int i = 0; i < activatedBlocks.func_150296_c().size() / 3; ++i) {
            this.activatedBlocks.add(new BlockPos(activatedBlocks.func_74762_e("x" + i), activatedBlocks.func_74762_e("y" + i), activatedBlocks.func_74762_e("z" + i)));
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("missileLoaded", this.missileLoaded);
        nbt.func_74768_a("redstonePower", this.redstonePower);
        nbt.func_74768_a("prevRedstonePower", this.prevRedstonePower);
        NBTTagCompound activatedBlocks = new NBTTagCompound();
        int i = 0;
        for (BlockPos p : this.activatedBlocks) {
            activatedBlocks.func_74768_a("x" + i, p.getX());
            activatedBlocks.func_74768_a("y" + i, p.getY());
            activatedBlocks.func_74768_a("z" + i, p.getZ());
            ++i;
        }
        nbt.func_74782_a("activatedBlocks", (NBTBase)activatedBlocks);
    }

    public void updateRedstonePower(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        boolean powered = this.field_145850_b.func_72864_z(x, y, z);
        boolean contained = this.activatedBlocks.contains(pos);
        if (!contained && powered) {
            this.activatedBlocks.add(pos);
            if (this.redstonePower == -1) {
                this.redstonePower = 0;
            }
            ++this.redstonePower;
        } else if (contained && !powered) {
            this.activatedBlocks.remove(pos);
            --this.redstonePower;
            if (this.redstonePower == 0) {
                this.redstonePower = -1;
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 15), (double)(this.field_145849_e + 3));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerLaunchPadRusted(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUILaunchPadRusted(player.field_71071_by, this);
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("release") && this.missileLoaded && this.slots[0] == null) {
            this.missileLoaded = false;
            this.slots[0] = new ItemStack(ModItems.missile_doomsday_rusted);
            this.func_70296_d();
        }
    }
}

