/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.bomb;

import api.hbm.energymk2.IBatteryItem;
import api.hbm.energymk2.IEnergyReceiverMK2;
import api.hbm.fluid.IFluidStandardReceiver;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ModBlocks;
import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.entity.missile.EntityRideableRocket;
import com.hbm.extprop.HbmPlayerProps;
import com.hbm.handler.CompatHandler;
import com.hbm.handler.RocketStruct;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.inventory.container.ContainerLaunchPadRocket;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.inventory.gui.GUILaunchPadRocket;
import com.hbm.items.ItemVOTVdrive;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.ItemCustomRocket;
import com.hbm.lib.Library;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.util.fauxpointtwelve.DirPos;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="OpenComputers")})
public class TileEntityLaunchPadRocket
extends TileEntityMachineBase
implements IControlReceiver,
IEnergyReceiverMK2,
IFluidStandardReceiver,
IGUIProvider,
SimpleComponent,
CompatHandler.OCComponent {
    public long power;
    public final long maxPower = 100000L;
    public int solidFuel = 0;
    public int maxSolidFuel = 0;
    public FluidTank[] tanks = new FluidTank[10];
    public boolean canSeeSky = true;
    public RocketStruct rocket;
    public int height;
    private DirPos[] conPos;

    public TileEntityLaunchPadRocket() {
        super(5);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, 64000);
        }
    }

    @Override
    public String getName() {
        return "container.launchPadRocket";
    }

    @Override
    public void func_145845_h() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        if (!this.field_145850_b.field_72995_K) {
            ItemVOTVdrive.getTarget(this.slots[1], this.field_145850_b);
            this.updateTanks();
            if (this.field_145850_b.func_82737_E() % 20L == 0L) {
                for (DirPos dirPos : this.getConPos()) {
                    this.trySubscribe(this.field_145850_b, dirPos.getX(), dirPos.getY(), dirPos.getZ(), dirPos.getDir());
                    if (!this.hasRocket()) continue;
                    for (FluidTank tank : this.tanks) {
                        if (tank.getTankType() == Fluids.NONE) continue;
                        this.trySubscribe(tank.getTankType(), this.field_145850_b, dirPos.getX(), dirPos.getY(), dirPos.getZ(), dirPos.getDir());
                    }
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, 100000L);
            for (Cloneable cloneable : this.tanks) {
                ((FluidTank)cloneable).loadTank(3, 4, this.slots);
            }
            if (this.slots[3] != null && this.slots[3].func_77973_b() == ModItems.rocket_fuel && this.solidFuel < this.maxSolidFuel) {
                this.func_70298_a(3, 1);
                this.solidFuel += 250;
                if (this.solidFuel > this.maxSolidFuel) {
                    this.solidFuel = this.maxSolidFuel;
                }
            }
            this.rocket = ItemCustomRocket.get(this.slots[0]);
            if (this.rocket != null) {
                int newHeight = MathHelper.func_76128_c((double)(this.rocket.getHeight() - this.rocket.capsule.height + 1.0));
                if (newHeight <= 8) {
                    newHeight = 0;
                }
                if (newHeight != this.height) {
                    boolean bl = this.canSeeSky = !this.isPadObstructed();
                    if (this.canSeeSky) {
                        int oy;
                        BlockDummyable.safeRem = true;
                        int meta = ForgeDirection.UP.ordinal();
                        if (newHeight > this.height) {
                            for (oy = this.height + 3; oy < newHeight + 3 && this.field_145848_d + oy <= 255; ++oy) {
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 5, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 5, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 3 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 3 - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 4 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 4 - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 3 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 3 - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, meta, 3);
                                this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 4 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 4 - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, meta, 3);
                            }
                        } else {
                            for (oy = this.height + 3; oy >= newHeight + 3; --oy) {
                                if (this.field_145848_d + oy > 255) continue;
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 4);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 5, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 5);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 6);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 3 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 3 - dir.offsetZ * 4);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 4 - dir.offsetX * 4, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 4 - dir.offsetZ * 4);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 3 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 3 - dir.offsetZ * 6);
                                this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 4 - dir.offsetX * 6, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * 4 - dir.offsetZ * 6);
                            }
                        }
                        if (this.height >= 8) {
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 3, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 3);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 1, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 1);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 2, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 2);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 3);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 4, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 4);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 5, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 5);
                            this.field_145850_b.func_147468_f(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 6, this.field_145848_d + this.height + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 6);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 1, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 1);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 2, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 2);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 3, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 3);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 4, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 4);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 5, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 5);
                            this.field_145850_b.func_147468_f(this.field_145851_c - dir.offsetX * 6, this.field_145848_d + this.height + 2, this.field_145849_e - dir.offsetZ * 6);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 1, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 1);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 2, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 2);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 3);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 4, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 4);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 5, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 5);
                            this.field_145850_b.func_147468_f(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 6, this.field_145848_d + this.height + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 6);
                        }
                        if (newHeight >= 8) {
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 2 - dir.offsetX * 3, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 2 - dir.offsetZ * 3, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 1, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 1, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 2, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 2, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 3, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 4, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 5, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 5, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - rot.offsetX * 1 - dir.offsetX * 6, this.field_145848_d + newHeight + 2, this.field_145849_e - rot.offsetZ * 1 - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 1, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 1, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 2, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 2, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 3, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 3, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 4, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 5, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 5, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c - dir.offsetX * 6, this.field_145848_d + newHeight + 2, this.field_145849_e - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 1, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 1, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 2, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 2, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 3, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 3, ModBlocks.launch_pad_rocket, dir.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 4, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 4, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 5, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 5, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                            this.field_145850_b.func_147465_d(this.field_145851_c + rot.offsetX * 1 - dir.offsetX * 6, this.field_145848_d + newHeight + 2, this.field_145849_e + rot.offsetZ * 1 - dir.offsetZ * 6, ModBlocks.launch_pad_rocket, rot.ordinal(), 3);
                        }
                        BlockDummyable.safeRem = false;
                    }
                    this.height = newHeight;
                }
            }
            this.networkPackNT(250);
        }
        List sideLadderPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.25), (double)this.field_145848_d, (double)((double)this.field_145849_e + 0.25), (double)((double)this.field_145851_c + 0.75), (double)(this.field_145848_d + 3), (double)((double)this.field_145849_e + 0.75)).func_72317_d((double)(-rot.offsetX) * 6.5 - (double)(dir.offsetX * 5), 0.0, (double)(-rot.offsetZ) * 6.5 - (double)(dir.offsetZ * 5)));
        for (EntityPlayer player : sideLadderPlayers) {
            HbmPlayerProps.getData((EntityPlayer)player).isOnLadder = true;
        }
        if (this.height >= 8) {
            List mainLadderPlayers = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.25), (double)(this.field_145848_d + 3), (double)((double)this.field_145849_e + 0.25), (double)((double)this.field_145851_c + 0.75), (double)(this.field_145848_d + 3 + this.height), (double)((double)this.field_145849_e + 0.75)).func_72317_d((double)(-rot.offsetX) * 2.5 - (double)(dir.offsetX * 5), 0.0, (double)(-rot.offsetZ) * 2.5 - (double)(dir.offsetZ * 5)));
            for (EntityPlayer entityPlayer : mainLadderPlayers) {
                HbmPlayerProps.getData((EntityPlayer)entityPlayer).isOnLadder = true;
            }
        }
    }

    private boolean isPadObstructed() {
        for (int ox = 0; ox <= 0; ++ox) {
            for (int oz = 0; oz <= 0; ++oz) {
                if (this.field_145850_b.func_72937_j(this.field_145851_c + ox, this.field_145848_d + 2, this.field_145849_e + oz)) continue;
                return true;
            }
        }
        return false;
    }

    public DirPos[] getConPos() {
        if (this.conPos == null) {
            this.conPos = new DirPos[13];
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
            ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
            int i = 0;
            for (int or = 1; or < 5; ++or) {
                for (int oy = 0; oy < 3; ++oy) {
                    this.conPos[i++] = new DirPos(this.field_145851_c - rot.offsetX * or - dir.offsetX * 8, this.field_145848_d + oy, this.field_145849_e - rot.offsetZ * or - dir.offsetZ * 8, dir.getOpposite());
                }
            }
            this.conPos[i++] = new DirPos(this.field_145851_c + rot.offsetX * 3 - dir.offsetX * 8, this.field_145848_d, this.field_145849_e + rot.offsetZ * 3 - dir.offsetZ * 8, dir.getOpposite());
        }
        return this.conPos;
    }

    public void launch(EntityPlayer player) {
        if (!this.canLaunch()) {
            return;
        }
        EntityRideableRocket rocket = new EntityRideableRocket(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 3.0f, (float)this.field_145849_e + 0.5f, this.slots[0]).withProgram(this.slots[1]).launchedBy((EntityLivingBase)player);
        this.field_145850_b.func_72838_d((Entity)rocket);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i] = new FluidTank(Fluids.NONE, 64000);
        }
        this.maxSolidFuel = 0;
        this.solidFuel = 0;
        this.power = (long)((double)this.power - 75000.0);
        this.slots[0] = null;
        this.slots[1] = null;
    }

    private boolean hasRocket() {
        return ItemCustomRocket.get(this.slots[0]) != null;
    }

    private boolean hasDrive() {
        return this.slots[1] != null && this.slots[1].func_77973_b() instanceof ItemVOTVdrive;
    }

    private boolean areTanksFull() {
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() == Fluids.NONE || tank.getFill() >= tank.getMaxFill()) continue;
            return false;
        }
        return this.solidFuel >= this.maxSolidFuel;
    }

    private boolean canReachDestination() {
        if (!ItemVOTVdrive.getProcessed(this.slots[1])) {
            return false;
        }
        SolarSystem.Body target = ItemVOTVdrive.getDestination((ItemStack)this.slots[1]).body;
        if (target == SolarSystem.Body.ORBIT && this.rocket.capsule.part != ModItems.rp_capsule_20 && this.rocket.capsule.part != ModItems.rp_station_core_20) {
            return false;
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = ItemVOTVdrive.getTarget(this.slots[1], this.field_145850_b);
        RocketStruct rocket = ItemCustomRocket.get(this.slots[0]);
        if (!to.isValid && rocket.capsule.part != ModItems.rp_station_core_20) {
            return false;
        }
        if (to.isValid && rocket.capsule.part == ModItems.rp_station_core_20) {
            return false;
        }
        return rocket.hasSufficientFuel(from.body, to.body, from.inOrbit, to.inOrbit);
    }

    public boolean canLaunch() {
        return this.hasRocket() && this.hasDrive() && (double)this.power >= 75000.0 && this.areTanksFull() && this.canReachDestination();
    }

    private void updateTanks() {
        if (!this.hasRocket()) {
            return;
        }
        RocketStruct rocket = ItemCustomRocket.get(this.slots[0]);
        Map<FluidType, Integer> fuels = rocket.getFillRequirement();
        boolean hasFuel = ItemCustomRocket.hasFuel(this.slots[0]);
        if (hasFuel) {
            ItemCustomRocket.setFuel(this.slots[0], false);
        }
        if (fuels.containsKey(Fluids.NONE)) {
            this.maxSolidFuel = fuels.get(Fluids.NONE);
            if (hasFuel) {
                this.solidFuel = this.maxSolidFuel;
            }
            fuels.remove(Fluids.NONE);
        } else {
            this.maxSolidFuel = 0;
        }
        ArrayList<FluidTank> keepTanks = new ArrayList<FluidTank>();
        for (FluidTank tank : this.tanks) {
            if (!fuels.containsKey(tank.getTankType())) continue;
            tank.changeTankSize(fuels.get(tank.getTankType()));
            keepTanks.add(tank);
            fuels.remove(tank.getTankType());
        }
        for (Map.Entry entry : fuels.entrySet()) {
            keepTanks.add(new FluidTank((FluidType)entry.getKey(), (Integer)entry.getValue()));
        }
        if (hasFuel) {
            for (FluidTank fluidTank : keepTanks) {
                fluidTank.setFill(fluidTank.getMaxFill());
            }
        }
        keepTanks.sort((a, b) -> b.getTankType().getID() - a.getTankType().getID());
        while (keepTanks.size() < 10) {
            keepTanks.add(new FluidTank(Fluids.NONE, 64000));
        }
        this.tanks = keepTanks.toArray(new FluidTank[10]);
    }

    public List<String> findIssues() {
        ArrayList<String> issues = new ArrayList<String>();
        if (!this.hasRocket()) {
            return issues;
        }
        RocketStruct rocket = ItemCustomRocket.get(this.slots[0]);
        if (!this.canSeeSky) {
            issues.add(EnumChatFormatting.RED + "Pad is obstructed");
        }
        if ((double)this.power < 75000.0) {
            issues.add(EnumChatFormatting.RED + "Insufficient power");
        }
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() == Fluids.NONE) continue;
            int fill = tank.getFill();
            int maxFill = tank.getMaxFill();
            String tankName = tank.getTankType().getLocalizedName();
            if (tankName.contains(" ")) {
                String[] split = tankName.split(" ");
                tankName = split[split.length - 1];
            }
            if (fill < maxFill) {
                issues.add(EnumChatFormatting.YELLOW + "" + fill + "/" + maxFill + "mB " + tankName);
                continue;
            }
            issues.add(EnumChatFormatting.GREEN + "" + fill + "/" + maxFill + "mB " + tankName);
        }
        if (this.maxSolidFuel > 0) {
            if (this.solidFuel < this.maxSolidFuel) {
                issues.add(EnumChatFormatting.YELLOW + "" + this.solidFuel + "/" + this.maxSolidFuel + "kg Solid Fuel");
            } else {
                issues.add(EnumChatFormatting.GREEN + "" + this.solidFuel + "/" + this.maxSolidFuel + "kg Solid Fuel");
            }
        }
        if (!this.hasDrive()) {
            issues.add(EnumChatFormatting.YELLOW + "No destination drive installed");
            return issues;
        }
        if (!ItemVOTVdrive.getProcessed(this.slots[1])) {
            issues.add(EnumChatFormatting.RED + "Destination drive needs processing");
            return issues;
        }
        SolarSystem.Body target = ItemVOTVdrive.getDestination((ItemStack)this.slots[1]).body;
        if (target == SolarSystem.Body.ORBIT && rocket.capsule.part != ModItems.rp_capsule_20 && rocket.capsule.part != ModItems.rp_station_core_20) {
            issues.add(EnumChatFormatting.RED + "Satellite target must be a planet");
            return issues;
        }
        ItemVOTVdrive.Target from = CelestialBody.getTarget(this.field_145850_b, this.field_145851_c, this.field_145849_e);
        ItemVOTVdrive.Target to = ItemVOTVdrive.getTarget(this.slots[1], this.field_145850_b);
        if (to.inOrbit && !to.isValid && rocket.capsule.part != ModItems.rp_station_core_20) {
            issues.add(EnumChatFormatting.RED + "Station not yet launched");
        }
        if (to.inOrbit && to.isValid && rocket.capsule.part == ModItems.rp_station_core_20) {
            issues.add(EnumChatFormatting.RED + "Station already launched");
        }
        if (!rocket.hasSufficientFuel(from.body, to.body, from.inOrbit, to.inOrbit)) {
            issues.add(EnumChatFormatting.RED + "Rocket can't reach destination");
        }
        return issues;
    }

    @Override
    public boolean func_94041_b(int index, ItemStack stack) {
        if (stack == null) {
            return true;
        }
        if (index == 0 && !(stack.func_77973_b() instanceof ItemCustomRocket)) {
            return false;
        }
        if (index == 1 && !(stack.func_77973_b() instanceof ItemVOTVdrive)) {
            return false;
        }
        return index != 2 || stack.func_77973_b() instanceof IBatteryItem || stack.func_77973_b() == ModItems.battery_creative;
    }

    @Override
    public void serialize(ByteBuf buf) {
        super.serialize(buf);
        buf.writeLong(this.power);
        buf.writeInt(this.solidFuel);
        buf.writeInt(this.maxSolidFuel);
        buf.writeInt(this.height);
        buf.writeBoolean(this.canSeeSky);
        if (this.rocket != null) {
            buf.writeBoolean(true);
            this.rocket.writeToByteBuffer(buf);
        } else {
            buf.writeBoolean(false);
        }
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].serialize(buf);
        }
    }

    @Override
    public void deserialize(ByteBuf buf) {
        super.deserialize(buf);
        this.power = buf.readLong();
        this.solidFuel = buf.readInt();
        this.maxSolidFuel = buf.readInt();
        this.height = buf.readInt();
        this.canSeeSky = buf.readBoolean();
        this.rocket = buf.readBoolean() ? RocketStruct.readFromByteBuffer(buf) : null;
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].deserialize(buf);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("solid", this.solidFuel);
        nbt.func_74768_a("maxSolid", this.maxSolidFuel);
        nbt.func_74768_a("height", this.height);
        nbt.func_74757_a("sky", this.canSeeSky);
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].writeToNBT(nbt, "t" + i);
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.solidFuel = nbt.func_74762_e("solid");
        this.maxSolidFuel = nbt.func_74762_e("maxSolid");
        this.height = nbt.func_74762_e("height");
        this.canSeeSky = nbt.func_74767_n("sky");
        for (int i = 0; i < this.tanks.length; ++i) {
            this.tanks[i].readFromNBT(nbt, "t" + i);
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
    }

    @Override
    public void receiveControl(EntityPlayer player, NBTTagCompound data) {
        if (data.func_74767_n("launch")) {
            this.launch(player);
        }
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String getComponentName() {
        return "ntm_rocket_pad";
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        return new Object[]{this.getPower(), this.getMaxPower()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getFuel(Context context, Arguments args) {
        ArrayList<Object[]> returnValues = new ArrayList<Object[]>();
        for (FluidTank tank : this.tanks) {
            if (tank.getTankType() == Fluids.NONE) continue;
            returnValues.add(new Object[]{tank.getFill(), tank.getMaxFill(), tank.getTankType().getName()});
        }
        return returnValues.toArray();
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getSolidFuel(Context context, Arguments args) {
        return new Object[]{this.solidFuel, this.maxSolidFuel};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] canLaunch(Context context, Arguments args) {
        return new Object[]{this.canLaunch()};
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getRocketStats(Context context, Arguments args) {
        if (this.hasRocket()) {
            return new Object[]{this.rocket.stages.size(), this.rocket.getLaunchMass(), this.rocket.getHeight()};
        }
        return new Object[]{null, ""};
    }

    @Callback(direct=true, limit=4)
    @Optional.Method(modid="OpenComputers")
    public Object[] launch(Context context, Arguments args) {
        this.launch(null);
        return new Object[0];
    }

    @Callback(direct=true)
    @Optional.Method(modid="OpenComputers")
    public Object[] getDestination(Context context, Arguments args) {
        if (this.hasDrive()) {
            return new Object[]{null, "No destination drive."};
        }
        ItemVOTVdrive.Target target = ItemVOTVdrive.getTarget(this.slots[1], null);
        if (target.body != null) {
            return new Object[]{target.body.name.toLowerCase()};
        }
        return new Object[]{null, "Drive has no destination."};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public boolean canConnectNode(ForgeDirection side) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        return side == dir;
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public String[] methods() {
        return new String[]{"getEnergyInfo", "getFuel", "getSolidFuel", "canLaunch", "getRocketStats", "getDestination", "launch"};
    }

    @Override
    @Optional.Method(modid="OpenComputers")
    public Object[] invoke(String method, Context context, Arguments args) throws Exception {
        switch (method) {
            case "getEnergyInfo": {
                return this.getEnergyInfo(context, args);
            }
            case "getFuel": {
                return this.getFuel(context, args);
            }
            case "getSolidFuel": {
                return this.getSolidFuel(context, args);
            }
            case "canLaunch": {
                return this.canLaunch(context, args);
            }
            case "getRocketStats": {
                return this.getRocketStats(context, args);
            }
            case "getDestination": {
                return this.getDestination(context, args);
            }
            case "launch": {
                return this.launch(context, args);
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void setPower(long power) {
        this.power = power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    @Override
    public FluidTank[] getAllTanks() {
        return this.tanks;
    }

    @Override
    public FluidTank[] getReceivingTanks() {
        return this.tanks;
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new ContainerLaunchPadRocket(player.field_71071_by, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUILaunchPadRocket(player.field_71071_by, this);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 1024.0;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

