/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.tileentity;

import com.hbm.blocks.ModBlocks;
import com.hbm.main.ResourceManager;
import com.hbm.render.item.ItemRenderBase;
import com.hbm.render.tileentity.IItemRendererProvider;
import com.hbm.tileentity.network.TileEntityPipeAnchor;
import com.hbm.util.ColorUtil;
import com.hbm.util.Compat;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class RenderPipeAnchor
extends TileEntitySpecialRenderer
implements IItemRendererProvider {
    public void func_147500_a(TileEntity te, double x, double y, double z, float interp) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glEnable((int)2896);
        GL11.glShadeModel((int)7425);
        GL11.glPushMatrix();
        switch (te.func_145832_p()) {
            case 0: {
                GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 3: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                break;
            }
            case 4: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 5: {
                GL11.glRotated((double)90.0, (double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)270.0, (double)0.0, (double)0.0, (double)1.0);
            }
        }
        GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
        this.func_147499_a(ResourceManager.pipe_anchor_tex);
        ResourceManager.pipe_anchor.renderPart("Anchor");
        GL11.glPopMatrix();
        TileEntityPipeAnchor anchor = (TileEntityPipeAnchor)te;
        for (int[] pos : anchor.getConnected()) {
            Vec3 connectionPoint;
            Vec3 anchorPoint;
            TileEntity tile = Compat.getTileStandard(te.func_145831_w(), pos[0], pos[1], pos[2]);
            if (!(tile instanceof TileEntityPipeAnchor)) continue;
            TileEntityPipeAnchor other = (TileEntityPipeAnchor)tile;
            if (anchor.getType() != other.getType() || !RenderPipeAnchor.isDominant(anchorPoint = anchor.getConnectionPoint(), connectionPoint = other.getConnectionPoint())) continue;
            double dX = connectionPoint.field_72450_a - anchorPoint.field_72450_a;
            double dY = connectionPoint.field_72448_b - anchorPoint.field_72448_b;
            double dZ = connectionPoint.field_72449_c - anchorPoint.field_72449_c;
            double hyp = Math.sqrt(dX * dX + dZ * dZ);
            double yaw = Math.toDegrees(Math.atan2(dX, dZ));
            double pitch = Math.toDegrees(Math.atan2(dY, hyp));
            double length = Math.sqrt(dX * dX + dY * dY + dZ * dZ);
            GL11.glPushMatrix();
            GL11.glRotated((double)yaw, (double)0.0, (double)1.0, (double)0.0);
            GL11.glRotated((double)(90.0 - pitch), (double)1.0, (double)0.0, (double)0.0);
            GL11.glPushMatrix();
            GL11.glScaled((double)1.0, (double)length, (double)1.0);
            GL11.glTranslated((double)0.0, (double)-0.5, (double)0.0);
            int color = ColorUtil.lightenColor(anchor.getType().getColor(), 0.25);
            GL11.glColor3f((float)ColorUtil.fr(color), (float)ColorUtil.fg(color), (float)ColorUtil.fb(color));
            ResourceManager.pipe_anchor.renderPart("Pipe");
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glTranslated((double)0.0, (double)(length / 2.0 - 1.5), (double)0.0);
            ResourceManager.pipe_anchor.renderPart("Ring");
            GL11.glPopMatrix();
            GL11.glPopMatrix();
        }
        GL11.glShadeModel((int)7424);
        GL11.glPopMatrix();
    }

    public static boolean isDominant(Vec3 first, Vec3 second) {
        if (first.field_72450_a < second.field_72450_a) {
            return true;
        }
        if (first.field_72450_a > second.field_72450_a) {
            return false;
        }
        if (first.field_72448_b < second.field_72448_b) {
            return true;
        }
        if (first.field_72448_b > second.field_72448_b) {
            return false;
        }
        if (first.field_72449_c < second.field_72449_c) {
            return true;
        }
        if (first.field_72449_c > second.field_72449_c) {
            return false;
        }
        return false;
    }

    @Override
    public Item getItemForRenderer() {
        return Item.func_150898_a((Block)ModBlocks.pipe_anchor);
    }

    @Override
    public IItemRenderer getRenderer() {
        return new ItemRenderBase(){

            @Override
            public void renderInventory() {
                GL11.glTranslated((double)0.0, (double)-3.5, (double)0.0);
                double scale = 10.0;
                GL11.glScaled((double)scale, (double)scale, (double)scale);
            }

            @Override
            public void renderCommon() {
                GL11.glShadeModel((int)7425);
                RenderPipeAnchor.this.func_147499_a(ResourceManager.pipe_anchor_tex);
                ResourceManager.pipe_anchor.renderPart("Anchor");
                GL11.glShadeModel((int)7424);
            }
        };
    }
}

