/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.entity.effect;

import com.hbm.entity.effect.EntityFalloutRain;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import org.lwjgl.opengl.GL11;

public class RenderFallout
extends Render {
    private static final ResourceLocation falloutTexture = new ResourceLocation("hbm", "textures/entity/fallout.png");
    private Random random = new Random();
    float[] rainXCoords;
    float[] rainYCoords;
    long lastTime = System.nanoTime();

    public void func_76986_a(Entity entity, double x, double y, double z, float f0, float f1) {
        if (entity instanceof EntityFalloutRain) {
            this.render((EntityFalloutRain)entity, x, y, z, f0, f1);
        }
    }

    public void render(EntityFalloutRain entity, double x, double y, double z, float f0, float f1) {
        Minecraft mc = Minecraft.func_71410_x();
        EntityLivingBase entitylivingbase = mc.field_71451_h;
        Vec3 vector = Vec3.func_72443_a((double)(entitylivingbase.field_70165_t - entity.field_70165_t), (double)(entitylivingbase.field_70163_u - entity.field_70163_u), (double)(entitylivingbase.field_70161_v - entity.field_70161_v));
        if (vector.func_72433_c() <= (double)entity.getScale()) {
            long time = System.nanoTime();
            float t = (time - this.lastTime) / 50000000L;
            if (t <= 1.0f) {
                this.renderRainSnow(t);
            } else {
                this.renderRainSnow(1.0f);
            }
            this.lastTime = time;
        }
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return falloutTexture;
    }

    protected void renderRainSnow(float interp) {
        Minecraft mc = Minecraft.func_71410_x();
        int timer = mc.field_71439_g.field_70173_aa;
        float intensity = 1.0f;
        if (intensity > 0.0f) {
            if (this.rainXCoords == null) {
                this.rainXCoords = new float[1024];
                this.rainYCoords = new float[1024];
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        float f2 = j - 16;
                        float f3 = i - 16;
                        float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                        this.rainXCoords[i << 5 | j] = -f3 / f4;
                        this.rainYCoords[i << 5 | j] = f2 / f4;
                    }
                }
            }
            WorldClient worldclient = mc.field_71441_e;
            EntityLivingBase camera = mc.field_71451_h;
            int playerX = MathHelper.func_76128_c((double)camera.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)camera.field_70163_u);
            int playerZ = MathHelper.func_76128_c((double)camera.field_70161_v);
            double dX = camera.field_70142_S + (camera.field_70165_t - camera.field_70142_S) * (double)interp;
            double dY = camera.field_70137_T + (camera.field_70163_u - camera.field_70137_T) * (double)interp;
            double dZ = camera.field_70136_U + (camera.field_70161_v - camera.field_70136_U) * (double)interp;
            int playerHeight = MathHelper.func_76128_c((double)dY);
            int renderLayerCount = 5;
            int layer = -1;
            if (mc.field_71474_y.field_74347_j) {
                renderLayerCount = 10;
            }
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (int layerZ = playerZ - renderLayerCount; layerZ <= playerZ + renderLayerCount; ++layerZ) {
                for (int layerX = playerX - renderLayerCount; layerX <= playerX + renderLayerCount; ++layerX) {
                    int rainCoord = (layerZ - playerZ + 16) * 32 + layerX - playerX + 16;
                    float rainCoordX = this.rainXCoords[rainCoord] * 0.5f;
                    float rainCoordY = this.rainYCoords[rainCoord] * 0.5f;
                    int rainHeight = worldclient.func_72874_g(layerX, layerZ);
                    int minHeight = playerY - renderLayerCount;
                    int maxHeight = playerY + renderLayerCount;
                    if (minHeight < rainHeight) {
                        minHeight = rainHeight;
                    }
                    if (maxHeight < rainHeight) {
                        maxHeight = rainHeight;
                    }
                    int layerY = rainHeight;
                    if (rainHeight < playerHeight) {
                        layerY = playerHeight;
                    }
                    if (minHeight == maxHeight) continue;
                    this.random.setSeed(layerX * layerX * 3121 + layerX * 45238971 ^ layerZ * layerZ * 418711 + layerZ * 13761);
                    if (layer != 1) {
                        if (layer >= 0) {
                            tessellator.func_78381_a();
                        }
                        layer = 1;
                        mc.func_110434_K().func_110577_a(falloutTexture);
                        tessellator.func_78382_b();
                    }
                    float fallSpeed = 1.0f;
                    float swayLoop = ((float)(timer & 0x1FF) + interp) / 512.0f;
                    float fallVariation = 0.4f + this.random.nextFloat() * 0.2f;
                    float swayVariation = this.random.nextFloat();
                    double distX = (double)((float)layerX + 0.5f) - camera.field_70165_t;
                    double distZ = (double)((float)layerZ + 0.5f) - camera.field_70161_v;
                    float intensityMod = MathHelper.func_76133_a((double)(distX * distX + distZ * distZ)) / (float)renderLayerCount;
                    float colorMod = 1.0f;
                    tessellator.func_78380_c((worldclient.func_72802_i(layerX, layerY, layerZ, 0) * 3 + 0xF000F0) / 4);
                    tessellator.func_78369_a(colorMod, colorMod, colorMod, ((1.0f - intensityMod * intensityMod) * 0.3f + 0.5f) * intensity);
                    tessellator.func_78373_b(-dX * 1.0, -dY * 1.0, -dZ * 1.0);
                    tessellator.func_78374_a((double)((float)layerX - rainCoordX) + 0.5, (double)minHeight, (double)((float)layerZ - rainCoordY) + 0.5, (double)(0.0f * fallSpeed + fallVariation), (double)((float)minHeight * fallSpeed / 4.0f + swayLoop * fallSpeed + swayVariation));
                    tessellator.func_78374_a((double)((float)layerX + rainCoordX) + 0.5, (double)minHeight, (double)((float)layerZ + rainCoordY) + 0.5, (double)(1.0f * fallSpeed + fallVariation), (double)((float)minHeight * fallSpeed / 4.0f + swayLoop * fallSpeed + swayVariation));
                    tessellator.func_78374_a((double)((float)layerX + rainCoordX) + 0.5, (double)maxHeight, (double)((float)layerZ + rainCoordY) + 0.5, (double)(1.0f * fallSpeed + fallVariation), (double)((float)maxHeight * fallSpeed / 4.0f + swayLoop * fallSpeed + swayVariation));
                    tessellator.func_78374_a((double)((float)layerX - rainCoordX) + 0.5, (double)maxHeight, (double)((float)layerZ - rainCoordY) + 0.5, (double)(0.0f * fallSpeed + fallVariation), (double)((float)maxHeight * fallSpeed / 4.0f + swayLoop * fallSpeed + swayVariation));
                    tessellator.func_78373_b(0.0, 0.0, 0.0);
                }
            }
            if (layer >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }
}

