/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.render.block.ct;

import com.hbm.interfaces.NotableComments;
import com.hbm.main.MainRegistry;
import com.hbm.render.block.ct.CTContext;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@NotableComments
public class RenderBlocksCT
extends RenderBlocks {
    public static RenderBlocksCT instance = new RenderBlocksCT();
    VertInfo tl;
    VertInfo tc;
    VertInfo tr;
    VertInfo cl;
    VertInfo cc;
    VertInfo cr;
    VertInfo bl;
    VertInfo bc;
    VertInfo br;

    public void prepWorld(IBlockAccess acc) {
        this.field_147845_a = acc;
    }

    private void initSideInfo(int side) {
        if (!this.field_147863_w) {
            return;
        }
        if (side == ForgeDirection.SOUTH.ordinal()) {
            this.tl = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.tr = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.bl = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.br = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        } else if (side == ForgeDirection.NORTH.ordinal()) {
            this.tr = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.br = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.tl = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.bl = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        } else if (side == ForgeDirection.EAST.ordinal()) {
            this.bl = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.tl = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.br = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.tr = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        } else if (side == ForgeDirection.WEST.ordinal()) {
            this.tr = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.br = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.tl = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.bl = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        } else if (side == ForgeDirection.UP.ordinal()) {
            this.br = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.bl = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.tr = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.tl = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        } else {
            this.tl = new VertInfo(this.field_147872_ap, this.field_147846_at, this.field_147854_ax, this.field_147864_al);
            this.tr = new VertInfo(this.field_147848_as, this.field_147856_aw, this.field_147833_aA, this.field_147870_ao);
            this.bl = new VertInfo(this.field_147852_aq, this.field_147860_au, this.field_147841_ay, this.field_147874_am);
            this.br = new VertInfo(this.field_147850_ar, this.field_147858_av, this.field_147839_az, this.field_147876_an);
        }
        this.tc = VertInfo.avg(this.tl, this.tr);
        this.bc = VertInfo.avg(this.bl, this.br);
        this.cl = VertInfo.avg(this.tl, this.bl);
        this.cr = VertInfo.avg(this.tr, this.br);
        this.cc = VertInfo.avg(this.tl, this.tr, this.bl, this.br);
    }

    public boolean func_147784_q(Block block, int x, int y, int z) {
        if (this.field_147845_a == null) {
            MainRegistry.logger.error("Tried to call RenderBlocksCT without setting up a world context!");
            return false;
        }
        Tessellator t = Tessellator.field_78398_a;
        for (int i = 0; i < 8; ++i) {
            t.func_78377_a(0.0, 0.0, 0.0);
        }
        return super.func_147784_q(block, x, y, z);
    }

    public void func_147764_f(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.EAST.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.EAST.ordinal()];
        this.drawFace(new double[]{x + 1.0, y + 1.0, z + 1.0}, new double[]{x + 1.0, y + 1.0, z + 0.0}, new double[]{x + 1.0, y + 0.0, z + 1.0}, new double[]{x + 1.0, y + 0.0, z + 0.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    public void func_147798_e(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.WEST.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.WEST.ordinal()];
        this.drawFace(new double[]{x + 0.0, y + 1.0, z + 0.0}, new double[]{x + 0.0, y + 1.0, z + 1.0}, new double[]{x + 0.0, y + 0.0, z + 0.0}, new double[]{x + 0.0, y + 0.0, z + 1.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    public void func_147806_b(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.UP.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.UP.ordinal()];
        this.drawFace(new double[]{x + 0.0, y + 1.0, z + 0.0}, new double[]{x + 1.0, y + 1.0, z + 0.0}, new double[]{x + 0.0, y + 1.0, z + 1.0}, new double[]{x + 1.0, y + 1.0, z + 1.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    public void func_147768_a(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.DOWN.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.DOWN.ordinal()];
        this.drawFace(new double[]{x + 0.0, y + 0.0, z + 1.0}, new double[]{x + 1.0, y + 0.0, z + 1.0}, new double[]{x + 0.0, y + 0.0, z + 0.0}, new double[]{x + 1.0, y + 0.0, z + 0.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    public void func_147734_d(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.SOUTH.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.SOUTH.ordinal()];
        this.drawFace(new double[]{x + 0.0, y + 1.0, z + 1.0}, new double[]{x + 1.0, y + 1.0, z + 1.0}, new double[]{x + 0.0, y + 0.0, z + 1.0}, new double[]{x + 1.0, y + 0.0, z + 1.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    public void func_147761_c(Block block, double x, double y, double z, IIcon icon) {
        this.initSideInfo(ForgeDirection.NORTH.ordinal());
        CTContext.CTFace face = CTContext.faces[ForgeDirection.NORTH.ordinal()];
        this.drawFace(new double[]{x + 1.0, y + 1.0, z + 0.0}, new double[]{x + 0.0, y + 1.0, z + 0.0}, new double[]{x + 1.0, y + 0.0, z + 0.0}, new double[]{x + 0.0, y + 0.0, z + 0.0}, face.getTopLeft(), face.getTopRight(), face.getBottomLeft(), face.getBottomRight());
    }

    private void drawFace(double[] ftl, double[] ftr, double[] fbl, double[] fbr, IIcon itl, IIcon itr, IIcon ibl, IIcon ibr) {
        double[] ftc = this.avgCoords(ftl, ftr);
        double[] fbc = this.avgCoords(fbl, fbr);
        double[] fcl = this.avgCoords(ftl, fbl);
        double[] fcr = this.avgCoords(ftr, fbr);
        double[] fcc = this.avgCoords(ftc, fbc);
        this.drawSubFace(ftl, this.tl, ftc, this.tc, fcl, this.cl, fcc, this.cc, itl);
        this.drawSubFace(ftc, this.tc, ftr, this.tr, fcc, this.cc, fcr, this.cr, itr);
        this.drawSubFace(fcl, this.cl, fcc, this.cc, fbl, this.bl, fbc, this.bc, ibl);
        this.drawSubFace(fcc, this.cc, fcr, this.cr, fbc, this.bc, fbr, this.br, ibr);
    }

    private void drawSubFace(double[] ftl, VertInfo ntl, double[] ftr, VertInfo ntr, double[] fbl, VertInfo nbl, double[] fbr, VertInfo nbr, IIcon icon) {
        boolean debugColor = false;
        if (debugColor) {
            Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 0.0f);
        }
        this.drawVert(ftr, icon.func_94212_f(), icon.func_94206_g(), ntr);
        if (debugColor) {
            Tessellator.field_78398_a.func_78386_a(1.0f, 0.0f, 0.0f);
        }
        this.drawVert(ftl, icon.func_94209_e(), icon.func_94206_g(), ntl);
        if (debugColor) {
            Tessellator.field_78398_a.func_78386_a(0.0f, 0.0f, 1.0f);
        }
        this.drawVert(fbl, icon.func_94209_e(), icon.func_94210_h(), nbl);
        if (debugColor) {
            Tessellator.field_78398_a.func_78386_a(0.0f, 1.0f, 0.0f);
        }
        this.drawVert(fbr, icon.func_94212_f(), icon.func_94210_h(), nbr);
    }

    private void drawVert(double[] coord, double u, double v, VertInfo info) {
        this.drawVert(coord[0], coord[1], coord[2], u, v, info);
    }

    private void drawVert(double x, double y, double z, double u, double v, VertInfo info) {
        if (this.field_147863_w) {
            Tessellator.field_78398_a.func_78386_a(info.red, info.green, info.blue);
            Tessellator.field_78398_a.func_78380_c(info.brightness);
        }
        Tessellator.field_78398_a.func_78374_a(x, y, z, u, v);
    }

    private double[] avgCoords(double[] first, double[] second) {
        return new double[]{(first[0] + second[0]) / 2.0, (first[1] + second[1]) / 2.0, (first[2] + second[2]) / 2.0};
    }

    public void func_147800_a(Block block, int meta, float mult) {
        block.func_149683_g();
        this.func_147775_a(block);
        GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, -1.0f, 0.0f);
        super.func_147768_a(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 0, meta));
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 1.0f, 0.0f);
        super.func_147806_b(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 1, meta));
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, -1.0f);
        super.func_147761_c(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 2, meta));
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(0.0f, 0.0f, 1.0f);
        super.func_147734_d(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 3, meta));
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(-1.0f, 0.0f, 0.0f);
        super.func_147798_e(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 4, meta));
        Tessellator.field_78398_a.func_78381_a();
        Tessellator.field_78398_a.func_78382_b();
        Tessellator.field_78398_a.func_78375_b(1.0f, 0.0f, 0.0f);
        super.func_147764_f(block, 0.0, 0.0, 0.0, this.func_147787_a(block, 5, meta));
        Tessellator.field_78398_a.func_78381_a();
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
    }

    public static class VertInfo {
        float red;
        float green;
        float blue;
        int brightness;

        public VertInfo(float red, float green, float blue, int brightness) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.brightness = brightness;
        }

        public static VertInfo avg(VertInfo ... infos) {
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            int l = 0;
            for (VertInfo vert : infos) {
                r += vert.red;
                g += vert.green;
                b += vert.blue;
                l += vert.brightness;
            }
            return new VertInfo(r /= (float)infos.length, g /= (float)infos.length, b /= (float)infos.length, l /= infos.length);
        }
    }
}

