/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.psys.engine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

@SideOnly(value=Side.CLIENT)
public abstract class PSysFX {
    public World world;
    public double posX;
    public double posY;
    public double posZ;
    public double prevPosX;
    public double prevPosY;
    public double prevPosZ;
    public static double interpPosX;
    public static double interpPosY;
    public static double interpPosZ;
    public AxisAlignedBB boundingBox;
    public int particleAge;
    public int particleMaxAge;
    public boolean isExpired = false;
    public boolean shouldExpireWhenUnloaded = true;
    public boolean isUnloaded = false;

    public PSysFX(World world, double x, double y, double z) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
    }

    public void updateParticle() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        this.isUnloaded = !this.world.func_72863_F().func_73149_a((int)Math.floor(this.posX) >> 4, (int)Math.floor(this.posZ) >> 4);
        ++this.particleAge;
        if (this.particleAge >= this.particleMaxAge) {
            this.expire();
        }
        if (this.shouldExpireWhenUnloaded && this.isUnloaded) {
            this.expire();
        }
    }

    public abstract void renderParticle();

    public AxisAlignedBB getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(AxisAlignedBB bb) {
        this.boundingBox = bb;
    }

    protected void setPosToAABB() {
        AxisAlignedBB aabb = this.getBoundingBox();
        this.posX = (aabb.field_72340_a + aabb.field_72336_d) / 2.0;
        this.posY = aabb.field_72338_b;
        this.posZ = (aabb.field_72339_c + aabb.field_72334_f) / 2.0;
    }

    public void expire() {
        this.isExpired = true;
    }

    public void setExpireOnUnload(boolean expire) {
        this.shouldExpireWhenUnloaded = expire;
    }
}

