/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.particle.helper;

import com.hbm.particle.ParticleExplosionSmall;
import com.hbm.particle.helper.IParticleCreator;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.particle.EntityBlockDustFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ExplosionSmallCreator
implements IParticleCreator {
    public static final double speedOfSound = 8.575;

    public static void composeEffect(World world, double x, double y, double z, int cloudCount, float cloudScale, float cloudSpeedMult) {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "explosionSmall");
        data.func_74768_a("cloudCount", cloudCount);
        data.func_74776_a("cloudScale", cloudScale);
        data.func_74776_a("cloudSpeedMult", cloudSpeedMult);
        data.func_74768_a("debris", 15);
        IParticleCreator.sendPacket(world, x, y, z, 200, data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void makeParticle(World world, EntityPlayer player, TextureManager texman, Random rand, double x, double y, double z, NBTTagCompound data) {
        float soundRange;
        int cloudCount = data.func_74762_e("cloudCount");
        float cloudScale = data.func_74760_g("cloudScale");
        float cloudSpeedMult = data.func_74760_g("cloudSpeedMult");
        int debris = data.func_74762_e("debris");
        float dist = (float)player.func_70011_f(x, y, z);
        if (dist <= (soundRange = 200.0f)) {
            String sound = (double)dist <= (double)soundRange * 0.4 ? "hbm:weapon.explosionSmallNear" : "hbm:weapon.explosionSmallFar";
            PositionedSoundRecord positionedsoundrecord = new PositionedSoundRecord(new ResourceLocation(sound), 100.0f, 0.9f + rand.nextFloat() * 0.2f, (float)x, (float)y, (float)z);
            Minecraft.func_71410_x().func_147118_V().func_147681_a((ISound)positionedsoundrecord, (int)((double)dist / 8.575));
        }
        for (int i = 0; i < cloudCount; ++i) {
            ParticleExplosionSmall particle = new ParticleExplosionSmall(world, x, y, z, cloudScale, cloudSpeedMult);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)particle);
        }
        Block b = Blocks.field_150350_a;
        int meta = 0;
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            b = world.func_147439_a((int)Math.floor(x) + dir.offsetX, (int)Math.floor(y) + dir.offsetY, (int)Math.floor(z) + dir.offsetZ);
            meta = world.func_72805_g((int)Math.floor(x) + dir.offsetX, (int)Math.floor(y) + dir.offsetY, (int)Math.floor(z) + dir.offsetZ);
            if (b != Blocks.field_150350_a) break;
        }
        if (b != Blocks.field_150350_a) {
            for (int i = 0; i < debris; ++i) {
                EntityBlockDustFX fx = new EntityBlockDustFX(world, x, y + 0.1, z, world.field_73012_v.nextGaussian() * 0.2, 0.5 + world.field_73012_v.nextDouble() * 0.7, world.field_73012_v.nextGaussian() * 0.2, b, meta);
                fx.func_70541_f(2.0f);
                ReflectionHelper.setPrivateValue(EntityFX.class, (Object)fx, (Object)(50 + rand.nextInt(20)), (String[])new String[]{"particleMaxAge", "field_70547_e"});
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)fx);
            }
        }
    }
}

