/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.main;

import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.threading.ThreadedPacket;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.SimpleChannelHandlerWrapper;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TObjectByteHashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.MessageToMessageCodec;
import java.lang.ref.WeakReference;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;

public class NetworkHandler {
    private static FMLEmbeddedChannel clientChannel;
    private static FMLEmbeddedChannel serverChannel;
    private static PrecompilingNetworkCodec packetCodec;

    public NetworkHandler(String name) {
        packetCodec = new PrecompilingNetworkCodec();
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{packetCodec});
        clientChannel = (FMLEmbeddedChannel)channels.get(Side.CLIENT);
        serverChannel = (FMLEmbeddedChannel)channels.get(Side.SERVER);
    }

    public <REQ extends IMessage, REPLY extends IMessage> void registerMessage(Class<? extends IMessageHandler<REQ, REPLY>> messageHandler, Class<REQ> requestMessageType, int discriminator, Side side) {
        packetCodec.addDiscriminator(discriminator, requestMessageType);
        FMLEmbeddedChannel channel = side.isClient() ? clientChannel : serverChannel;
        String type = channel.findChannelHandlerNameForType(PrecompilingNetworkCodec.class);
        SimpleChannelHandlerWrapper handler = new SimpleChannelHandlerWrapper(messageHandler, side, requestMessageType);
        channel.pipeline().addAfter(type, messageHandler.getName(), (ChannelHandler)handler);
    }

    public static void flush() {
        clientChannel.flush();
        serverChannel.flush();
    }

    public void sendToServer(IMessage message) {
        clientChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        clientChannel.write((Object)message);
    }

    public void sendToDimension(IMessage message, int dimensionId) {
        if (!Thread.currentThread().getName().contains("NTM-Packet-Thread-")) {
            try {
                PacketThreading.lock.lock();
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
                serverChannel.write((Object)message);
            }
            finally {
                PacketThreading.lock.unlock();
            }
        } else {
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
            serverChannel.write((Object)message);
        }
    }

    public void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        if (!Thread.currentThread().getName().contains("NTM-Packet-Thread-")) {
            try {
                PacketThreading.lock.lock();
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
                serverChannel.write((Object)message);
            }
            finally {
                PacketThreading.lock.unlock();
            }
        } else {
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            serverChannel.write((Object)message);
        }
    }

    public void sendToAllAround(ByteBuf message, NetworkRegistry.TargetPoint point) {
        if (!Thread.currentThread().getName().contains("NTM-Packet-Thread-")) {
            try {
                PacketThreading.lock.lock();
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
                serverChannel.write((Object)message);
            }
            finally {
                PacketThreading.lock.unlock();
            }
        } else {
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
            serverChannel.write((Object)message);
        }
    }

    public void sendTo(IMessage message, EntityPlayerMP player) {
        if (!Thread.currentThread().getName().contains("NTM-Packet-Thread-")) {
            try {
                PacketThreading.lock.lock();
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
                serverChannel.write((Object)message);
            }
            finally {
                PacketThreading.lock.unlock();
            }
        } else {
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            serverChannel.write((Object)message);
        }
    }

    public void sendToAll(IMessage message) {
        if (!Thread.currentThread().getName().contains("NTM-Packet-Thread-")) {
            try {
                PacketThreading.lock.lock();
                serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
                serverChannel.write((Object)message);
            }
            finally {
                PacketThreading.lock.unlock();
            }
        } else {
            serverChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
            serverChannel.write((Object)message);
        }
    }

    @ChannelHandler.Sharable
    private static class PrecompilingNetworkCodec
    extends MessageToMessageCodec<FMLProxyPacket, Object> {
        private final TByteObjectHashMap<Class<? extends IMessage>> discriminators = new TByteObjectHashMap();
        private final TObjectByteHashMap<Class<? extends IMessage>> types = new TObjectByteHashMap();

        private PrecompilingNetworkCodec() {
        }

        public void addDiscriminator(int discriminator, Class<? extends IMessage> type) {
            this.discriminators.put((byte)discriminator, type);
            this.types.put(type, (byte)discriminator);
        }

        public void handlerAdded(ChannelHandlerContext ctx) {
            ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).set(new ThreadLocal());
        }

        protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
            FMLProxyPacket old;
            ByteBuf outboundBuf = PooledByteBufAllocator.DEFAULT.heapBuffer();
            Class<?> msgClass = msg.getClass();
            byte discriminator = this.types.get(msgClass);
            outboundBuf.writeByte((int)discriminator);
            if (msg instanceof ThreadedPacket) {
                outboundBuf.writeBytes(((ThreadedPacket)msg).getCompiledBuffer());
            } else if (msg instanceof IMessage) {
                ((IMessage)msg).toBytes(outboundBuf);
            } else {
                throw new CodecException("Unknown packet codec requested during encoding, expected IMessage/PrecompiledPacket, got " + msg.getClass().getName());
            }
            FMLProxyPacket proxy = new FMLProxyPacket(Unpooled.buffer().writeBytes(outboundBuf), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
            outboundBuf.release();
            WeakReference ref = (WeakReference)((ThreadLocal)ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).get()).get();
            FMLProxyPacket fMLProxyPacket = old = ref == null ? null : (FMLProxyPacket)ref.get();
            if (old != null) {
                proxy.setDispatcher(old.getDispatcher());
            }
            out.add(proxy);
        }

        protected void decode(ChannelHandlerContext ctx, FMLProxyPacket msg, List<Object> out) throws Exception {
            ByteBuf inboundBuf = msg.payload();
            byte discriminator = inboundBuf.readByte();
            Class originalMsgClass = (Class)this.discriminators.get(discriminator);
            if (originalMsgClass == null) {
                throw new CodecException("Undefined message for discriminator " + discriminator + " in channel " + msg.channel());
            }
            Object newMsg = originalMsgClass.newInstance();
            ((ThreadLocal)ctx.attr(FMLIndexedMessageToMessageCodec.INBOUNDPACKETTRACKER).get()).set(new WeakReference<FMLProxyPacket>(msg));
            if (!(newMsg instanceof IMessage)) {
                throw new CodecException("Unknown packet codec requested during decoding, expected IMessage/PrecompiledPacket, got " + msg.getClass().getName());
            }
            ((IMessage)newMsg).fromBytes(inboundBuf.slice());
            out.add(newMsg);
        }
    }
}

