/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.impl;

import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.hud.IHUDComponent;
import com.hbm.render.util.RenderScreenOverlay;
import com.hbm.util.Vec3NT;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class ItemGunStinger
extends ItemGunBaseNT {
    public static final String KEY_LOCKINGON = "lockingon";
    public static final String KEY_LOCKONPROGRESS = "lockonprogress";
    public static float prevLockon;
    public static float lockon;

    public ItemGunStinger(ItemGunBaseNT.WeaponQuality quality, GunConfig ... cfg) {
        super(quality, cfg);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isHeld) {
        super.func_77663_a(stack, world, entity, slot, isHeld);
        if (!(entity instanceof EntityPlayer)) return;
        EntityPlayer player = (EntityPlayer)entity;
        if (!world.field_72995_K && !isHeld) {
            if (ItemGunStinger.getIsLockingOn(stack)) {
                ItemGunStinger.setIsLockingOn(stack, false);
            }
        }
        prevLockon = lockon;
        if (!world.field_72995_K) {
            int prevTarget = ItemGunStinger.getLockonTarget(stack);
            if (isHeld) {
                if (ItemGunStinger.getIsLockingOn(stack)) {
                    if (ItemGunStinger.getIsAiming(stack) && this.getConfig(stack, 0).getReceivers(stack)[0].getMagazine(stack).getAmount(stack, (IInventory)player.field_71071_by) > 0) {
                        int newLockonTarget = ItemGunStinger.getLockonTarget(player, 150.0, 10.0);
                        if (newLockonTarget == -1) {
                            if (ItemGunStinger.getIsLockedOn(stack)) return;
                            this.resetLockon(world, stack);
                            return;
                        }
                        if (!ItemGunStinger.getIsLockedOn(stack) && newLockonTarget != prevTarget) {
                            this.resetLockon(world, stack);
                            ItemGunStinger.setLockonTarget(stack, newLockonTarget);
                        }
                        this.progressLockon(world, stack);
                        if (ItemGunStinger.getLockonProgress(stack) < 60) return;
                        if (ItemGunStinger.getIsLockedOn(stack)) return;
                        player.field_70170_p.func_72956_a((Entity)player, "hbm:item.techBleep", 1.0f, 1.0f);
                        ItemGunStinger.setIsLockedOn(stack, true);
                        return;
                    }
                }
            }
            this.resetLockon(world, stack);
            return;
        }
        if (ItemGunStinger.getLockonProgress(stack) > 1) {
            lockon += 0.016666668f;
            return;
        }
        lockon = 0.0f;
    }

    public void resetLockon(World world, ItemStack stack) {
        ItemGunStinger.setLockonProgress(stack, 0);
        ItemGunStinger.setIsLockedOn(stack, false);
    }

    public void progressLockon(World world, ItemStack stack) {
        ItemGunStinger.setLockonProgress(stack, ItemGunStinger.getLockonProgress(stack) + 1);
    }

    public static int getLockonTarget(EntityPlayer player, double distance, double angleThreshold) {
        if (player == null) {
            return -1;
        }
        double x = player.field_70165_t;
        double y = player.field_70163_u + (double)player.func_70047_e();
        double z = player.field_70161_v;
        Vec3NT delta = new Vec3NT(player.func_70676_i(1.0f)).multiply(distance);
        Vec3NT look = new Vec3NT(delta).add(x, y, z);
        Vec3NT left = new Vec3NT(delta).add(x, y, z).rotateAroundYDeg(-angleThreshold).add(0.0, 10.0, 0.0);
        Vec3NT right = new Vec3NT(delta).add(x, y, z).rotateAroundYDeg(angleThreshold).add(0.0, -10.0, 0.0);
        Vec3NT pos = new Vec3NT(x, y, z);
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)Vec3NT.getMinX(look, left, right, pos), (double)Vec3NT.getMinY(look, left, right, pos), (double)Vec3NT.getMinZ(look, left, right, pos), (double)Vec3NT.getMaxX(look, left, right, pos), (double)Vec3NT.getMaxY(look, left, right, pos), (double)Vec3NT.getMaxZ(look, left, right, pos));
        List entities = player.field_70170_p.func_72839_b((Entity)player, aabb);
        Entity closestEntity = null;
        double closestAngle = 360.0;
        Vec3NT toEntity = new Vec3NT(0.0, 0.0, 0.0);
        for (Entity entity : entities) {
            if (entity.field_70131_O < 0.5f || !entity.func_70067_L()) continue;
            toEntity.setComponents(entity.field_70165_t - x, entity.field_70163_u + (double)entity.field_70131_O / 2.0 - y, entity.field_70161_v - z);
            double vecProd = toEntity.field_72450_a * delta.field_72450_a + toEntity.field_72448_b * delta.field_72448_b + toEntity.field_72449_c * delta.field_72449_c;
            double bot = toEntity.func_72433_c() * delta.func_72433_c();
            double angle = Math.abs(Math.acos(vecProd / bot) * 180.0 / Math.PI);
            if (!(angle < closestAngle) || !(angle < angleThreshold)) continue;
            closestAngle = angle;
            closestEntity = entity;
        }
        return closestEntity == null ? -1 : closestEntity.func_145782_y();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderHUD(RenderGameOverlayEvent.Pre event, RenderGameOverlayEvent.ElementType type, EntityPlayer player, ItemStack stack) {
        ItemGunBaseNT gun = (ItemGunBaseNT)stack.func_77973_b();
        if (type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            event.setCanceled(true);
            if (aimingProgress < 1.0f) {
                return;
            }
            RenderScreenOverlay.renderCustomCrosshairs(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v, gun.getConfig(stack, 0).getCrosshair(stack));
            RenderScreenOverlay.renderStingerLockon(event.resolution, (Gui)Minecraft.func_71410_x().field_71456_v);
        }
        int confNo = this.configs_DNA.length;
        for (int i = 0; i < confNo; ++i) {
            IHUDComponent[] components = gun.getConfig(stack, i).getHUDComponents(stack);
            if (components == null) continue;
            for (IHUDComponent component : components) {
                int bottomOffset = 0;
                component.renderHUDComponent(event, type, player, stack, bottomOffset, i);
                bottomOffset += component.getComponentHeight(player, stack);
            }
        }
    }

    public static boolean getIsLockingOn(ItemStack stack) {
        return ItemGunStinger.getValueBool(stack, KEY_LOCKINGON);
    }

    public static void setIsLockingOn(ItemStack stack, boolean value) {
        ItemGunStinger.setValueBool(stack, KEY_LOCKINGON, value);
    }

    public static int getLockonProgress(ItemStack stack) {
        return ItemGunStinger.getValueInt(stack, KEY_LOCKONPROGRESS);
    }

    public static void setLockonProgress(ItemStack stack, int value) {
        ItemGunStinger.setValueInt(stack, KEY_LOCKONPROGRESS, value);
    }
}

