/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.blocks.ICustomBlockHighlight;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import com.hbm.items.weapon.sedna.Crosshair;
import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.factory.GunStateDecider;
import com.hbm.items.weapon.sedna.factory.Lego;
import com.hbm.items.weapon.sedna.factory.Orchestras;
import com.hbm.items.weapon.sedna.impl.ItemGunDrill;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.items.weapon.sedna.mags.MagazineLiquidEngine;
import com.hbm.items.weapon.sedna.mods.XWeaponModManager;
import com.hbm.render.anim.AnimationEnums;
import com.hbm.render.anim.BusAnimation;
import com.hbm.render.anim.BusAnimationKeyframe;
import com.hbm.render.anim.BusAnimationSequence;
import com.hbm.render.anim.HbmAnimations;
import com.hbm.util.EntityDamageUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S28PacketEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class XFactoryDrill {
    public static final String D_REACH = "D_REACH";
    public static final String F_DTNEG = "F_DTNEG";
    public static final String F_PIERCE = "F_PIERCE";
    public static final String I_AOE = "I_AOE";
    public static final String I_HARVEST = "I_HARVEST";
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_DRILL_FIRE = (stack, ctx) -> XFactoryDrill.doStandardFire(stack, ctx, AnimationEnums.GunAnimation.CYCLE, true);
    public static BiFunction<ItemStack, AnimationEnums.GunAnimation, BusAnimation> LAMBDA_DRILL_ANIMS = (stack, type) -> {
        switch (type) {
            case EQUIP: {
                return new BusAnimation().addBus("EQUIP", new BusAnimationSequence().setPos(-1.0, 0.0, 0.0).addPos(0.0, 0.0, 0.0, 750, BusAnimationKeyframe.IType.SIN_DOWN));
            }
            case CYCLE: {
                double deploy = HbmAnimations.getRelevantTransformation("DEPLOY")[0];
                double speed = HbmAnimations.getRelevantTransformation("SPEED")[0];
                double spin = HbmAnimations.getRelevantTransformation("SPIN")[0] % 360.0;
                return new BusAnimation().addBus("DEPLOY", new BusAnimationSequence().setPos(deploy, 0.0, 0.0).addPos(1.0, 0.0, 0.0, (int)(500.0 * (1.0 - deploy)), BusAnimationKeyframe.IType.SIN_FULL).hold(1000).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL)).addBus("SPIN", new BusAnimationSequence().setPos(spin, 0.0, 0.0).addPos(spin + 540.0, 0.0, 0.0, 1500).addPos(1080.0, 0.0, 0.0, 750 + (int)(1000.0 * (1.0 - spin / 360.0)), BusAnimationKeyframe.IType.SIN_DOWN)).addBus("SPEED", new BusAnimationSequence().setPos(speed, 0.0, 0.0).addPos(1.0, 0.0, 0.0, 500).hold(1000).addPos(0.0, 0.0, 0.0, 750 + (int)(1000.0 * (1.0 - spin / 360.0)), BusAnimationKeyframe.IType.SIN_DOWN));
            }
            case CYCLE_DRY: {
                return new BusAnimation().addBus("DEPLOY", new BusAnimationSequence().addPos(0.25, 0.0, 0.0, 250, BusAnimationKeyframe.IType.SIN_FULL).addPos(0.0, 0.0, 0.0, 250, BusAnimationKeyframe.IType.SIN_FULL)).addBus("SPIN", new BusAnimationSequence().addPos(360.0, 0.0, 0.0, 1500, BusAnimationKeyframe.IType.SIN_DOWN)).addBus("SPEED", new BusAnimationSequence().addPos(0.75, 0.0, 0.0, 250).addPos(0.0, 0.0, 0.0, 1000, BusAnimationKeyframe.IType.SIN_DOWN));
            }
            case INSPECT: {
                return new BusAnimation().addBus("LIFT", new BusAnimationSequence().addPos(-45.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_FULL).hold(1000).addPos(0.0, 0.0, 0.0, 500, BusAnimationKeyframe.IType.SIN_DOWN));
            }
        }
        return null;
    };

    public static void init() {
        ModItems.gun_drill = new ItemGunDrill(ItemGunBaseNT.WeaponQuality.UTILITY, new GunConfig().dura(3000.0f).draw(10).inspect(55).hideCrosshair(false).crosshair(Crosshair.L_CIRCUMFLEX).rec(new Receiver(0).dmg(10.0f).delay(20).dry(30).auto(true).jam(0).mag(new MagazineLiquidEngine(0, 4000, Fluids.GASOLINE, Fluids.GASOLINE_LEADED, Fluids.COALGAS, Fluids.COALGAS_LEADED)).offset(1.0, -0.15625, -0.25).canFire(Lego.LAMBDA_STANDARD_CAN_FIRE).fire(LAMBDA_DRILL_FIRE)).pp(Lego.LAMBDA_STANDARD_CLICK_PRIMARY).pr(Lego.LAMBDA_STANDARD_RELOAD).decider(GunStateDecider.LAMBDA_STANDARD_DECIDER).anim(LAMBDA_DRILL_ANIMS).orchestra(Orchestras.ORCHESTRA_DRILL)).func_77655_b("gun_drill");
    }

    public static void doStandardFire(ItemStack stack, ItemGunBaseNT.LambdaContext ctx, AnimationEnums.GunAnimation anim, boolean calcWear) {
        EntityPlayer player = ctx.getPlayer();
        int index = ctx.configIndex;
        if (anim != null) {
            ItemGunBaseNT.playAnimation(player, stack, anim, ctx.configIndex);
        }
        Receiver primary = ctx.config.getReceivers(stack)[0];
        IMagazine mag = primary.getMagazine(stack);
        MovingObjectPosition mop = EntityDamageUtil.getMouseOver(ctx.getPlayer(), XFactoryDrill.getModdableReach(stack, 5.0));
        if (mop != null) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.ENTITY) {
                float damage = primary.getBaseDamage(stack);
                if (mop.field_72308_g instanceof EntityLivingBase) {
                    EntityDamageUtil.attackEntityFromNT((EntityLivingBase)mop.field_72308_g, DamageSource.func_76365_a((EntityPlayer)ctx.getPlayer()), damage, true, true, 0.1f, XFactoryDrill.getModdableDTNegation(stack, 2.0f), XFactoryDrill.getModdablePiercing(stack, 0.15f));
                } else {
                    mop.field_72308_g.func_70097_a(DamageSource.func_76365_a((EntityPlayer)ctx.getPlayer()), damage);
                }
            }
            if (player != null) {
                MovingObjectPosition.MovingObjectType cfr_ignored_1 = mop.field_72313_a;
                if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    int aoe = player.func_70093_af() ? 0 : XFactoryDrill.getModdableAoE(stack, 1);
                    for (int i = -aoe; i <= aoe; ++i) {
                        for (int j = -aoe; j <= aoe; ++j) {
                            for (int k = -aoe; k <= aoe; ++k) {
                                XFactoryDrill.breakExtraBlock(player.field_70170_p, mop.field_72311_b + i, mop.field_72312_c + j, mop.field_72309_d + k, player, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                            }
                        }
                    }
                }
            }
        }
        int ammoToUse = 10;
        if (XWeaponModManager.hasUpgrade(stack, 0, 228)) {
            ammoToUse = 1000;
        }
        mag.useUpAmmo(stack, ctx.inventory, ammoToUse);
        if (calcWear) {
            ItemGunBaseNT.setWear(stack, index, Math.min(ItemGunBaseNT.getWear(stack, index), ctx.config.getDurability(stack)));
        }
    }

    public static void breakExtraBlock(World world, int x, int y, int z, EntityPlayer playerEntity, int refX, int refY, int refZ) {
        int meta;
        if (world.func_147437_c(x, y, z)) {
            return;
        }
        if (!(playerEntity instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)playerEntity;
        Block block = world.func_147439_a(x, y, z);
        if (!block.canHarvestBlock((EntityPlayer)player, meta = world.func_72805_g(x, y, z)) || block.func_149712_f(world, x, y, z) == -1.0f && block.func_149737_a((EntityPlayer)player, world, x, y, z) == 0.0f || block == ModBlocks.stone_keyhole) {
            world.func_72956_a((Entity)player, "random.break", 0.5f, 0.8f + world.field_73012_v.nextFloat() * 0.6f);
            return;
        }
        player.field_71134_c.func_73084_b(x, y, z);
        if (world.func_147439_a(x, y, z) == Blocks.field_150350_a) {
            player.field_71135_a.func_147359_a((Packet)new S28PacketEffect(2001, x, y, z, Block.func_149682_b((Block)block) + (meta << 12), false));
        }
    }

    public static double getModdableReach(ItemStack stack, double base) {
        return XWeaponModManager.eval(base, stack, D_REACH, ModItems.gun_drill, 0);
    }

    public static float getModdableDTNegation(ItemStack stack, float base) {
        return XWeaponModManager.eval(Float.valueOf(base), stack, F_DTNEG, ModItems.gun_drill, 0).floatValue();
    }

    public static float getModdablePiercing(ItemStack stack, float base) {
        return XWeaponModManager.eval(Float.valueOf(base), stack, F_PIERCE, ModItems.gun_drill, 0).floatValue();
    }

    public static int getModdableAoE(ItemStack stack, int base) {
        return XWeaponModManager.eval(base, stack, I_AOE, ModItems.gun_drill, 0);
    }

    public static int getModdableHarvestLevel(ItemStack stack, int base) {
        return XWeaponModManager.eval(base, stack, I_HARVEST, ModItems.gun_drill, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawBlockHighlight(EntityPlayer player, ItemStack drill, float interp) {
        MovingObjectPosition mop = EntityDamageUtil.getMouseOver(player, XFactoryDrill.getModdableReach(drill, 5.0));
        if (mop != null) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                double dX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)interp;
                double dY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)interp;
                double dZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)interp;
                ICustomBlockHighlight.setup();
                int aoe = player.func_70093_af() ? 0 : XFactoryDrill.getModdableAoE(drill, 1);
                float exp = 0.002f;
                AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
                RenderGlobal.func_147590_a((AxisAlignedBB)aabb.func_72314_b((double)exp, (double)exp, (double)exp).func_72325_c((double)mop.field_72311_b - dX, (double)mop.field_72312_c - dY, (double)mop.field_72309_d - dZ), (int)(aoe > 0 ? -1 : 0x800000));
                if (aoe > 0) {
                    aabb = AxisAlignedBB.func_72330_a((double)(-aoe), (double)(-aoe), (double)(-aoe), (double)(1 + aoe), (double)(1 + aoe), (double)(1 + aoe));
                    RenderGlobal.func_147590_a((AxisAlignedBB)aabb.func_72314_b((double)exp, (double)exp, (double)exp).func_72325_c((double)mop.field_72311_b - dX, (double)mop.field_72312_c - dY, (double)mop.field_72309_d - dZ), (int)0x800000);
                }
                ICustomBlockHighlight.cleanup();
            }
        }
    }
}

