/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.weapon.sedna.factory;

import com.hbm.items.weapon.sedna.GunConfig;
import com.hbm.items.weapon.sedna.ItemGunBaseNT;
import com.hbm.items.weapon.sedna.Receiver;
import com.hbm.items.weapon.sedna.mags.IMagazine;
import com.hbm.render.anim.AnimationEnums;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class GunStateDecider {
    public static BiConsumer<ItemStack, ItemGunBaseNT.LambdaContext> LAMBDA_STANDARD_DECIDER = (stack, ctx) -> {
        int index = ctx.configIndex;
        ItemGunBaseNT.GunState lastState = ItemGunBaseNT.getState(stack, index);
        GunStateDecider.deciderStandardFinishDraw(stack, lastState, index);
        GunStateDecider.deciderStandardClearJam(stack, lastState, index);
        GunStateDecider.deciderStandardReload(stack, ctx, lastState, 0, index);
        GunStateDecider.deciderAutoRefire(stack, ctx, lastState, 0, index, () -> ItemGunBaseNT.getPrimary(stack, index) && ItemGunBaseNT.getMode(stack, ctx.configIndex) == 0);
    };

    public static void deciderStandardFinishDraw(ItemStack stack, ItemGunBaseNT.GunState lastState, int index) {
        if (lastState == ItemGunBaseNT.GunState.DRAWING) {
            ItemGunBaseNT.setState(stack, index, ItemGunBaseNT.GunState.IDLE);
            ItemGunBaseNT.setTimer(stack, index, 0);
        }
    }

    public static void deciderStandardClearJam(ItemStack stack, ItemGunBaseNT.GunState lastState, int index) {
        if (lastState == ItemGunBaseNT.GunState.JAMMED) {
            ItemGunBaseNT.setState(stack, index, ItemGunBaseNT.GunState.IDLE);
            ItemGunBaseNT.setTimer(stack, index, 0);
        }
    }

    public static void deciderStandardReload(ItemStack stack, ItemGunBaseNT.LambdaContext ctx, ItemGunBaseNT.GunState lastState, int recIndex, int gunIndex) {
        if (lastState == ItemGunBaseNT.GunState.RELOADING) {
            EntityLivingBase entity = ctx.entity;
            EntityPlayer player = ctx.getPlayer();
            GunConfig cfg = ctx.config;
            Receiver rec = cfg.getReceivers(stack)[recIndex];
            IMagazine mag = rec.getMagazine(stack);
            mag.reloadAction(stack, ctx.inventory);
            boolean cancel = ItemGunBaseNT.getReloadCancel(stack);
            if (!cancel && mag.canReload(stack, ctx.inventory)) {
                ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.RELOADING);
                ItemGunBaseNT.setTimer(stack, gunIndex, rec.getReloadCycleDuration(stack));
                ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.RELOAD_CYCLE, gunIndex);
            } else {
                if (GunStateDecider.getStandardJamChance(stack, cfg, gunIndex) > entity.func_70681_au().nextFloat()) {
                    ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.JAMMED);
                    ItemGunBaseNT.setTimer(stack, gunIndex, rec.getJamDuration(stack));
                    ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.JAMMED, gunIndex);
                } else {
                    ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.DRAWING);
                    int duration = rec.getReloadEndDuration(stack) + (mag.getAmountBeforeReload(stack) <= 0 ? rec.getReloadCockOnEmptyPost(stack) : 0);
                    ItemGunBaseNT.setTimer(stack, gunIndex, duration);
                    ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.RELOAD_END, gunIndex);
                }
                ItemGunBaseNT.setReloadCancel(stack, false);
            }
            mag.setAmountAfterReload(stack, mag.getAmount(stack, ctx.inventory));
        }
    }

    public static float getStandardJamChance(ItemStack stack, GunConfig config, int index) {
        float percent = ItemGunBaseNT.getWear(stack, index) / config.getDurability(stack);
        if (percent < 0.66f) {
            return 0.0f;
        }
        return Math.min((percent - 0.66f) * 4.0f, 1.0f);
    }

    public static void deciderAutoRefire(ItemStack stack, ItemGunBaseNT.LambdaContext ctx, ItemGunBaseNT.GunState lastState, int recIndex, int gunIndex, BooleanSupplier refireCondition) {
        if (lastState == ItemGunBaseNT.GunState.COOLDOWN) {
            EntityLivingBase entity = ctx.entity;
            EntityPlayer player = ctx.getPlayer();
            GunConfig cfg = ctx.config;
            Receiver rec = cfg.getReceivers(stack)[recIndex];
            if (rec.getRefireOnHold(stack) && refireCondition.getAsBoolean()) {
                if (rec.getCanFire(stack).apply(stack, ctx).booleanValue()) {
                    rec.getOnFire(stack).accept(stack, ctx);
                    ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.COOLDOWN);
                    ItemGunBaseNT.setTimer(stack, gunIndex, rec.getDelayAfterFire(stack));
                    if (rec.getFireSound(stack) != null) {
                        entity.field_70170_p.func_72908_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, rec.getFireSound(stack), rec.getFireVolume(stack), rec.getFirePitch(stack));
                    }
                    int remaining = rec.getRoundsPerCycle(stack) - 1;
                    for (int i = 0; i < remaining; ++i) {
                        if (!rec.getCanFire(stack).apply(stack, ctx).booleanValue()) continue;
                        rec.getOnFire(stack).accept(stack, ctx);
                    }
                } else if (rec.getDoesDryFireAfterAuto(stack)) {
                    ItemGunBaseNT.setState(stack, gunIndex, rec.getRefireAfterDry(stack) ? ItemGunBaseNT.GunState.COOLDOWN : ItemGunBaseNT.GunState.DRAWING);
                    ItemGunBaseNT.setTimer(stack, gunIndex, rec.getDelayAfterDryFire(stack));
                    ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.CYCLE_DRY, gunIndex);
                } else {
                    ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.IDLE);
                    ItemGunBaseNT.setTimer(stack, gunIndex, 0);
                }
            } else if (rec.getReloadOnEmpty(stack) && rec.getMagazine(stack).getAmount(stack, ctx.inventory) <= 0) {
                ItemGunBaseNT.setIsAiming(stack, false);
                IMagazine mag = rec.getMagazine(stack);
                if (mag.canReload(stack, ctx.inventory)) {
                    int loaded = mag.getAmount(stack, ctx.inventory);
                    mag.setAmountBeforeReload(stack, loaded);
                    ItemGunBaseNT.setState(stack, ctx.configIndex, ItemGunBaseNT.GunState.RELOADING);
                    ItemGunBaseNT.setTimer(stack, ctx.configIndex, rec.getReloadBeginDuration(stack) + (loaded <= 0 ? rec.getReloadCockOnEmptyPre(stack) : 0));
                    ItemGunBaseNT.playAnimation(player, stack, AnimationEnums.GunAnimation.RELOAD, ctx.configIndex);
                } else {
                    ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.IDLE);
                    ItemGunBaseNT.setTimer(stack, gunIndex, 0);
                }
            } else {
                ItemGunBaseNT.setState(stack, gunIndex, ItemGunBaseNT.GunState.IDLE);
                ItemGunBaseNT.setTimer(stack, gunIndex, 0);
            }
        }
    }
}

