/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.special;

import com.hbm.dim.CelestialBody;
import com.hbm.dim.SolarSystem;
import com.hbm.items.special.ItemBedrockOreNew;
import com.hbm.items.tool.ItemOreDensityScanner;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class ItemBedrockOreBase
extends Item {
    private static Map<Long, NoiseGeneratorPerlin> generators = new HashMap<Long, NoiseGeneratorPerlin>();

    public ItemBedrockOreBase() {
        this.func_77627_a(true);
    }

    public static double getOreAmount(ItemStack stack, ItemBedrockOreNew.CelestialBedrockOreType type) {
        if (!stack.func_77942_o()) {
            return 1.0;
        }
        NBTTagCompound data = stack.func_77978_p();
        return data.func_74769_h(type.suffix);
    }

    public static SolarSystem.Body getOreBody(ItemStack stack) {
        if (stack.func_77960_j() >= SolarSystem.Body.values().length || stack.func_77960_j() <= 0) {
            return SolarSystem.Body.KERBIN;
        }
        return SolarSystem.Body.values()[stack.func_77960_j()];
    }

    public static void setOreAmount(World world, ItemStack stack, int x, int z, double mult) {
        if (!stack.func_77942_o()) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagCompound data = stack.func_77978_p();
        SolarSystem.Body body = CelestialBody.getEnum(world);
        stack.func_77964_b(body.ordinal());
        for (ItemBedrockOreNew.CelestialBedrockOreType type : ItemBedrockOreNew.CelestialBedrockOre.get((SolarSystem.Body)body).types) {
            data.func_74780_a(type.suffix, ItemBedrockOreBase.getOreLevel(world, x, z, type));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        SolarSystem.Body body = ItemBedrockOreBase.getOreBody(stack);
        list.add("Mined on: " + I18nUtil.resolveKey("body." + body.name, new Object[0]));
        for (ItemBedrockOreNew.CelestialBedrockOreType type : ItemBedrockOreNew.CelestialBedrockOre.get((SolarSystem.Body)body).types) {
            double amount = ItemBedrockOreBase.getOreAmount(stack, type);
            String typeName = StatCollector.func_74837_a((String)("item.bedrock_ore.type." + type.suffix + ".name"), (Object[])new Object[0]);
            list.add(typeName + ": " + (double)((int)(amount * 100.0)) / 100.0 + " (" + ItemOreDensityScanner.getColor(amount) + StatCollector.func_74837_a((String)ItemOreDensityScanner.translateDensity(amount), (Object[])new Object[0]) + EnumChatFormatting.GRAY + ")");
        }
    }

    public static double getOreLevel(World world, int x, int z, ItemBedrockOreNew.CelestialBedrockOreType type) {
        long seed = world.func_72905_C() + (long)world.field_73011_w.field_76574_g;
        NoiseGeneratorPerlin level = ItemBedrockOreBase.getGenerator(seed);
        NoiseGeneratorPerlin ore = ItemBedrockOreBase.getGenerator(seed - 4096L + (long)type.index);
        double scale = 0.01;
        return MathHelper.func_151237_a((double)(Math.abs(level.func_151601_a((double)x * scale, (double)z * scale) * ore.func_151601_a((double)x * scale, (double)z * scale)) * 0.05), (double)0.0, (double)2.0);
    }

    private static NoiseGeneratorPerlin getGenerator(long seed) {
        return generators.computeIfAbsent(seed, key -> new NoiseGeneratorPerlin(new Random(seed), 4));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (SolarSystem.Body body : SolarSystem.Body.values()) {
            if (body == SolarSystem.Body.ORBIT) continue;
            list.add(new ItemStack(item, 1, body.ordinal()));
        }
    }
}

