/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockPWR;
import com.hbm.inventory.gui.GUIScreenSlicePrinter;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IGUIProvider;
import com.hbm.tileentity.machine.TileEntityPWRController;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemPWRPrinter
extends Item
implements IGUIProvider {
    private static int x1;
    private static int y1;
    private static int z1;
    private static int x2;
    private static int y2;
    private static int z2;
    private static Block[] blockSync;
    private static ForgeDirection dir;
    private HashSet<BlockPos> fill = new HashSet();
    private static HashSet<Block> whitelist;

    public static void serialize(World world, ByteBuf buf) {
        buf.writeInt(x1);
        buf.writeInt(y1);
        buf.writeInt(z1);
        buf.writeInt(x2);
        buf.writeInt(y2);
        buf.writeInt(z2);
        buf.writeInt(dir.ordinal());
        for (Block block : blockSync) {
            buf.writeInt(Block.func_149682_b((Block)block));
        }
        blockSync = null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void deserialize(World world, ByteBuf buf) {
        x1 = buf.readInt();
        y1 = buf.readInt();
        z1 = buf.readInt();
        x2 = buf.readInt();
        y2 = buf.readInt();
        z2 = buf.readInt();
        dir = ForgeDirection.values()[buf.readInt()];
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    Block block = Block.func_149729_e((int)buf.readInt());
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (!(tile instanceof BlockPWR.TileEntityBlockPWR)) continue;
                    ((BlockPWR.TileEntityBlockPWR)tile).block = block;
                }
            }
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemPWRPrinter) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)0, (int)0, (int)0);
        }
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int i, float f0, float f1, float f2) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (!(tile instanceof TileEntityPWRController)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntityPWRController pwr = (TileEntityPWRController)tile;
        this.syncAndScreenshot(world, pwr);
        return true;
    }

    public void syncAndScreenshot(World world, TileEntityPWRController pwr) {
        this.findBounds(world, pwr);
        int sizeX = x2 - x1 + 1;
        int sizeY = y2 - y1 + 1;
        int sizeZ = z2 - z1 + 1;
        blockSync = new Block[sizeX * sizeY * sizeZ];
        int i = 0;
        for (int x = x1; x <= x2; ++x) {
            for (int y = y1; y <= y2; ++y) {
                for (int z = z1; z <= z2; ++z) {
                    TileEntity tile = world.func_147438_o(x, y, z);
                    if (tile instanceof BlockPWR.TileEntityBlockPWR) {
                        ItemPWRPrinter.blockSync[i] = ((BlockPWR.TileEntityBlockPWR)tile).block;
                    }
                    ++i;
                }
            }
        }
        pwr.isPrinting = true;
    }

    public void findBounds(World world, TileEntityPWRController pwr) {
        dir = ForgeDirection.getOrientation((int)world.func_72805_g(pwr.field_145851_c, pwr.field_145848_d, pwr.field_145849_e)).getOpposite();
        this.fill.clear();
        this.fill.add(new BlockPos(pwr.field_145851_c, pwr.field_145848_d, pwr.field_145849_e));
        x1 = x2 = pwr.field_145851_c;
        y1 = y2 = pwr.field_145848_d;
        z1 = z2 = pwr.field_145849_e;
        this.floodFill(world, pwr.field_145851_c + ItemPWRPrinter.dir.offsetX, pwr.field_145848_d, pwr.field_145849_e + ItemPWRPrinter.dir.offsetZ);
    }

    public void floodFill(World world, int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        if (this.fill.contains(pos)) {
            return;
        }
        if (world.func_147439_a(x, y, z) instanceof BlockPWR) {
            this.fill.add(pos);
            x1 = Math.min(x1, x);
            y1 = Math.min(y1, y);
            z1 = Math.min(z1, z);
            x2 = Math.max(x2, x);
            y2 = Math.max(y2, y);
            z2 = Math.max(z2, z);
            this.floodFill(world, x + 1, y, z);
            this.floodFill(world, x - 1, y, z);
            this.floodFill(world, x, y + 1, z);
            this.floodFill(world, x, y - 1, z);
            this.floodFill(world, x, y, z + 1);
            this.floodFill(world, x, y, z - 1);
        }
    }

    @Override
    public Container provideContainer(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public Object provideGUI(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return new GUIScreenSlicePrinter(x1, y1, z1, x2, y2, z2, dir, whitelist);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        list.add("Use on a constructed PWR controller to generate construction diagrams");
    }

    static {
        whitelist = new HashSet<Block>(){
            {
                this.add(ModBlocks.pwr_block);
                this.add(ModBlocks.pwr_controller);
            }
        };
    }
}

