/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.material.MaterialShapes;
import com.hbm.inventory.material.Mats;
import com.hbm.inventory.material.NTMMaterial;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraftforge.oredict.OreDictionary;

public class ItemMold
extends Item {
    public static List<Mold> molds = new ArrayList<Mold>();
    public static HashMap<Integer, Mold> moldById = new HashMap();
    public HashMap<NTMMaterial, ItemStack> blockOverrides = new HashMap();
    protected IIcon[] icons;
    public static int nextOrder = 0;

    public ItemMold() {
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.blockOverrides.put(Mats.MAT_STONE, new ItemStack(Blocks.field_150348_b));
        this.blockOverrides.put(Mats.MAT_OBSIDIAN, new ItemStack(Blocks.field_150343_Z));
        int S = 0;
        int L = 1;
        this.registerMold(new MoldShape(0, S, "nugget", MaterialShapes.NUGGET));
        this.registerMold(new MoldShape(1, S, "billet", MaterialShapes.BILLET));
        this.registerMold(new MoldShape(2, S, "ingot", MaterialShapes.INGOT));
        this.registerMold(new MoldShape(3, S, "plate", MaterialShapes.PLATE));
        this.registerMold(new MoldShape(4, S, "wire", MaterialShapes.WIRE, 8));
        this.registerMold(new MoldShape(19, S, "plate_cast", MaterialShapes.CASTPLATE));
        this.registerMold(new MoldShape(20, S, "wire_dense", MaterialShapes.DENSEWIRE));
        this.registerMold(new MoldMulti(5, S, "blade", MaterialShapes.INGOT.q(3), Mats.MAT_TITANIUM, new ItemStack(ModItems.blade_titanium), Mats.MAT_TUNGSTEN, new ItemStack(ModItems.blade_tungsten), Mats.MAT_STAINLESS, new ItemStack(ModItems.blade_syngas)));
        this.registerMold(new MoldMulti(6, S, "blades", MaterialShapes.INGOT.q(4), Mats.MAT_STEEL, new ItemStack(ModItems.blades_steel), Mats.MAT_TITANIUM, new ItemStack(ModItems.blades_titanium), Mats.MAT_ALLOY, new ItemStack(ModItems.blades_advanced_alloy)));
        this.registerMold(new MoldMulti(7, S, "stamp", MaterialShapes.INGOT.q(4), Mats.MAT_STONE, new ItemStack(ModItems.stamp_stone_flat), Mats.MAT_IRON, new ItemStack(ModItems.stamp_iron_flat), Mats.MAT_STEEL, new ItemStack(ModItems.stamp_steel_flat), Mats.MAT_TITANIUM, new ItemStack(ModItems.stamp_titanium_flat), Mats.MAT_OBSIDIAN, new ItemStack(ModItems.stamp_obsidian_flat)));
        this.registerMold(new MoldShape(8, S, "shell", MaterialShapes.SHELL));
        this.registerMold(new MoldShape(9, S, "pipe", MaterialShapes.PIPE));
        this.registerMold(new MoldShape(10, L, "ingots", MaterialShapes.INGOT, 9));
        this.registerMold(new MoldShape(11, L, "plates", MaterialShapes.PLATE, 9));
        this.registerMold(new MoldShape(21, L, "wires_dense", MaterialShapes.DENSEWIRE, 9));
        this.registerMold(new MoldBlock(12, L, "block", MaterialShapes.BLOCK));
        this.registerMold(new MoldMulti(16, S, "c9", MaterialShapes.PLATE.q(1, 4), Mats.MAT_GUNMETAL, OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.SMALL), Mats.MAT_WEAPONSTEEL, OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.SMALL_STEEL)));
        this.registerMold(new MoldMulti(17, S, "c50", MaterialShapes.PLATE.q(1, 2), Mats.MAT_GUNMETAL, OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.LARGE), Mats.MAT_WEAPONSTEEL, OreDictManager.DictFrame.fromOne(ModItems.casing, (Enum)ItemEnums.EnumCasingType.LARGE_STEEL)));
        this.registerMold(new MoldShape(22, S, "barrel_light", MaterialShapes.LIGHTBARREL));
        this.registerMold(new MoldShape(23, S, "barrel_heavy", MaterialShapes.HEAVYBARREL));
        this.registerMold(new MoldShape(24, S, "receiver_light", MaterialShapes.LIGHTRECEIVER));
        this.registerMold(new MoldShape(25, S, "receiver_heavy", MaterialShapes.HEAVYRECEIVER));
        this.registerMold(new MoldShape(26, S, "mechanism", MaterialShapes.MECHANISM));
        this.registerMold(new MoldShape(27, S, "stock", MaterialShapes.STOCK));
        this.registerMold(new MoldShape(28, S, "grip", MaterialShapes.GRIP));
    }

    public void registerMold(Mold mold) {
        molds.add(mold);
        moldById.put(mold.id, mold);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < molds.size(); ++i) {
            Mold mold = molds.get(i);
            list.add(new ItemStack(item, 1, mold.id));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister reg) {
        this.icons = new IIcon[molds.size()];
        for (int i = 0; i < molds.size(); ++i) {
            Mold mold = molds.get(i);
            this.icons[i] = reg.func_94245_a("hbm:mold_" + mold.name);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        Mold mold = moldById.get(meta);
        if (mold != null) {
            return this.icons[mold.order];
        }
        return this.icons[0];
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        Mold mold = this.getMold(stack);
        list.add(EnumChatFormatting.YELLOW + mold.getTitle());
        if (mold.size == 0) {
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey(ModBlocks.foundry_mold.func_149739_a() + ".name", new Object[0]));
        }
        if (mold.size == 1) {
            list.add(EnumChatFormatting.RED + I18nUtil.resolveKey(ModBlocks.foundry_basin.func_149739_a() + ".name", new Object[0]));
        }
    }

    public Mold getMold(ItemStack stack) {
        Mold mold = moldById.get(stack.func_77960_j());
        return mold != null ? mold : molds.get(0);
    }

    public class MoldMulti
    extends Mold {
        public HashMap<NTMMaterial, ItemStack> map;
        public int amount;
        public int stacksize;

        public MoldMulti(int id, int size, String name, int amount, Object ... inputs) {
            super(id, size, name);
            this.map = new HashMap();
            this.amount = amount;
            for (int i = 0; i < inputs.length; i += 2) {
                this.map.put((NTMMaterial)inputs[i], (ItemStack)inputs[i + 1]);
                if (i != 0) continue;
                this.stacksize = ((ItemStack)inputs[i + 1]).field_77994_a;
            }
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            ItemStack out = this.map.get(mat);
            if (out != null) {
                return out.func_77946_l();
            }
            return out;
        }

        @Override
        public int getCost() {
            return this.amount;
        }

        @Override
        public String getTitle() {
            return I18nUtil.resolveKey("shape." + this.name, new Object[0]) + " x" + this.stacksize;
        }
    }

    public class MoldSingle
    extends Mold {
        public ItemStack out;
        public NTMMaterial mat;
        public int amount;

        public MoldSingle(int id, int size, String name, ItemStack out, NTMMaterial mat, int amount) {
            super(id, size, name);
            this.out = out;
            this.mat = mat;
            this.amount = amount;
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            return this.mat == mat ? this.out.func_77946_l() : null;
        }

        @Override
        public int getCost() {
            return this.amount;
        }

        @Override
        public String getTitle() {
            return this.out.func_82833_r() + " x" + this.out.field_77994_a;
        }
    }

    public class MoldBlock
    extends MoldShape {
        public MoldBlock(int id, int size, String name, MaterialShapes shape) {
            super(id, size, name, shape);
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            ItemStack override = ItemMold.this.blockOverrides.get(mat);
            if (override != null) {
                return override.func_77946_l();
            }
            return super.getOutput(mat);
        }
    }

    public class MoldShape
    extends Mold {
        public MaterialShapes shape;
        public int amount;

        public MoldShape(int id, int size, String name, MaterialShapes shape) {
            this(id, size, name, shape, 1);
        }

        public MoldShape(int id, int size, String name, MaterialShapes shape, int amount) {
            super(id, size, name);
            this.shape = shape;
            this.amount = amount;
        }

        @Override
        public ItemStack getOutput(NTMMaterial mat) {
            for (String name : mat.names) {
                String od = this.shape.name() + name;
                ArrayList ores = OreDictionary.getOres((String)od);
                if (ores.isEmpty()) continue;
                for (ItemStack ore : ores) {
                    if (!Item.field_150901_e.func_148750_c((Object)ore.func_77973_b()).startsWith("hbm")) continue;
                    ItemStack copy = ore.func_77946_l();
                    copy.field_77994_a = this.amount;
                    return copy;
                }
                ItemStack copy = ((ItemStack)ores.get(0)).func_77946_l();
                copy.field_77994_a = this.amount;
                return copy;
            }
            return null;
        }

        @Override
        public int getCost() {
            return this.shape.q(this.amount);
        }

        @Override
        public String getTitle() {
            return I18nUtil.resolveKey("shape." + this.shape.name(), new Object[0]) + " x" + this.amount;
        }
    }

    public abstract class Mold {
        public int order = nextOrder++;
        public int id;
        public int size;
        public String name;

        public Mold(int id, int size, String name) {
            this.id = id;
            this.size = size;
            this.name = name;
        }

        public abstract ItemStack getOutput(NTMMaterial var1);

        public abstract int getCost();

        public abstract String getTitle();
    }
}

