/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.items.armor;

import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.interfaces.NotableComments;
import com.hbm.items.ModItems;
import com.hbm.items.armor.IArmorDisableModel;
import com.hbm.util.ContaminationUtil;
import com.hbm.util.ShadyUtil;
import com.hbm.util.i18n.I18nUtil;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import org.lwjgl.opengl.GL11;

@NotableComments
public class ArmorFSB
extends ItemArmor
implements IArmorDisableModel {
    private String texture = "";
    private ResourceLocation overlay = null;
    public List<PotionEffect> effects = new ArrayList<PotionEffect>();
    public boolean noHelmet = false;
    public boolean vats = false;
    public boolean thermal = false;
    public boolean geigerSound = false;
    public boolean customGeiger = false;
    public boolean hardLanding = false;
    public int dashCount = 0;
    public int stepSize = 0;
    public String step;
    public String jump;
    public String fall;
    public boolean canSeal;
    private HashSet<IArmorDisableModel.EnumPlayerPart> hidden = new HashSet();
    private boolean needsFullSet = false;

    public ArmorFSB(ItemArmor.ArmorMaterial material, int slot, String texture) {
        super(material, 0, slot);
        this.texture = texture;
        this.func_111206_d("hbm:armor");
    }

    public ArmorFSB addEffect(PotionEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ArmorFSB setNoHelmet(boolean noHelmet) {
        this.noHelmet = noHelmet;
        return this;
    }

    public ArmorFSB enableVATS(boolean vats) {
        this.vats = vats;
        return this;
    }

    public ArmorFSB enableThermalSight(boolean thermal) {
        this.thermal = thermal;
        return this;
    }

    public ArmorFSB setHasGeigerSound(boolean geiger) {
        this.geigerSound = geiger;
        return this;
    }

    public ArmorFSB setHasCustomGeiger(boolean geiger) {
        this.customGeiger = geiger;
        return this;
    }

    public ArmorFSB setHasHardLanding(boolean hardLanding) {
        this.hardLanding = hardLanding;
        return this;
    }

    public ArmorFSB setDashCount(int dashCount) {
        this.dashCount = dashCount;
        return this;
    }

    public ArmorFSB setStepSize(int stepSize) {
        this.stepSize = stepSize;
        return this;
    }

    public ArmorFSB setStep(String step) {
        this.step = step;
        return this;
    }

    public ArmorFSB setJump(String jump) {
        this.jump = jump;
        return this;
    }

    public ArmorFSB setFall(String fall) {
        this.fall = fall;
        return this;
    }

    public ArmorFSB setOverlay(String path) {
        this.overlay = new ResourceLocation(path);
        return this;
    }

    public ArmorFSB setSealed(boolean canSeal) {
        this.canSeal = canSeal;
        return this;
    }

    public ArmorFSB cloneStats(ArmorFSB original) {
        this.effects = original.effects;
        this.noHelmet = original.noHelmet;
        this.vats = original.vats;
        this.thermal = original.thermal;
        this.geigerSound = original.geigerSound;
        this.customGeiger = original.customGeiger;
        this.hardLanding = original.hardLanding;
        this.dashCount = original.dashCount;
        this.stepSize = original.stepSize;
        this.step = original.step;
        this.jump = original.jump;
        this.fall = original.fall;
        this.canSeal = original.canSeal;
        return this;
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String layer) {
        return this.texture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        ArrayList<String> toAdd = new ArrayList<String>();
        if (this.canSeal) {
            list.add(EnumChatFormatting.BLUE + "" + I18nUtil.format("armor.canSeal", new Object[0]));
        }
        if (!this.effects.isEmpty()) {
            ArrayList<String> potionList = new ArrayList<String>();
            for (PotionEffect effect : this.effects) {
                potionList.add(I18nUtil.format(Potion.field_76425_a[effect.func_76456_a()].func_76393_a(), new Object[0]));
            }
            toAdd.add(EnumChatFormatting.AQUA + String.join((CharSequence)", ", potionList));
        }
        if (this.geigerSound) {
            toAdd.add(EnumChatFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerSound", new Object[0]));
        }
        if (this.customGeiger) {
            toAdd.add(EnumChatFormatting.GOLD + "  " + I18nUtil.resolveKey("armor.geigerHUD", new Object[0]));
        }
        if (this.vats) {
            toAdd.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.vats", new Object[0]));
        }
        if (this.thermal) {
            toAdd.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.thermal", new Object[0]));
        }
        if (this.hardLanding) {
            toAdd.add(EnumChatFormatting.RED + "  " + I18nUtil.resolveKey("armor.hardLanding", new Object[0]));
        }
        if (this.stepSize != 0) {
            toAdd.add(EnumChatFormatting.BLUE + "  " + I18nUtil.resolveKey("armor.stepSize", this.stepSize));
        }
        if (this.dashCount > 0) {
            toAdd.add(EnumChatFormatting.AQUA + "  " + I18nUtil.resolveKey("armor.dash", this.dashCount));
        }
        if (!toAdd.isEmpty()) {
            list.add(EnumChatFormatting.GOLD + I18nUtil.resolveKey("armor.fullSetBonus", new Object[0]));
            list.addAll(toAdd);
        }
    }

    public static boolean hasFSBArmor(EntityPlayer player) {
        ItemStack plate = player.field_71071_by.field_70460_b[2];
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (int i = 0; i < (noHelmet ? 3 : 4); ++i) {
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() != chestplate.func_82812_d()) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).isArmorEnabled(armor)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean hasFSBArmorIgnoreCharge(EntityPlayer player) {
        ItemStack plate = player.field_71071_by.field_70460_b[2];
        if (plate != null && plate.func_77973_b() instanceof ArmorFSB) {
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            boolean noHelmet = chestplate.noHelmet;
            for (int i = 0; i < (noHelmet ? 3 : 4); ++i) {
                ItemStack armor = player.field_71071_by.field_70460_b[i];
                if (armor == null || !(armor.func_77973_b() instanceof ArmorFSB)) {
                    return false;
                }
                if (((ArmorFSB)armor.func_77973_b()).func_82812_d() == chestplate.func_82812_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void handleTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        boolean step = true;
        if (player.func_110124_au().equals(ShadyUtil.the_NCR) || player.func_110124_au().equals(ShadyUtil.Barnaby99_x)) {
            step = false;
            if (player.field_70170_p.field_72995_K && player.field_70122_E) {
                ArmorFSB.steppy(player, "hbm:step.powered");
            }
        }
        if (ArmorFSB.hasFSBArmor(player)) {
            ItemStack plate = player.field_71071_by.field_70460_b[2];
            ArmorFSB chestplate = (ArmorFSB)plate.func_77973_b();
            if (!chestplate.effects.isEmpty()) {
                for (PotionEffect i : chestplate.effects) {
                    player.func_70690_d(new PotionEffect(i.func_76456_a(), i.func_76459_b(), i.func_76458_c(), true));
                }
            }
            if (step && chestplate.step != null && player.field_70170_p.field_72995_K && player.field_70122_E) {
                ArmorFSB.steppy(player, chestplate.step);
            }
        }
    }

    public static void steppy(EntityPlayer player, String sound) {
        try {
            int pz;
            int py;
            int px;
            Block block;
            Field nextStepDistance = ReflectionHelper.findField(Entity.class, (String[])new String[]{"nextStepDistance", "field_70150_b"});
            Field distanceWalkedOnStepModified = ReflectionHelper.findField(Entity.class, (String[])new String[]{"distanceWalkedOnStepModified", "field_82151_R"});
            if (player.getEntityData().func_74760_g("hfr_nextStepDistance") == 0.0f) {
                player.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(player));
            }
            if ((block = player.field_70170_p.func_147439_a(px = MathHelper.func_76128_c((double)player.field_70165_t), py = MathHelper.func_76128_c((double)(player.field_70163_u - 0.2 - (double)player.field_70129_M)), pz = MathHelper.func_76128_c((double)player.field_70161_v))).func_149688_o() != Material.field_151579_a && player.getEntityData().func_74760_g("hfr_nextStepDistance") <= distanceWalkedOnStepModified.getFloat(player)) {
                player.func_85030_a(sound, 1.0f, 1.0f);
            }
            player.getEntityData().func_74776_a("hfr_nextStepDistance", nextStepDistance.getFloat(player));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleJump(EntityPlayer player) {
        if (ArmorFSB.hasFSBArmor(player)) {
            ArmorFSB chestplate = (ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b();
            if (chestplate.jump != null) {
                player.func_85030_a(chestplate.jump, 1.0f, 1.0f);
            }
        }
    }

    public void handleFall(EntityPlayer player, float fallDistance) {
        if (ArmorFSB.hasFSBArmor(player)) {
            ArmorFSB chestplate = (ArmorFSB)player.field_71071_by.field_70460_b[2].func_77973_b();
            if (chestplate.hardLanding && fallDistance > 10.0f) {
                List entities = player.field_70170_p.func_72839_b((Entity)player, player.field_70121_D.func_72314_b(3.0, 0.0, 3.0));
                for (Entity e : entities) {
                    Vec3 vec;
                    if (e instanceof EntityItem || !((vec = Vec3.func_72443_a((double)(player.field_70165_t - e.field_70165_t), (double)0.0, (double)(player.field_70161_v - e.field_70161_v))).func_72433_c() < 3.0)) continue;
                    double intensity = 3.0 - vec.func_72433_c();
                    e.field_70159_w += vec.field_72450_a * intensity * -2.0;
                    e.field_70181_x += 0.1 * intensity;
                    e.field_70179_y += vec.field_72449_c * intensity * -2.0;
                    e.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player).func_76348_h(), (float)(intensity * 10.0));
                }
            }
            if (chestplate.fall != null) {
                player.func_85030_a(chestplate.fall, 1.0f, 1.0f);
            }
        }
    }

    public void onArmorTick(World world, EntityPlayer entity, ItemStack stack) {
        if (this.field_77881_a != 1) {
            return;
        }
        if (!ArmorFSB.hasFSBArmor(entity) || !this.geigerSound) {
            return;
        }
        if (entity.field_71071_by.func_146028_b(ModItems.geiger_counter) || entity.field_71071_by.func_146028_b(ModItems.dosimeter)) {
            return;
        }
        if (world.func_82737_E() % 5L == 0L) {
            float mod = ContaminationUtil.calculateRadiationMod((EntityLivingBase)entity);
            float x = HbmLivingProps.getRadBuf((EntityLivingBase)entity) * mod;
            if ((double)x > 1.0E-5) {
                int r;
                if (world.field_73012_v.nextFloat() > x) {
                    return;
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                if (x < 1.0f) {
                    list.add(0);
                }
                if (x < 5.0f) {
                    list.add(0);
                }
                if (x < 10.0f) {
                    list.add(1);
                }
                if (x > 5.0f && x < 15.0f) {
                    list.add(2);
                }
                if (x > 10.0f && x < 20.0f) {
                    list.add(3);
                }
                if (x > 15.0f && x < 25.0f) {
                    list.add(4);
                }
                if (x > 20.0f && x < 30.0f) {
                    list.add(5);
                }
                if (x > 25.0f) {
                    list.add(6);
                }
                if ((r = ((Integer)list.get(world.field_73012_v.nextInt(list.size()))).intValue()) > 0) {
                    world.func_72956_a((Entity)entity, "hbm:item.geiger" + r, 1.0f, 1.0f);
                }
            }
        }
    }

    public static int check(World world, int x, int y, int z) {
        int rads = (int)Math.ceil(ChunkRadiationManager.proxy.getRadiation(world, x, y, z));
        return rads;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleOverlay(RenderGameOverlayEvent.Pre event, EntityPlayer player) {
    }

    public boolean isArmorEnabled(ItemStack stack) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHelmetOverlay(ItemStack stack, EntityPlayer player, ScaledResolution resolution, float partialTicks, boolean hasScreen, int mouseX, int mouseY) {
        if (this.overlay == null) {
            return;
        }
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3008);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.overlay);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a(0.0, (double)resolution.func_78328_b(), -90.0, 0.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), (double)resolution.func_78328_b(), -90.0, 1.0, 1.0);
        tessellator.func_78374_a((double)resolution.func_78326_a(), 0.0, -90.0, 1.0, 0.0);
        tessellator.func_78374_a(0.0, 0.0, -90.0, 0.0, 0.0);
        tessellator.func_78381_a();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3008);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public ArmorFSB hides(IArmorDisableModel.EnumPlayerPart ... parts) {
        Collections.addAll(this.hidden, parts);
        return this;
    }

    public ArmorFSB setFullSetForHide() {
        this.needsFullSet = true;
        return this;
    }

    @Override
    public boolean disablesPart(EntityPlayer player, ItemStack stack, IArmorDisableModel.EnumPlayerPart part) {
        return this.hidden.contains((Object)part) && (!this.needsFullSet || ArmorFSB.hasFSBArmorIgnoreCharge(player));
    }

    public void handleAttack(LivingAttackEvent event) {
    }

    public void handleHurt(LivingHurtEvent event) {
    }

    public static void setupRenderInv() {
        GL11.glTranslated((double)0.0, (double)-1.5, (double)0.0);
        GL11.glScaled((double)3.25, (double)3.25, (double)3.25);
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glRotated((double)-135.0, (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)-20.0, (double)1.0, (double)0.0, (double)0.0);
    }

    public static void setupRenderNonInv() {
        GL11.glRotated((double)180.0, (double)1.0, (double)0.0, (double)0.0);
        GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
        GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
    }

    public static void renderStandard(IModelCustom model, int armorType, ResourceLocation helmetTex, ResourceLocation chestTex, ResourceLocation armTex, ResourceLocation legTex, String helmet, String chest, String leftArm, String rightArm, String leftLeg, String rightLeg, String leftBoot, String rightBoot) {
        GL11.glShadeModel((int)7425);
        if (armorType == 0) {
            GL11.glScaled((double)0.3125, (double)0.3125, (double)0.3125);
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(helmetTex);
            for (String s : helmet.split(",")) {
                model.renderPart(s);
            }
        }
        if (armorType == 1) {
            GL11.glScaled((double)0.225, (double)0.225, (double)0.225);
            GL11.glTranslated((double)0.0, (double)-10.0, (double)0.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(chestTex);
            for (String s : chest.split(",")) {
                model.renderPart(s);
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.1);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(armTex);
            for (String s : leftArm.split(",")) {
                model.renderPart(s);
            }
            for (String s : rightArm.split(",")) {
                model.renderPart(s);
            }
        }
        if (armorType == 2) {
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            GL11.glTranslated((double)0.0, (double)-20.0, (double)0.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(legTex);
            GL11.glDisable((int)2884);
            for (String s : leftLeg.split(",")) {
                model.renderPart(s);
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.1);
            for (String s : rightLeg.split(",")) {
                model.renderPart(s);
            }
            GL11.glEnable((int)2884);
        }
        if (armorType == 3) {
            GL11.glScaled((double)0.25, (double)0.25, (double)0.25);
            GL11.glTranslated((double)0.0, (double)-22.0, (double)0.0);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(legTex);
            GL11.glDisable((int)2884);
            for (String s : leftBoot.split(",")) {
                model.renderPart(s);
            }
            GL11.glTranslated((double)0.0, (double)0.0, (double)0.1);
            for (String s : rightBoot.split(",")) {
                model.renderPart(s);
            }
            GL11.glEnable((int)2884);
        }
        GL11.glShadeModel((int)7424);
    }
}

