/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.trait.FT_Flammable;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SolidificationRecipes
extends SerializableRecipe {
    public static final int SF_OIL = 200;
    public static final int SF_CRACK = 200;
    public static final int SF_HEAVY = 150;
    public static final int SF_BITUMEN = 100;
    public static final int SF_SMEAR = 100;
    public static final int SF_HEATING = 50;
    public static final int SF_RECLAIMED = 100;
    public static final int SF_PETROIL = 125;
    public static final int SF_LUBE = 100;
    public static final int SF_NAPH = 150;
    public static final int SF_DIESEL = 200;
    public static final int SF_LIGHT = 225;
    public static final int SF_KEROSENE = 275;
    public static final int SF_GAS = 375;
    public static final int SF_PETROLEUM = 300;
    public static final int SF_LPG = 150;
    public static final int SF_BIOGAS = 1750;
    public static final int SF_BIOFUEL = 750;
    public static final int SF_COALOIL = 200;
    public static final int SF_CREOSOTE = 200;
    public static final int SF_WOOD = 1000;
    public static final int SF_AROMA = 1000;
    public static final int SF_UNSAT = 1000;
    public static HashMap<FluidType, Tuple.Pair<Integer, ItemStack>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        SolidificationRecipes.registerRecipe(Fluids.WATER, 1000, Blocks.field_150432_aD);
        SolidificationRecipes.registerRecipe(Fluids.LAVA, 1000, Blocks.field_150343_Z);
        SolidificationRecipes.registerRecipe(Fluids.MERCURY, 125, ModItems.ingot_mercury);
        SolidificationRecipes.registerRecipe(Fluids.BIOGAS, 250, ModItems.biomass_compressed);
        SolidificationRecipes.registerRecipe(Fluids.SALIENT, 1280, new ItemStack(ModItems.bio_wafer, 8));
        SolidificationRecipes.registerRecipe(Fluids.BLOOD, 1290, new ItemStack(ModItems.flesh_wafer, 5));
        SolidificationRecipes.registerRecipe(Fluids.ENDERJUICE, 100, Items.field_151079_bi);
        SolidificationRecipes.registerRecipe(Fluids.WATZ, 1000, ModItems.ingot_mud);
        SolidificationRecipes.registerRecipe(Fluids.REDMUD, 450, Items.field_151042_j);
        SolidificationRecipes.registerRecipe(Fluids.SODIUM, 100, ModItems.powder_sodium);
        SolidificationRecipes.registerRecipe(Fluids.LEAD, 100, ModItems.ingot_lead);
        SolidificationRecipes.registerRecipe(Fluids.SLOP, 250, ModBlocks.ore_oil_sand);
        SolidificationRecipes.registerRecipe(Fluids.CARBONDIOXIDE, 1000, ModBlocks.dry_ice);
        SolidificationRecipes.registerRecipe(Fluids.AQUEOUS_NICKEL, 500, ModItems.nickel_salts);
        SolidificationRecipes.registerRecipe(Fluids.VINYL, 1000, ModItems.ingot_pvc);
        SolidificationRecipes.registerRecipe(Fluids.OIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(Fluids.CRACKOIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK));
        SolidificationRecipes.registerRecipe(Fluids.COALOIL, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL));
        SolidificationRecipes.registerRecipe(Fluids.HEAVYOIL, 150, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(Fluids.HEAVYOIL_VACUUM, 150, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(Fluids.BITUMEN, 100, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRUDE));
        SolidificationRecipes.registerRecipe(Fluids.COALCREOSOTE, 200, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.COAL));
        SolidificationRecipes.registerRecipe(Fluids.WOODOIL, 1000, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.WOOD));
        SolidificationRecipes.registerRecipe(Fluids.LUBRICANT, 100, OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN));
        SolidificationRecipes.registerRecipe(Fluids.BALEFIRE, 250, ModItems.solid_fuel_bf);
        SolidificationRecipes.registerSFAuto(Fluids.SMEAR);
        SolidificationRecipes.registerSFAuto(Fluids.HEATINGOIL);
        SolidificationRecipes.registerSFAuto(Fluids.HEATINGOIL_VACUUM);
        SolidificationRecipes.registerSFAuto(Fluids.RECLAIMED);
        SolidificationRecipes.registerSFAuto(Fluids.PETROIL);
        SolidificationRecipes.registerSFAuto(Fluids.NAPHTHA);
        SolidificationRecipes.registerSFAuto(Fluids.NAPHTHA_CRACK);
        SolidificationRecipes.registerSFAuto(Fluids.DIESEL);
        SolidificationRecipes.registerSFAuto(Fluids.DIESEL_REFORM);
        SolidificationRecipes.registerSFAuto(Fluids.DIESEL_CRACK);
        SolidificationRecipes.registerSFAuto(Fluids.DIESEL_CRACK_REFORM);
        SolidificationRecipes.registerSFAuto(Fluids.LIGHTOIL);
        SolidificationRecipes.registerSFAuto(Fluids.LIGHTOIL_CRACK);
        SolidificationRecipes.registerSFAuto(Fluids.LIGHTOIL_VACUUM);
        SolidificationRecipes.registerSFAuto(Fluids.KEROSENE);
        SolidificationRecipes.registerSFAuto(Fluids.KEROSENE_REFORM);
        SolidificationRecipes.registerSFAuto(Fluids.SOURGAS);
        SolidificationRecipes.registerSFAuto(Fluids.REFORMGAS);
        SolidificationRecipes.registerSFAuto(Fluids.SYNGAS);
        SolidificationRecipes.registerSFAuto(Fluids.PETROLEUM);
        SolidificationRecipes.registerSFAuto(Fluids.LPG);
        SolidificationRecipes.registerSFAuto(Fluids.BIOFUEL);
        SolidificationRecipes.registerSFAuto(Fluids.AROMATICS);
        SolidificationRecipes.registerSFAuto(Fluids.UNSATURATEDS);
        SolidificationRecipes.registerSFAuto(Fluids.REFORMATE);
        SolidificationRecipes.registerSFAuto(Fluids.XYLENE);
        SolidificationRecipes.registerSFAuto(Fluids.BALEFIRE, 24000000L, ModItems.solid_fuel_bf);
    }

    private static void registerSFAuto(FluidType fluid) {
        SolidificationRecipes.registerSFAuto(fluid, 1440000L, ModItems.solid_fuel);
    }

    private static void registerSFAuto(FluidType fluid, long tuPerSF, Item fuel) {
        double penalty = 1.25;
        long tuPerBucket = fluid.getTrait(FT_Flammable.class).getHeatEnergy();
        int mB = (int)((double)(tuPerSF * 1000L) * penalty / (double)tuPerBucket);
        if (mB > 10000) {
            mB -= mB % 1000;
        } else if (mB > 1000) {
            mB -= mB % 100;
        } else if (mB > 100) {
            mB -= mB % 10;
        }
        mB = Math.max(mB, 1);
        SolidificationRecipes.registerRecipe(fluid, mB, fuel);
    }

    private static void registerRecipe(FluidType type, int quantity, Item output) {
        SolidificationRecipes.registerRecipe(type, quantity, new ItemStack(output));
    }

    private static void registerRecipe(FluidType type, int quantity, Block output) {
        SolidificationRecipes.registerRecipe(type, quantity, new ItemStack(output));
    }

    private static void registerRecipe(FluidType type, int quantity, ItemStack output) {
        recipes.put(type, new Tuple.Pair<Integer, ItemStack>(quantity, output));
    }

    public static Tuple.Pair<Integer, ItemStack> getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static HashMap<ItemStack, ItemStack> getRecipes() {
        HashMap<ItemStack, ItemStack> recipes = new HashMap<ItemStack, ItemStack>();
        for (Map.Entry<FluidType, Tuple.Pair<Integer, ItemStack>> entry : SolidificationRecipes.recipes.entrySet()) {
            FluidType type = entry.getKey();
            int amount = entry.getValue().getKey();
            ItemStack out = entry.getValue().getValue().func_77946_l();
            recipes.put(ItemFluidIcon.make(type, amount), out);
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmSolidifier.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidStack in = SolidificationRecipes.readFluidStack(obj.get("input").getAsJsonArray());
        ItemStack out = SolidificationRecipes.readItemStack(obj.get("output").getAsJsonArray());
        recipes.put(in.type, new Tuple.Pair<Integer, ItemStack>(in.fill, out));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        FluidStack in = new FluidStack((FluidType)rec.getKey(), (Integer)((Tuple.Pair)rec.getValue()).getKey());
        writer.name("input");
        SolidificationRecipes.writeFluidStack(in, writer);
        writer.name("output");
        SolidificationRecipes.writeItemStack((ItemStack)((Tuple.Pair)rec.getValue()).getValue(), writer);
    }
}

