/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.ItemStackUtil;
import com.hbm.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RefineryRecipes {
    public static final int oil_frac_heavy = 50;
    public static final int oil_frac_naph = 25;
    public static final int oil_frac_light = 15;
    public static final int oil_frac_petro = 10;
    public static final int crack_frac_naph = 40;
    public static final int crack_frac_light = 30;
    public static final int crack_frac_aroma = 15;
    public static final int crack_frac_unsat = 15;
    public static final int oilds_frac_heavy = 30;
    public static final int oilds_frac_naph = 35;
    public static final int oilds_frac_light = 20;
    public static final int oilds_frac_unsat = 15;
    public static final int crackds_frac_naph = 35;
    public static final int crackds_frac_light = 35;
    public static final int crackds_frac_aroma = 15;
    public static final int crackds_frac_unsat = 15;
    public static final int vac_frac_heavy = 40;
    public static final int vac_frac_reform = 25;
    public static final int vac_frac_light = 20;
    public static final int vac_frac_sour = 15;
    private static Map<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>> refinery = new HashMap<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>>();
    private static Map<FluidType, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>> vacuum = new HashMap<FluidType, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>>();

    public static HashMap<Object, Object[]> getRefineryRecipe() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        for (Map.Entry<FluidType, Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>> recipe : refinery.entrySet()) {
            Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack> fluids = recipe.getValue();
            recipes.put(ItemFluidIcon.make(recipe.getKey(), 1000), new ItemStack[]{ItemFluidIcon.make(fluids.getV().type, fluids.getV().fill * 10), ItemFluidIcon.make(fluids.getW().type, fluids.getW().fill * 10), ItemFluidIcon.make(fluids.getX().type, fluids.getX().fill * 10), ItemFluidIcon.make(fluids.getY().type, fluids.getY().fill * 10), ItemStackUtil.carefulCopy(fluids.getZ())});
        }
        return recipes;
    }

    public static HashMap getVacuumRecipe() {
        HashMap<ItemStack, ItemStack[]> recipes = new HashMap<ItemStack, ItemStack[]>();
        for (Map.Entry<FluidType, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>> recipe : vacuum.entrySet()) {
            Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> fluids = recipe.getValue();
            recipes.put(ItemFluidIcon.make(recipe.getKey(), 1000, 2), new ItemStack[]{ItemFluidIcon.make(fluids.getW().type, fluids.getW().fill * 10), ItemFluidIcon.make(fluids.getX().type, fluids.getX().fill * 10), ItemFluidIcon.make(fluids.getY().type, fluids.getY().fill * 10), ItemFluidIcon.make(fluids.getZ().type, fluids.getZ().fill * 10)});
        }
        return recipes;
    }

    public static void registerRefinery() {
        refinery.put(Fluids.HOTOIL, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.HEAVYOIL, 50), new FluidStack(Fluids.NAPHTHA, 25), new FluidStack(Fluids.LIGHTOIL, 15), new FluidStack(Fluids.PETROLEUM, 10), new ItemStack(ModItems.sulfur)));
        refinery.put(Fluids.HOTCRACKOIL, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.NAPHTHA_CRACK, 40), new FluidStack(Fluids.LIGHTOIL_CRACK, 30), new FluidStack(Fluids.AROMATICS, 15), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.CRACK)));
        refinery.put(Fluids.HOTOIL_DS, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.HEAVYOIL, 30), new FluidStack(Fluids.NAPHTHA_DS, 35), new FluidStack(Fluids.LIGHTOIL_DS, 20), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)));
        refinery.put(Fluids.HOTCRACKOIL_DS, new Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack>(new FluidStack(Fluids.NAPHTHA_DS, 35), new FluidStack(Fluids.LIGHTOIL_DS, 35), new FluidStack(Fluids.AROMATICS, 15), new FluidStack(Fluids.UNSATURATEDS, 15), OreDictManager.DictFrame.fromOne(ModItems.oil_tar, (Enum)ItemEnums.EnumTarType.PARAFFIN)));
        vacuum.put(Fluids.OIL, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.HEAVYOIL_VACUUM, 40), new FluidStack(Fluids.REFORMATE, 25), new FluidStack(Fluids.LIGHTOIL_VACUUM, 20), new FluidStack(Fluids.SOURGAS, 15)));
        vacuum.put(Fluids.OIL_DS, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.HEAVYOIL_VACUUM, 40), new FluidStack(Fluids.REFORMATE, 25), new FluidStack(Fluids.LIGHTOIL_VACUUM, 20), new FluidStack(Fluids.REFORMGAS, 15)));
        vacuum.put(Fluids.TCRUDE, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.HALOLIGHT, 40), new FluidStack(Fluids.CHLOROMETHANE, 25), new FluidStack(Fluids.HCL, 20), new FluidStack(Fluids.HGAS, 15)));
    }

    public static Tuple.Quintet<FluidStack, FluidStack, FluidStack, FluidStack, ItemStack> getRefinery(FluidType oil) {
        return refinery.get(oil);
    }

    public static Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> getVacuum(FluidType oil) {
        return vacuum.get(oil);
    }
}

