/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.CrackingRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class RadiolysisRecipes {
    private static Map<FluidType, Tuple.Pair<FluidStack, FluidStack>> radiolysis = new HashMap<FluidType, Tuple.Pair<FluidStack, FluidStack>>();

    public static Map<Object, Object[]> getRecipesForNEI() {
        HashMap<Object, Object[]> recipes = new HashMap<Object, Object[]>();
        for (Map.Entry<FluidType, Tuple.Pair<FluidStack, FluidStack>> entry : radiolysis.entrySet()) {
            Tuple.Pair<FluidStack, FluidStack> pair = entry.getValue();
            ItemStack[] outputs = new ItemStack[]{pair.getKey().type == Fluids.NONE ? new ItemStack(ModItems.nothing) : ItemFluidIcon.make(pair.getKey().type, pair.getKey().fill), pair.getValue().type == Fluids.NONE ? new ItemStack(ModItems.nothing) : ItemFluidIcon.make(pair.getValue().type, pair.getValue().fill)};
            recipes.put(ItemFluidIcon.make(entry.getKey(), 100), outputs);
        }
        return recipes;
    }

    public static void registerRadiolysis() {
        radiolysis.put(Fluids.WATER, new Tuple.Pair<FluidStack, FluidStack>(new FluidStack(80, Fluids.PEROXIDE), new FluidStack(20, Fluids.HYDROGEN)));
        Map<FluidType, Tuple.Pair<FluidStack, FluidStack>> cracking = CrackingRecipes.getCrackingRecipes();
        if (cracking.isEmpty()) {
            throw new IllegalStateException("RefineryRecipes.getCrackingRecipes has yielded an empty map while registering the radiolysis recipes! Either the load order is broken or cracking recipes have been removed!");
        }
        for (Map.Entry<FluidType, Tuple.Pair<FluidStack, FluidStack>> recipe : cracking.entrySet()) {
            radiolysis.put(recipe.getKey(), recipe.getValue());
        }
    }

    public static Tuple.Pair<FluidStack, FluidStack> getRadiolysis(FluidType input) {
        return radiolysis.get(input);
    }
}

