/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.BlockEnums;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class MixerRecipes
extends SerializableRecipe {
    public static HashMap<FluidType, MixerRecipe[]> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        MixerRecipes.register(Fluids.COOLANT, new MixerRecipe(2000, 50).setStack1(new FluidStack(Fluids.WATER, 1800)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())));
        MixerRecipes.register(Fluids.CRYOGEL, new MixerRecipe(2000, 50).setStack1(new FluidStack(Fluids.COOLANT, 1800)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_ice)));
        MixerRecipes.register(Fluids.NITAN, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.KEROSENE, 600)).setStack2(new FluidStack(Fluids.MERCURY, 200)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_nitan_mix)));
        MixerRecipes.register(Fluids.FRACKSOL, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.SULFURIC_ACID, 900)).setStack2(new FluidStack(Fluids.PETROLEUM, 100)), new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.WATER, 1000)).setStack2(new FluidStack(Fluids.PETROLEUM, 100)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.S.dust())));
        MixerRecipes.register(Fluids.ENDERJUICE, new MixerRecipe(100, 100).setStack1(new FluidStack(Fluids.XPJUICE, 500)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.DIAMOND.dust())));
        MixerRecipes.register(Fluids.SALIENT, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.SEEDSLURRY, 500)).setStack2(new FluidStack(Fluids.BLOOD, 500)));
        MixerRecipes.register(Fluids.COLLOID, new MixerRecipe(500, 20).setStack1(new FluidStack(Fluids.WATER, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.dust)));
        MixerRecipes.register(Fluids.PHOSGENE, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.UNSATURATEDS, 500)).setStack2(new FluidStack(Fluids.CHLORINE, 500)));
        MixerRecipes.register(Fluids.MUSTARDGAS, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.REFORMGAS, 750)).setStack2(new FluidStack(Fluids.CHLORINE, 250)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.S.dust())));
        MixerRecipes.register(Fluids.IONGEL, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.WATER, 1000)).setStack2(new FluidStack(Fluids.HYDROGEN, 200)).setSolid(new RecipesCommon.ComparableStack(ModItems.pellet_charged)));
        MixerRecipes.register(Fluids.EGG, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.RADIOSOLVENT, 500)).setSolid(new RecipesCommon.ComparableStack(Items.field_151110_aK)));
        MixerRecipes.register(Fluids.FISHOIL, new MixerRecipe(100, 50).setSolid(new RecipesCommon.ComparableStack(Items.field_151115_aP, 1, Short.MAX_VALUE)));
        MixerRecipes.register(Fluids.SUNFLOWEROIL, new MixerRecipe(100, 50).setSolid(new RecipesCommon.ComparableStack((Block)Blocks.field_150398_cm, 1, 0)));
        MixerRecipes.register(Fluids.FULLERENE, new MixerRecipe(250, 50).setStack1(new FluidStack(Fluids.RADIOSOLVENT, 500)).setSolid(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.powder_ash, (Enum)ItemEnums.EnumAshType.SOOT))));
        MixerRecipes.register(Fluids.SOLVENT, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.NAPHTHA, 500)).setStack2(new FluidStack(Fluids.AROMATICS, 500)), new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.NAPHTHA_CRACK, 500)).setStack2(new FluidStack(Fluids.AROMATICS, 500)), new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.NAPHTHA_DS, 500)).setStack2(new FluidStack(Fluids.AROMATICS, 500)), new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.NAPHTHA_COKER, 500)).setStack2(new FluidStack(Fluids.AROMATICS, 500)));
        MixerRecipes.register(Fluids.SULFURIC_ACID, new MixerRecipe(500, 50).setStack1(new FluidStack(Fluids.PEROXIDE, 800)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.S.dust())));
        MixerRecipes.register(Fluids.NITRIC_ACID, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.AMMONIA, 1000)).setStack2(new FluidStack(Fluids.WATER, 500)), new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.SULFURIC_ACID, 500)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.KNO.dust())));
        MixerRecipes.register(Fluids.RADIOSOLVENT, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.REFORMGAS, 750)).setStack2(new FluidStack(Fluids.CHLORINE, 250)), new MixerRecipe(5000, 20).setStack1(new FluidStack(Fluids.REFORMGAS, 500)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.geysir_chloric)));
        MixerRecipes.register(Fluids.SCHRABIDIC, new MixerRecipe(16000, 100).setStack1(new FluidStack(Fluids.SAS3, 8000)).setStack2(new FluidStack(Fluids.PEROXIDE, 6000)).setSolid(new RecipesCommon.ComparableStack(ModItems.pellet_charged)));
        MixerRecipes.register(Fluids.PETROIL, new MixerRecipe(1000, 30).setStack1(new FluidStack(Fluids.RECLAIMED, 800)).setStack2(new FluidStack(Fluids.LUBRICANT, 200)));
        MixerRecipes.register(Fluids.LUBRICANT, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.HEATINGOIL, 500)).setStack2(new FluidStack(Fluids.UNSATURATEDS, 500)), new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.FISHOIL, 800)).setStack2(new FluidStack(Fluids.ETHANOL, 200)), new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.SUNFLOWEROIL, 800)).setStack2(new FluidStack(Fluids.ETHANOL, 200)));
        MixerRecipes.register(Fluids.BIOFUEL, new MixerRecipe(250, 20).setStack1(new FluidStack(Fluids.FISHOIL, 500)).setStack2(new FluidStack(Fluids.WOODOIL, 500)), new MixerRecipe(200, 20).setStack1(new FluidStack(Fluids.SUNFLOWEROIL, 500)).setStack2(new FluidStack(Fluids.WOODOIL, 500)));
        MixerRecipes.register(Fluids.NITROGLYCERIN, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.PETROLEUM, 1000)).setStack2(new FluidStack(Fluids.NITRIC_ACID, 1000)), new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.FISHOIL, 500)).setStack2(new FluidStack(Fluids.NITRIC_ACID, 500)));
        MixerRecipes.register(Fluids.THORIUM_SALT, new MixerRecipe(1000, 30).setStack1(new FluidStack(Fluids.CHLORINE, 1000)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.TH232.dust())));
        MixerRecipes.register(Fluids.SYNGAS, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.COALOIL, 500)).setStack2(new FluidStack(Fluids.STEAM, 500)));
        MixerRecipes.register(Fluids.OXYHYDROGEN, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.HYDROGEN, 500)).setStack2(new FluidStack(Fluids.OXYGEN, 500)));
        MixerRecipes.register(Fluids.PETROIL_LEADED, new MixerRecipe(12000, 40).setStack1(new FluidStack(Fluids.PETROIL, 10000)).setSolid(new RecipesCommon.ComparableStack(ModItems.fuel_additive, 1, 0)));
        MixerRecipes.register(Fluids.GASOLINE_LEADED, new MixerRecipe(12000, 40).setStack1(new FluidStack(Fluids.GASOLINE, 10000)).setSolid(new RecipesCommon.ComparableStack(ModItems.fuel_additive, 1, 0)));
        MixerRecipes.register(Fluids.COALGAS_LEADED, new MixerRecipe(12000, 40).setStack1(new FluidStack(Fluids.COALGAS, 10000)).setSolid(new RecipesCommon.ComparableStack(ModItems.fuel_additive, 1, 0)));
        MixerRecipes.register(Fluids.DIESEL_REFORM, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.DIESEL, 900)).setStack2(new FluidStack(Fluids.REFORMATE, 100)));
        MixerRecipes.register(Fluids.DIESEL_CRACK_REFORM, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.DIESEL_CRACK, 900)).setStack2(new FluidStack(Fluids.REFORMATE, 100)));
        MixerRecipes.register(Fluids.KEROSENE_REFORM, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.KEROSENE, 900)).setStack2(new FluidStack(Fluids.REFORMATE, 100)));
        MixerRecipes.register(Fluids.SMILK, new MixerRecipe(500, 50).setStack1(new FluidStack(Fluids.MILK, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.strawberry, 4)));
        MixerRecipes.register(Fluids.COFFEE, new MixerRecipe(100, 50).setStack1(new FluidStack(Fluids.WATER, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_coffee, 4)));
        MixerRecipes.register(Fluids.TEA, new MixerRecipe(200, 50).setStack1(new FluidStack(Fluids.WATER, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.tea_leaf, 2)));
        MixerRecipes.register(Fluids.ELBOWGREASE, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.REFORMGAS, 500)).setStack2(new FluidStack(Fluids.SYNGAS, 500)));
        MixerRecipes.register(Fluids.HTCO4, new MixerRecipe(250, 50).setStack1(new FluidStack(Fluids.NITRIC_ACID, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.nugget_technetium)));
        MixerRecipes.register(Fluids.MINSOL, new MixerRecipe(500, 50).setStack1(new FluidStack(Fluids.NITRIC_ACID, 500)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.ore_mineral, 1, Short.MAX_VALUE)));
        MixerRecipes.register(Fluids.REDMUD, new MixerRecipe(50, 100).setStack1(new FluidStack(Fluids.HCL, 1400)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.duna_sands, 4)));
        MixerRecipes.register(Fluids.DICYANOACETYLENE, new MixerRecipe(750, 50).setStack1(new FluidStack(Fluids.AMMONIA, 300)).setStack2(new FluidStack(Fluids.UNSATURATEDS, 500)));
        MixerRecipes.register(Fluids.CHLOROCALCITE_SOLUTION, new MixerRecipe(500, 50).setStack1(new FluidStack(Fluids.WATER, 250)).setStack2(new FluidStack(Fluids.NITRIC_ACID, 250)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.CHLOROCALCITE.dust())));
        MixerRecipes.register(Fluids.CHLOROCALCITE_MIX, new MixerRecipe(1000, 50).setStack1(new FluidStack(Fluids.CHLOROCALCITE_SOLUTION, 500)).setStack2(new FluidStack(Fluids.SULFURIC_ACID, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_flux)));
        MixerRecipes.register(Fluids.PHEROMONE_M, new MixerRecipe(2000, 10).setStack1(new FluidStack(Fluids.PHEROMONE, 1500)).setStack2(new FluidStack(Fluids.BLOOD, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.pill_herbal)));
        MixerRecipes.register(Fluids.ETHANOL, new MixerRecipe(450, 30).setStack1(new FluidStack(Fluids.CHLOROETHANE, 250)).setStack2(new FluidStack(Fluids.REDMUD, 300)));
        MixerRecipes.register(Fluids.SCUTTERBLOOD, new MixerRecipe(550, 50).setStack1(new FluidStack(Fluids.HCL, 300)).setSolid(new RecipesCommon.ComparableStack(ModItems.scuttertail)));
        MixerRecipes.register(Fluids.BAUXITE_SOLUTION, new MixerRecipe(300, 80).setStack1(new FluidStack(Fluids.LYE, 50)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.stone_resource, 1, BlockEnums.EnumStoneType.BAUXITE.ordinal())));
        MixerRecipes.register(Fluids.LYE, new MixerRecipe(50, 100).setStack1(new FluidStack(Fluids.WATER, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_ash, 2, ItemEnums.EnumAshType.WOOD)));
        MixerRecipes.register(Fluids.ALUMINA, new MixerRecipe(200, 40).setStack1(new FluidStack(Fluids.SODIUM_ALUMINATE, 150)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.F.dust(), 3)), new MixerRecipe(300, 40).setStack1(new FluidStack(Fluids.SODIUM_ALUMINATE, 150)).setSolid(new RecipesCommon.ComparableStack(OreDictManager.DictFrame.fromOne(ModItems.chunk_ore, (Enum)ItemEnums.EnumChunkType.CRYOLITE))));
        MixerRecipes.register(Fluids.CONGLOMERA, new MixerRecipe(1000, 70).setStack1(new FluidStack(Fluids.SULFURIC_ACID, 350)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.stone_resource, 1, BlockEnums.EnumStoneType.CONGLOMERATE.ordinal())));
        MixerRecipes.register(Fluids.AQUEOUS_NICKEL, new MixerRecipe(1000, 80).setStack1(new FluidStack(Fluids.BRINE, 250)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.NIM.dust())));
        MixerRecipes.register(Fluids.AQUEOUS_COPPER, new MixerRecipe(1000, 80).setStack1(new FluidStack(Fluids.BRINE, 250)).setSolid(new RecipesCommon.ComparableStack(ModItems.chunk_ore, 1, ItemEnums.EnumChunkType.MALACHITE)));
        MixerRecipes.register(Fluids.PERFLUOROMETHYL, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.PETROLEUM, 1000)).setStack2(new FluidStack(Fluids.UNSATURATEDS, 500)).setSolid(new RecipesCommon.OreDictStack(OreDictManager.F.dust())));
        MixerRecipes.register(Fluids.VINYL, new MixerRecipe(1000, 20).setStack1(new FluidStack(Fluids.RADIOSOLVENT, 250)).setSolid(new RecipesCommon.ComparableStack(ModBlocks.pvc_log)), new MixerRecipe(500, 20).setStack1(new FluidStack(Fluids.RADIOSOLVENT, 125)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_pvc)), new MixerRecipe(500, 20).setStack1(new FluidStack(Fluids.HGAS, 500)).setStack2(new FluidStack(Fluids.UNSATURATEDS, 250)).setSolid(new RecipesCommon.ComparableStack(ModItems.powder_cadmium)));
        MixerRecipes.register(Fluids.CBENZ, new MixerRecipe(250, 20).setStack1(new FluidStack(Fluids.HCL, 500)).setSolid(new RecipesCommon.ComparableStack(ModItems.leaf_pet, 32)));
    }

    public static void register(FluidType type, MixerRecipe ... rec) {
        recipes.put(type, rec);
    }

    public static MixerRecipe[] getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static MixerRecipe getOutput(FluidType type, int index) {
        MixerRecipe[] recs = recipes.get(type);
        if (recs == null) {
            return null;
        }
        return recs[index % recs.length];
    }

    @Override
    public String getFileName() {
        return "hbmMixer.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidType outputType = Fluids.fromName(obj.get("outputType").getAsString());
        JsonArray recipeArray = obj.get("recipes").getAsJsonArray();
        MixerRecipe[] array = new MixerRecipe[recipeArray.size()];
        for (int i = 0; i < recipeArray.size(); ++i) {
            JsonObject sub = recipeArray.get(i).getAsJsonObject();
            MixerRecipe mix = new MixerRecipe(sub.get("outputAmount").getAsInt(), sub.get("duration").getAsInt());
            if (sub.has("input1")) {
                mix.setStack1(MixerRecipes.readFluidStack(sub.get("input1").getAsJsonArray()));
            }
            if (sub.has("input2")) {
                mix.setStack2(MixerRecipes.readFluidStack(sub.get("input2").getAsJsonArray()));
            }
            if (sub.has("solidInput")) {
                mix.setSolid(MixerRecipes.readAStack(sub.get("solidInput").getAsJsonArray()));
            }
            array[i] = mix;
        }
        recipes.put(outputType, array);
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        MixerRecipe[] recipes = (MixerRecipe[])rec.getValue();
        writer.name("outputType").value(((FluidType)rec.getKey()).getName());
        writer.name("recipes").beginArray();
        for (MixerRecipe mix : recipes) {
            writer.beginObject();
            writer.name("duration").value((long)mix.processTime);
            writer.name("outputAmount").value((long)mix.output);
            if (mix.input1 != null) {
                writer.name("input1");
                MixerRecipes.writeFluidStack(mix.input1, writer);
            }
            if (mix.input2 != null) {
                writer.name("input2");
                MixerRecipes.writeFluidStack(mix.input2, writer);
            }
            if (mix.solidInput != null) {
                writer.name("solidInput");
                MixerRecipes.writeAStack(mix.solidInput, writer);
            }
            writer.endObject();
        }
        writer.endArray();
    }

    public static HashMap getRecipes() {
        HashMap<Object[], ItemStack> recipes = new HashMap<Object[], ItemStack>();
        for (Map.Entry<FluidType, MixerRecipe[]> entry : MixerRecipes.recipes.entrySet()) {
            MixerRecipe[] recs;
            FluidType type = entry.getKey();
            for (MixerRecipe recipe : recs = entry.getValue()) {
                FluidStack output = new FluidStack(type, recipe.output);
                ArrayList<Object> objects = new ArrayList<Object>();
                if (recipe.input1 != null) {
                    objects.add(ItemFluidIcon.make(recipe.input1));
                }
                if (recipe.input2 != null) {
                    objects.add(ItemFluidIcon.make(recipe.input2));
                }
                if (recipe.solidInput != null) {
                    objects.add(recipe.solidInput);
                }
                recipes.put(objects.toArray(), ItemFluidIcon.make(output));
            }
        }
        return recipes;
    }

    public static class MixerRecipe {
        public FluidStack input1;
        public FluidStack input2;
        public RecipesCommon.AStack solidInput;
        public int processTime;
        public int output;

        protected MixerRecipe(int output, int processTime) {
            this.output = output;
            this.processTime = processTime;
        }

        protected MixerRecipe setStack1(FluidStack stack) {
            this.input1 = stack;
            return this;
        }

        protected MixerRecipe setStack2(FluidStack stack) {
            this.input2 = stack;
            return this;
        }

        protected MixerRecipe setSolid(RecipesCommon.AStack stack) {
            this.solidInput = stack;
            return this;
        }
    }
}

