/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.blocks.ModBlocks;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.OreDictManager;
import com.hbm.inventory.RecipesCommon;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;

public class LiquefactionRecipes
extends SerializableRecipe {
    public static HashMap<Object, FluidStack> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put(OreDictManager.COAL.gem(), new FluidStack(100, Fluids.COALOIL));
        recipes.put(OreDictManager.COAL.dust(), new FluidStack(100, Fluids.COALOIL));
        recipes.put(OreDictManager.LIGNITE.gem(), new FluidStack(50, Fluids.COALOIL));
        recipes.put(OreDictManager.LIGNITE.dust(), new FluidStack(50, Fluids.COALOIL));
        recipes.put("oiltar", new FluidStack(75, Fluids.BITUMEN));
        recipes.put("cracktar", new FluidStack(100, Fluids.BITUMEN));
        recipes.put("coaltar", new FluidStack(50, Fluids.BITUMEN));
        recipes.put("logWood", new FluidStack(100, Fluids.MUG));
        recipes.put(OreDictManager.NA.dust(), new FluidStack(100, Fluids.SODIUM));
        recipes.put(OreDictManager.PB.ingot(), new FluidStack(100, Fluids.LEAD));
        recipes.put(OreDictManager.PB.dust(), new FluidStack(100, Fluids.LEAD));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150424_aL), new FluidStack(250, Fluids.LAVA));
        recipes.put("cobblestone", new FluidStack(250, Fluids.LAVA));
        recipes.put("stone", new FluidStack(250, Fluids.LAVA));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150343_Z), new FluidStack(500, Fluids.LAVA));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151126_ay), new FluidStack(125, Fluids.WATER));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150433_aE), new FluidStack(500, Fluids.WATER));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150432_aD), new FluidStack(1000, Fluids.WATER));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150403_cj), new FluidStack(2000, Fluids.WATER));
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.dry_ice), new FluidStack(1000, Fluids.CARBONDIOXIDE));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151079_bi), new FluidStack(100, Fluids.ENDERJUICE));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.pellet_charged), new FluidStack(4000, Fluids.HELIUM4));
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.ore_oil_sand), new FluidStack(100, Fluids.BITUMEN));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151102_aT), new FluidStack(100, Fluids.ETHANOL));
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.plant_flower, 1, 3), new FluidStack(150, Fluids.ETHANOL));
        recipes.put(new RecipesCommon.ComparableStack(ModBlocks.plant_flower, 1, 4), new FluidStack(50, Fluids.ETHANOL));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.biomass), new FluidStack(125, Fluids.BIOGAS));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.glyphid_gland_empty), new FluidStack(2000, Fluids.BIOGAS));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151115_aP, 1, Short.MAX_VALUE), new FluidStack(100, Fluids.FISHOIL));
        recipes.put(new RecipesCommon.ComparableStack((Block)Blocks.field_150398_cm, 1, 0), new FluidStack(100, Fluids.SUNFLOWEROIL));
        recipes.put(new RecipesCommon.ComparableStack(Items.field_151014_N), new FluidStack(50, Fluids.SEEDSLURRY));
        recipes.put(new RecipesCommon.ComparableStack((Block)Blocks.field_150329_H, 1, 1), new FluidStack(100, Fluids.SEEDSLURRY));
        recipes.put(new RecipesCommon.ComparableStack((Block)Blocks.field_150329_H, 1, 2), new FluidStack(100, Fluids.SEEDSLURRY));
        recipes.put(new RecipesCommon.ComparableStack(Blocks.field_150395_bd), new FluidStack(100, Fluids.SEEDSLURRY));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.flesh), new FluidStack(100, Fluids.BLOOD));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.ingot_osmiridium), new FluidStack(24000, Fluids.ETHANOL));
    }

    public static FluidStack getOutput(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, stack.func_77960_j());
        if (recipes.containsKey(comp)) {
            return recipes.get(comp);
        }
        String[] dictKeys = comp.getDictKeys();
        comp = new RecipesCommon.ComparableStack(stack.func_77973_b(), 1, Short.MAX_VALUE);
        if (recipes.containsKey(comp)) {
            return recipes.get(comp);
        }
        for (String key : dictKeys) {
            if (!recipes.containsKey(key)) continue;
            return recipes.get(key);
        }
        if (stack.func_77973_b() instanceof ItemFood) {
            ItemFood food = (ItemFood)stack.func_77973_b();
            float saturation = (float)food.func_150905_g(stack) * food.func_150906_h(stack) * 20.0f;
            return new FluidStack(Fluids.SALIENT, (int)saturation);
        }
        return null;
    }

    public static HashMap<Object, ItemStack> getRecipes() {
        HashMap<Object, ItemStack> recipes = new HashMap<Object, ItemStack>();
        for (Map.Entry<Object, FluidStack> entry : LiquefactionRecipes.recipes.entrySet()) {
            FluidStack out = entry.getValue();
            if (entry.getKey() instanceof String) {
                recipes.put(new RecipesCommon.OreDictStack((String)entry.getKey()), ItemFluidIcon.make(out.type, out.fill));
                continue;
            }
            recipes.put(((RecipesCommon.ComparableStack)entry.getKey()).toStack(), ItemFluidIcon.make(out.type, out.fill));
        }
        return recipes;
    }

    @Override
    public String getFileName() {
        return "hbmLiquefactor.json";
    }

    @Override
    public String getComment() {
        return "As with most handlers, stacksizes for the inputs are ignored and default to 1.";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        RecipesCommon.AStack in = LiquefactionRecipes.readAStack(obj.get("input").getAsJsonArray());
        FluidStack out = LiquefactionRecipes.readFluidStack(obj.get("output").getAsJsonArray());
        if (in instanceof RecipesCommon.ComparableStack) {
            recipes.put(((RecipesCommon.ComparableStack)in).makeSingular(), out);
        } else if (in instanceof RecipesCommon.OreDictStack) {
            recipes.put(((RecipesCommon.OreDictStack)in).name, out);
        }
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        Object key = rec.getKey();
        writer.name("input");
        if (key instanceof String) {
            LiquefactionRecipes.writeAStack(new RecipesCommon.OreDictStack((String)key), writer);
        } else if (key instanceof RecipesCommon.ComparableStack) {
            LiquefactionRecipes.writeAStack((RecipesCommon.ComparableStack)key, writer);
        }
        writer.name("output");
        LiquefactionRecipes.writeFluidStack((FluidStack)rec.getValue(), writer);
    }
}

