/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.inventory.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.hbm.inventory.FluidStack;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.recipes.loader.SerializableRecipe;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.util.Tuple;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class CryoRecipes
extends SerializableRecipe {
    private static HashMap<FluidType, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>> recipes = new HashMap();

    @Override
    public void registerDefaults() {
        recipes.put(Fluids.AIR, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.NITROGEN, 60), new FluidStack(Fluids.OXYGEN, 25), new FluidStack(Fluids.KRYPTON, 10), new FluidStack(Fluids.CARBONDIOXIDE, 5)));
        recipes.put(Fluids.TEKTOAIR, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.CHLOROMETHANE, 55), new FluidStack(Fluids.CHLORINE, 25), new FluidStack(Fluids.GAS, 15), new FluidStack(Fluids.HCL, 5)));
        recipes.put(Fluids.JOOLGAS, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.HELIUM3, 40), new FluidStack(Fluids.HYDROGEN, 30), new FluidStack(Fluids.CHLORINE, 20), new FluidStack(Fluids.NEON, 10)));
        recipes.put(Fluids.NGAS, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.GAS, 45), new FluidStack(Fluids.AMMONIA, 25), new FluidStack(Fluids.UNSATURATEDS, 15), new FluidStack(Fluids.XENON, 15)));
        recipes.put(Fluids.UGAS, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.OXYGEN, 45), new FluidStack(Fluids.NITROGEN, 25), new FluidStack(Fluids.METHANOL, 15), new FluidStack(Fluids.AROMATICS, 15)));
        recipes.put(Fluids.SARNUSGAS, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.HYDROGEN, 45), new FluidStack(Fluids.HELIUM3, 35), new FluidStack(Fluids.GAS, 15), new FluidStack(Fluids.NITROGEN, 5)));
        recipes.put(Fluids.EVEAIR, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.KMnO4, 40), new FluidStack(Fluids.MERCURY, 35), new FluidStack(Fluids.XENON, 15), new FluidStack(Fluids.AMMONIA, 10)));
        recipes.put(Fluids.DUNAAIR, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(new FluidStack(Fluids.CARBONDIOXIDE, 70), new FluidStack(Fluids.NITROGEN, 15), new FluidStack(Fluids.ARGON, 10), new FluidStack(Fluids.OXYGEN, 5)));
    }

    public static Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack> getOutput(FluidType type) {
        return recipes.get(type);
    }

    public static HashMap<Object, Object> getCryoRecipes() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Map.Entry<FluidType, Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>> recipe : recipes.entrySet()) {
            map.put(ItemFluidIcon.make(recipe.getKey(), 1000), new ItemStack[]{ItemFluidIcon.make(recipe.getValue().getW().type, recipe.getValue().getW().fill * 10), ItemFluidIcon.make(recipe.getValue().getX().type, recipe.getValue().getX().fill * 10), ItemFluidIcon.make(recipe.getValue().getY().type, recipe.getValue().getY().fill * 10), ItemFluidIcon.make(recipe.getValue().getZ().type, recipe.getValue().getZ().fill * 10)});
        }
        return map;
    }

    @Override
    public String getFileName() {
        return "hbmCryodistillator.json";
    }

    @Override
    public Object getRecipeObject() {
        return recipes;
    }

    @Override
    public void readRecipe(JsonElement recipe) {
        JsonObject obj = (JsonObject)recipe;
        FluidType input = Fluids.fromName(obj.get("input").getAsString());
        FluidStack output1 = CryoRecipes.readFluidStack(obj.get("output1").getAsJsonArray());
        FluidStack output2 = CryoRecipes.readFluidStack(obj.get("output2").getAsJsonArray());
        FluidStack output3 = CryoRecipes.readFluidStack(obj.get("output3").getAsJsonArray());
        FluidStack output4 = CryoRecipes.readFluidStack(obj.get("output4").getAsJsonArray());
        recipes.put(input, new Tuple.Quartet<FluidStack, FluidStack, FluidStack, FluidStack>(output1, output2, output3, output4));
    }

    @Override
    public void writeRecipe(Object recipe, JsonWriter writer) throws IOException {
        Map.Entry rec = (Map.Entry)recipe;
        writer.name("input").value(((FluidType)rec.getKey()).getName());
        writer.name("output1");
        CryoRecipes.writeFluidStack((FluidStack)((Tuple.Quartet)rec.getValue()).getW(), writer);
        writer.name("output2");
        CryoRecipes.writeFluidStack((FluidStack)((Tuple.Quartet)rec.getValue()).getZ(), writer);
        writer.name("output3");
        CryoRecipes.writeFluidStack((FluidStack)((Tuple.Quartet)rec.getValue()).getY(), writer);
        writer.name("output4");
        CryoRecipes.writeFluidStack((FluidStack)((Tuple.Quartet)rec.getValue()).getX(), writer);
    }

    @Override
    public void deleteRecipes() {
        recipes.clear();
    }
}

